/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain.features.player.helpers;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.dubhe.curtain.CurtainRules;
import dev.dubhe.curtain.features.player.menu.MenuHashMap;
import dev.dubhe.curtain.features.player.patches.EntityPlayerMPFake;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;

public class FakePlayerResident {
    public static void onServerStop(MinecraftServer server) {
        if (CurtainRules.fakePlayerResident) {
            JsonObject fakePlayerList = new JsonObject();
            MenuHashMap.FAKE_PLAYER_INVENTORY_MENU_MAP.forEach((player, fakePlayerInventoryContainer) -> {
                if (!(player instanceof EntityPlayerMPFake)) {
                    return;
                }
                String username = player.m_7755_().getString();
                fakePlayerList.add(username, (JsonElement)FakePlayerResident.save(player));
            });
            File file = server.m_129843_(LevelResource.f_78182_).resolve("fake_player.gca.json").toFile();
            if (!file.isFile()) {
                try {
                    file.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try (BufferedWriter bfw = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                bfw.write(new Gson().toJson((JsonElement)fakePlayerList));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        MenuHashMap.FAKE_PLAYER_INVENTORY_MENU_MAP.clear();
    }

    public static void onServerStart(MinecraftServer server) {
        if (CurtainRules.fakePlayerResident) {
            JsonObject fakePlayerList = new JsonObject();
            File file = server.m_129843_(LevelResource.f_78182_).resolve("fake_player.gca.json").toFile();
            if (!file.isFile()) {
                return;
            }
            try (BufferedReader bfr = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);){
                fakePlayerList = (JsonObject)new Gson().fromJson((Reader)bfr, JsonObject.class);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            for (Map.Entry entry : fakePlayerList.entrySet()) {
                FakePlayerResident.load(entry, server);
            }
            file.delete();
        }
    }

    public static JsonObject save(Player player) {
        double pos_x = player.m_20185_();
        double pos_y = player.m_20186_();
        double pos_z = player.m_20189_();
        double yaw = player.m_146908_();
        double pitch = player.m_146909_();
        String dimension = player.f_19853_.m_46472_().m_135782_().m_135815_();
        String gamemode = ((ServerPlayer)player).f_8941_.m_9290_().m_46405_();
        boolean flying = player.m_150110_().f_35935_;
        JsonObject fakePlayer = new JsonObject();
        fakePlayer.addProperty("pos_x", (Number)pos_x);
        fakePlayer.addProperty("pos_y", (Number)pos_y);
        fakePlayer.addProperty("pos_z", (Number)pos_z);
        fakePlayer.addProperty("yaw", (Number)yaw);
        fakePlayer.addProperty("pitch", (Number)pitch);
        fakePlayer.addProperty("dimension", dimension);
        fakePlayer.addProperty("gamemode", gamemode);
        fakePlayer.addProperty("flying", Boolean.valueOf(flying));
        return fakePlayer;
    }

    public static void load(Map.Entry<String, JsonElement> entry, MinecraftServer server) {
        String username = entry.getKey();
        JsonObject fakePlayer = entry.getValue().getAsJsonObject();
        double pos_x = fakePlayer.get("pos_x").getAsDouble();
        double pos_y = fakePlayer.get("pos_y").getAsDouble();
        double pos_z = fakePlayer.get("pos_z").getAsDouble();
        double yaw = fakePlayer.get("yaw").getAsDouble();
        double pitch = fakePlayer.get("pitch").getAsDouble();
        String dimension = fakePlayer.get("dimension").getAsString();
        String gamemode = fakePlayer.get("gamemode").getAsString();
        boolean flying = fakePlayer.get("flying").getAsBoolean();
        EntityPlayerMPFake.createFakePlayer(username, server, pos_x, pos_y, pos_z, yaw, pitch, (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(dimension)), GameType.m_46400_((String)gamemode), flying);
    }
}

