/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain.features.logging.helper;

import dev.dubhe.curtain.features.logging.AbstractLogger;
import dev.dubhe.curtain.features.logging.LoggerManager;
import dev.dubhe.curtain.utils.Messenger;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class ExplosionLogHelper {
    private final boolean createFire;
    private final Explosion.BlockInteraction blockDestructionType;
    private final RegistryAccess regs;
    public final Vec3 pos;
    private final float power;
    private boolean affectBlocks = false;
    private final Object2IntMap<EntityChangedStatusWithCount> impactedEntities = new Object2IntOpenHashMap();
    private static long lastGametime = 0L;
    private static int explosionCountInCurrentGT = 0;
    private static boolean newTick;
    private static Component log;

    public ExplosionLogHelper(double x, double y, double z, float power, boolean createFire, Explosion.BlockInteraction blockDestructionType, RegistryAccess regs) {
        this.power = power;
        this.pos = new Vec3(x, y, z);
        this.createFire = createFire;
        this.blockDestructionType = blockDestructionType;
        this.regs = regs;
    }

    public void setAffectBlocks(boolean b) {
        this.affectBlocks = b;
    }

    public void onExplosionDone(long gametime) {
        newTick = false;
        if (lastGametime != gametime) {
            explosionCountInCurrentGT = 0;
            lastGametime = gametime;
            newTick = true;
        }
        ++explosionCountInCurrentGT;
        ArrayList<Component> messages = new ArrayList<Component>();
        if (newTick) {
            messages.add(Messenger.c("wb tick : ", "d " + gametime));
        }
        messages.add(Messenger.c("d #" + explosionCountInCurrentGT, "gb ->", Messenger.dblt("l", this.pos.f_82479_, this.pos.f_82480_, this.pos.f_82481_)));
        messages.add(Messenger.c("w   affects blocks: ", "m " + this.affectBlocks));
        messages.add(Messenger.c("w   creates fire: ", "m " + this.createFire));
        messages.add(Messenger.c("w   power: ", "c " + this.power));
        messages.add(Messenger.c("w   destruction: ", "c " + this.blockDestructionType.name()));
        if (this.impactedEntities.isEmpty()) {
            messages.add(Messenger.c("w   affected entities: ", "m None"));
        } else {
            messages.add(Messenger.c("w   affected entities:"));
            this.impactedEntities.forEach((k, v) -> messages.add(Messenger.c(k.pos.equals((Object)this.pos) ? "r   - TNT" : "w   - ", Messenger.dblt(k.pos.equals((Object)this.pos) ? "r" : "y", k.pos.f_82479_, k.pos.f_82480_, k.pos.f_82481_), "w  dV", Messenger.dblt("d", k.accel.f_82479_, k.accel.f_82480_, k.accel.f_82481_), "w  " + this.regs.m_175515_(ForgeRegistries.ENTITY_TYPES.getRegistryKey()).m_7981_(k.type).m_135815_(), v > 1 ? "l (" + v + ")" : "")));
        }
        Iterator iterator = messages.iterator();
        MutableComponent rt = Component.m_237119_();
        Component component = (Component)iterator.next();
        while (iterator.hasNext()) {
            rt.m_7220_(component);
            if (iterator.hasNext()) {
                rt.m_7220_((Component)Component.m_237113_((String)"\n"));
            }
            component = (Component)iterator.next();
        }
        log = rt;
        LoggerManager.ableSendToChat("explosion");
    }

    public void onEntityImpacted(Entity entity, Vec3 accel) {
        EntityChangedStatusWithCount ent = new EntityChangedStatusWithCount(entity, accel);
        this.impactedEntities.put((Object)ent, this.impactedEntities.getOrDefault((Object)ent, 0) + 1);
    }

    public record EntityChangedStatusWithCount(Vec3 pos, EntityType<?> type, Vec3 accel) {
        public EntityChangedStatusWithCount(Entity e, Vec3 accel) {
            this(e.m_20182_(), e.m_6095_(), accel);
        }
    }

    public static class ExplosionLogger
    extends AbstractLogger {
        public ExplosionLogger() {
            super("explosion");
        }

        @Override
        public Component display(ServerPlayer player) {
            return log;
        }
    }
}

