/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain.events.rules;

import dev.dubhe.curtain.CurtainRules;
import dev.dubhe.curtain.events.events.ItemStackEvent;
import dev.dubhe.curtain.features.player.helpers.FakePlayerAutoReplaceTool;
import dev.dubhe.curtain.features.player.helpers.FakePlayerAutoReplenishment;
import dev.dubhe.curtain.features.player.menu.FakePlayerInventoryMenu;
import dev.dubhe.curtain.features.player.menu.MenuHashMap;
import dev.dubhe.curtain.features.player.patches.EntityPlayerMPFake;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PlayerEventHandler {
    @SubscribeEvent
    public void onTick(TickEvent.PlayerTickEvent playerTickEvent) {
        ServerPlayer serverPlayer;
        Player player;
        if (CurtainRules.openFakePlayerInventory && (player = playerTickEvent.player) instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player) instanceof EntityPlayerMPFake && serverPlayer.m_6084_()) {
            MenuHashMap.FAKE_PLAYER_INVENTORY_MENU_MAP.get(serverPlayer).tick();
        }
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        MenuHashMap.FAKE_PLAYER_INVENTORY_MENU_MAP.put(event.getEntity(), new FakePlayerInventoryMenu(event.getEntity()));
    }

    @SubscribeEvent
    public void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        MenuHashMap.FAKE_PLAYER_INVENTORY_MENU_MAP.remove(event.getEntity());
    }

    @SubscribeEvent
    public void onBreak(ItemStackEvent.BreakSpeed event) {
        BlockState state = event.getState();
        event.setSpeed(CurtainRules.missingTools && state.m_60734_().m_49962_(state) == SoundType.f_56744_ ? event.getSpeed() : event.getOriginalSpeed());
    }

    @SubscribeEvent
    public void onUse(ItemStackEvent.Use event) {
        Player player;
        if (CurtainRules.fakePlayerAutoReplenishment && (player = event.getPlayer()) instanceof EntityPlayerMPFake) {
            EntityPlayerMPFake fakePlayer = (EntityPlayerMPFake)player;
            FakePlayerAutoReplenishment.autoReplenishment((Player)fakePlayer);
        }
    }

    @SubscribeEvent
    public void onHurtAndBreak(ItemStackEvent.HurtAndBreak event) {
        Player player;
        if (CurtainRules.fakePlayerAutoReplaceTool && (player = event.getPlayer()) instanceof EntityPlayerMPFake) {
            EntityPlayerMPFake fakePlayer = (EntityPlayerMPFake)player;
            FakePlayerAutoReplaceTool.autoReplaceTool((Player)fakePlayer);
        }
    }
}

