/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain.api.rules;

import com.google.common.base.CaseFormat;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.dubhe.curtain.api.rules.IValidator;
import dev.dubhe.curtain.api.rules.RuleException;
import dev.dubhe.curtain.utils.TranslationHelper;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;

public class CurtainRule<T>
implements ArgumentType<T>,
CommandExceptionType {
    private final String[] categories;
    private final List<IValidator<T>> validators;
    private final String[] suggestions;
    private final Field field;
    private final T defaultValue;
    private final String nameTranslationKey;
    private final String descTranslationKey;

    private CurtainRule(String[] categories, List<IValidator<T>> validators, String[] suggestions, Field field) {
        this(categories, validators, suggestions, field, CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, field.getName()));
    }

    private CurtainRule(String[] categories, List<IValidator<T>> validators, String[] suggestions, Field field, String serializedName) {
        String[] stringArray;
        this.categories = categories;
        this.validators = validators;
        if (field.getType() == Boolean.TYPE || field.getType() == Boolean.class) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "true";
            stringArray = stringArray2;
            stringArray2[1] = "false";
        } else {
            stringArray = suggestions;
        }
        this.suggestions = stringArray;
        this.field = field;
        this.nameTranslationKey = "%s.rules.%s.name".formatted("curtain", serializedName);
        this.descTranslationKey = "%s.rules.%s.desc".formatted("curtain", serializedName);
        try {
            this.defaultValue = field.get(null);
        }
        catch (IllegalAccessException e) {
            throw new RuleException(e.getMessage());
        }
    }

    public void setValue(T value) throws IllegalAccessException {
        this.field.set(this.field, value);
    }

    public void setValue(Object value, Class<?> typeOfT) {
        try {
            this.field.set(this.field, value);
        }
        catch (IllegalAccessException e) {
            throw new RuleException(e.getMessage());
        }
    }

    public boolean validate(CommandSourceStack source, String newValue) {
        for (IValidator<T> validator : this.validators) {
            if (validator.validate(source, this, newValue)) continue;
            return false;
        }
        return true;
    }

    public static <T> CurtainRule<T> newRule(String[] categories, Class<? extends IValidator<?>> @NotNull [] validators, String[] suggestions, Field field, String serializedName) {
        ArrayList<IValidator<T>> validators1 = new ArrayList<IValidator<T>>();
        for (Class<IValidator<?>> clazz : validators) {
            try {
                validators1.add(clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return new CurtainRule<T>(categories, validators1, suggestions, field, serializedName);
    }

    public static <T> CurtainRule<T> newRule(String[] categories, Class<? extends IValidator<?>> @NotNull [] validators, String[] suggestions, Field field) {
        ArrayList<IValidator<T>> validators1 = new ArrayList<IValidator<T>>();
        for (Class<IValidator<?>> clazz : validators) {
            try {
                validators1.add(clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return new CurtainRule<T>(categories, validators1, suggestions, field);
    }

    public String toString() {
        try {
            return this.field.get(null).toString();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return "null";
        }
    }

    public T getValue() {
        try {
            return (T)this.field.get(null);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void reset() {
        try {
            this.setValue(this.defaultValue);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public T parse(StringReader reader) throws CommandSyntaxException {
        String str = reader.getString();
        if (this.field.getType() == String.class) {
            return (T)str;
        }
        if (this.field.getType() == Boolean.class) {
            return (T)Boolean.valueOf(Boolean.parseBoolean(str));
        }
        if (this.field.getType() == Byte.class) {
            return (T)Byte.valueOf(Byte.parseByte(str));
        }
        if (this.field.getType() == Short.class) {
            return (T)Short.valueOf(Short.parseShort(str));
        }
        if (this.field.getType() == Integer.class) {
            return (T)Integer.valueOf(Integer.parseInt(str));
        }
        if (this.field.getType() == Long.class) {
            return (T)Long.valueOf(Long.parseLong(str));
        }
        if (this.field.getType() == Float.class) {
            return (T)Float.valueOf(Float.parseFloat(str));
        }
        if (this.field.getType() == Double.class) {
            return (T)Double.valueOf(Double.parseDouble(str));
        }
        throw new CommandSyntaxException((CommandExceptionType)this, (Message)Component.m_237113_((String)"%s is not a legal value".formatted(str)));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82967_((String[])this.suggestions, (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        if (this.getType() == String.class) {
            ArrayList<String> rt = new ArrayList<String>();
            for (String s : this.suggestions) {
                rt.add("\"%s\"".formatted(s));
            }
            return rt;
        }
        return List.of(this.suggestions);
    }

    public String[] getCategories() {
        return this.categories;
    }

    public MutableComponent getNameComponent() {
        return TranslationHelper.translate(this.getNameTranslationKey(), new Object[0]);
    }

    public MutableComponent getDescComponent() {
        return TranslationHelper.translate(this.getDescTranslationKey(), new Object[0]);
    }

    public String getNameTranslationKey() {
        return this.nameTranslationKey;
    }

    public String getDescTranslationKey() {
        return this.descTranslationKey;
    }

    public Class<?> getType() {
        return this.field.getType();
    }

    public String getName() {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, this.field.getName());
    }

    public boolean isDefault(String s) {
        return String.valueOf(this.defaultValue).equals(s);
    }

    public String getNormalName() {
        return this.field.getName();
    }

    public String[] getSuggestions() {
        return this.suggestions;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }
}

