/*
 * Decompiled with CFR 0.152.
 */
package team.reborn.energy.api.base;

import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1799;
import net.minecraft.class_9326;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.impl.SimpleItemEnergyStorageImpl;

public interface SimpleEnergyItem {
    public static EnergyStorage createStorage(ContainerItemContext ctx, long capacity, long maxInsert, long maxExtract) {
        return SimpleItemEnergyStorageImpl.createSimpleStorage(ctx, capacity, maxInsert, maxExtract);
    }

    public long getEnergyCapacity(class_1799 var1);

    public long getEnergyMaxInput(class_1799 var1);

    public long getEnergyMaxOutput(class_1799 var1);

    default public long getStoredEnergy(class_1799 stack) {
        return SimpleEnergyItem.getStoredEnergyUnchecked(stack);
    }

    default public void setStoredEnergy(class_1799 stack, long newAmount) {
        SimpleEnergyItem.setStoredEnergyUnchecked(stack, newAmount);
    }

    default public boolean tryUseEnergy(class_1799 stack, long amount) {
        if (stack.method_7947() != 1) {
            throw new IllegalArgumentException("Invalid count: " + stack.method_7947());
        }
        long newAmount = this.getStoredEnergy(stack) - amount;
        if (newAmount < 0L) {
            return false;
        }
        this.setStoredEnergy(stack, newAmount);
        return true;
    }

    public static long getStoredEnergyUnchecked(class_1799 stack) {
        return (Long)stack.method_57825(EnergyStorage.ENERGY_COMPONENT, (Object)0L);
    }

    public static long getStoredEnergyUnchecked(ItemVariant variant) {
        return SimpleEnergyItem.getStoredEnergyUnchecked(variant.getComponents());
    }

    public static long getStoredEnergyUnchecked(class_9326 components) {
        @Nullable Optional energy = components.method_57845(EnergyStorage.ENERGY_COMPONENT);
        if (energy != null) {
            return energy.orElse(0L);
        }
        return 0L;
    }

    public static void setStoredEnergyUnchecked(class_1799 stack, long newAmount) {
        if (newAmount <= 0L) {
            stack.method_57381(EnergyStorage.ENERGY_COMPONENT);
        } else {
            stack.method_57379(EnergyStorage.ENERGY_COMPONENT, (Object)newAmount);
        }
    }
}

