/*
 * Decompiled with CFR 0.152.
 */
package fr.tathan.sky_aesthetics.mixin.client;

import com.mojang.blaze3d.vertex.PoseStack;
import fr.tathan.sky_aesthetics.client.data.SkyPropertiesData;
import fr.tathan.sky_aesthetics.client.skies.PlanetSky;
import fr.tathan.sky_aesthetics.client.skies.renderer.SkyRenderer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.world.level.material.FogType;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class}, priority=900)
public abstract class LevelRendererMixin {
    @Mutable
    @Shadow
    private ClientLevel level;

    @Shadow
    protected abstract boolean doesMobEffectBlockSky(Camera var1);

    @Inject(method={"renderSky(Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;FLnet/minecraft/client/Camera;ZLjava/lang/Runnable;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderCustomSkyboxes(Matrix4f matrix4f, Matrix4f projectionMatrix, float partialTick, Camera camera, boolean thickFog, Runnable fogCallback, CallbackInfo ci) {
        FogType cameraSubmersionType = camera.getFluidInCamera();
        if (!thickFog && cameraSubmersionType != FogType.POWDER_SNOW && cameraSubmersionType != FogType.LAVA && cameraSubmersionType != FogType.WATER && !this.doesMobEffectBlockSky(camera)) {
            for (PlanetSky sky : SkyPropertiesData.SKY_PROPERTIES.values()) {
                if (!sky.getProperties().world().equals((Object)this.level.dimension())) continue;
                PoseStack poseStack = new PoseStack();
                poseStack.mulPose(matrix4f);
                SkyRenderer renderer = sky.getRenderer();
                if (!renderer.isSkyRendered()) continue;
                renderer.render(this.level, poseStack, projectionMatrix, partialTick, camera, fogCallback);
                ci.cancel();
            }
        }
    }

    @Inject(method={"renderClouds(Lcom/mojang/blaze3d/vertex/PoseStack;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;FDDD)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void cancelCloudRenderer(PoseStack poseStack, Matrix4f frustumMatrix, Matrix4f projectionMatrix, float partialTick, double camX, double camY, double camZ, CallbackInfo ci) {
        for (PlanetSky sky : SkyPropertiesData.SKY_PROPERTIES.values()) {
            SkyRenderer renderer;
            if (!sky.getProperties().world().equals((Object)this.level.dimension()) || !(renderer = sky.getRenderer()).shouldRemoveCloud().booleanValue()) continue;
            ci.cancel();
        }
    }

    @Inject(method={"renderSnowAndRain(Lnet/minecraft/client/renderer/LightTexture;FDDD)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void cancelSnowAndRainRenderer(LightTexture lightTexture, float partialTick, double camX, double camY, double camZ, CallbackInfo ci) {
        for (PlanetSky sky : SkyPropertiesData.SKY_PROPERTIES.values()) {
            SkyRenderer renderer;
            if (!sky.getProperties().world().equals((Object)this.level.dimension()) || !(renderer = sky.getRenderer()).shouldRemoveSnowAndRain().booleanValue()) continue;
            ci.cancel();
        }
    }

    @Inject(method={"tickRain(Lnet/minecraft/client/Camera;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void canRain(Camera camera, CallbackInfo ci) {
        for (PlanetSky sky : SkyPropertiesData.SKY_PROPERTIES.values()) {
            SkyRenderer renderer;
            if (!sky.getProperties().world().equals((Object)this.level.dimension()) || !(renderer = sky.getRenderer()).shouldRemoveSnowAndRain().booleanValue()) continue;
            ci.cancel();
        }
    }
}

