/*
 * Decompiled with CFR 0.152.
 */
package fr.tathan.sky_aesthetics.client.skies.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import fr.tathan.SkyAesthetics;
import fr.tathan.sky_aesthetics.client.data.ConstellationsData;
import fr.tathan.sky_aesthetics.client.skies.record.Constellation;
import fr.tathan.sky_aesthetics.client.skies.record.Star;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.BooleanUtils;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class StarHelper {
    public static VertexBuffer createStars(float scale, int amountFancy, int r, int g, int b, Optional<List<String>> constellations) {
        Tesselator tesselator = Tesselator.getInstance();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        VertexBuffer vertexBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        Random random = new Random();
        BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        GraphicsStatus graphicsMode = (GraphicsStatus)Minecraft.getInstance().options.graphicsMode().get();
        int stars = amountFancy / (BooleanUtils.toInteger((graphicsMode == GraphicsStatus.FANCY || graphicsMode == GraphicsStatus.FABULOUS ? 1 : 0) != 0) + 1);
        for (int i = 0; i < stars; ++i) {
            float d0 = random.nextFloat() * 2.0f - 1.0f;
            float d1 = random.nextFloat() * 2.0f - 1.0f;
            float d2 = random.nextFloat() * 2.0f - 1.0f;
            float d3 = scale + random.nextFloat() * 0.1f;
            float d4 = d0 * d0 + d1 * d1 + d2 * d2;
            if (!(d4 < 1.0f) || !(d4 > 0.01f)) continue;
            d4 = (float)(1.0 / Math.sqrt(d4));
            float d5 = (d0 *= d4) * 100.0f;
            float d6 = (d1 *= d4) * 100.0f;
            float d7 = (d2 *= d4) * 100.0f;
            float d8 = (float)Math.atan2(d0, d2);
            float d9 = (float)Math.sin(d8);
            float d10 = (float)Math.cos(d8);
            float d11 = (float)Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1);
            float d12 = (float)Math.sin(d11);
            float d13 = (float)Math.cos(d11);
            float d14 = (float)(random.nextDouble() * Math.PI * 2.0);
            float d15 = (float)Math.sin(d14);
            float d16 = (float)Math.cos(d14);
            for (int j = 0; j < 4; ++j) {
                float d18 = (float)((j & 2) - 1) * d3;
                float d19 = (float)((j + 1 & 2) - 1) * d3;
                float d21 = d18 * d16 - d19 * d15;
                float d22 = d19 * d16 + d18 * d15;
                float d23 = d21 * d12 + 0.0f * d13;
                float d24 = 0.0f * d12 - d21 * d13;
                float d25 = d24 * d9 - d22 * d10;
                float d26 = d22 * d9 + d24 * d10;
                int color1 = r == -1 ? i : r;
                int color2 = g == -1 ? i : g;
                int color3 = b == -1 ? i : b;
                bufferBuilder.addVertex(d5 + d25, d6 + d23, d7 + d26).setColor(color1, color2, color3, 170);
            }
        }
        if (constellations.isPresent()) {
            SkyAesthetics.LOG.error("Is present");
            for (String constellationId : constellations.get()) {
                Constellation constellation = ConstellationsData.CONSTELLATIONS.get(constellationId);
                if (constellation != null) {
                    Star.Color color = constellation.color();
                    float x = (float)constellation.firstPoint().x;
                    float y = (float)constellation.firstPoint().y;
                    float z = (float)constellation.firstPoint().z;
                    StarHelper.createStar(constellation.firstPoint(), color, (int)constellation.scale(), random, bufferBuilder);
                    for (Vec3 point : constellation.points()) {
                        Vec3 pointPos = new Vec3((double)x + point.x, (double)y + point.y, (double)z + point.z);
                        StarHelper.createStar(pointPos, color, constellation.scale(), random, bufferBuilder);
                    }
                    continue;
                }
                SkyAesthetics.LOG.error("{} is null", (Object)constellationId);
            }
        }
        vertexBuffer.bind();
        vertexBuffer.upload(bufferBuilder.buildOrThrow());
        VertexBuffer.unbind();
        return vertexBuffer;
    }

    public static void createStar(Vec3 pos, Star.Color color, float scale, Random random, BufferBuilder bufferBuilder) {
        float d0 = (float)pos.x;
        float d1 = (float)pos.y;
        float d2 = (float)pos.z;
        float d3 = Mth.clamp((float)(scale + random.nextFloat()), (float)scale, (float)(scale + 0.2f));
        float d4 = d0 * d0 + d1 * d1 + d2 * d2;
        d4 = (float)(1.0 / Math.sqrt(d4));
        float d5 = (d0 *= d4) * 100.0f;
        float d6 = (d1 *= d4) * 100.0f;
        float d7 = (d2 *= d4) * 100.0f;
        float d8 = (float)Math.atan2(d0, d2);
        float d9 = (float)Math.sin(d8);
        float d10 = (float)Math.cos(d8);
        float d11 = (float)Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1);
        float d12 = (float)Math.sin(d11);
        float d13 = (float)Math.cos(d11);
        float d14 = (float)(random.nextDouble() * Math.PI * 2.0);
        float d15 = (float)Math.sin(d14);
        float d16 = (float)Math.cos(d14);
        for (int j = 0; j < 4; ++j) {
            float d18 = (float)((j & 2) - 1) * d3;
            float d19 = (float)((j + 1 & 2) - 1) * d3;
            float d21 = d18 * d16 - d19 * d15;
            float d22 = d19 * d16 + d18 * d15;
            float d23 = d21 * d12 + 0.0f * d13;
            float d24 = 0.0f * d12 - d21 * d13;
            float d25 = d24 * d9 - d22 * d10;
            float d26 = d22 * d9 + d24 * d10;
            bufferBuilder.addVertex(d5 + d25, d6 + d23, d7 + d26).setColor(color.r(), color.g(), color.b(), 170);
        }
    }

    public static void drawStars(VertexBuffer vertexBuffer, PoseStack poseStack, Matrix4f projectionMatrix, float nightTime) {
        poseStack.pushPose();
        poseStack.mulPose(Axis.ZP.rotationDegrees(nightTime));
        FogRenderer.setupNoFog();
        vertexBuffer.bind();
        vertexBuffer.drawWithShader(poseStack.last().pose(), projectionMatrix, GameRenderer.getPositionColorShader());
        VertexBuffer.unbind();
        poseStack.popPose();
    }

    public static VertexBuffer createVanillaStars() {
        VertexBuffer starBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        starBuffer.bind();
        starBuffer.upload(StarHelper.createVanillaStars(Tesselator.getInstance()));
        VertexBuffer.unbind();
        return starBuffer;
    }

    public static MeshData createVanillaStars(Tesselator tesselator) {
        RandomSource randomSource = RandomSource.create((long)10842L);
        float f = 100.0f;
        BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
        for (int j = 0; j < 1500; ++j) {
            float g = randomSource.nextFloat() * 2.0f - 1.0f;
            float h = randomSource.nextFloat() * 2.0f - 1.0f;
            float k = randomSource.nextFloat() * 2.0f - 1.0f;
            float l = 0.15f + randomSource.nextFloat() * 0.1f;
            float m = Mth.lengthSquared((float)g, (float)h, (float)k);
            if (m <= 0.010000001f || m >= 1.0f) continue;
            Vector3f vector3f = new Vector3f(g, h, k).normalize(100.0f);
            float n = (float)(randomSource.nextDouble() * 3.1415927410125732 * 2.0);
            Quaternionf quaternionf = new Quaternionf().rotateTo((Vector3fc)new Vector3f(0.0f, 0.0f, -1.0f), (Vector3fc)vector3f).rotateZ(n);
            bufferBuilder.addVertex(vector3f.add((Vector3fc)new Vector3f(l, -l, 0.0f).rotate((Quaternionfc)quaternionf))).setColor(255);
            bufferBuilder.addVertex(vector3f.add((Vector3fc)new Vector3f(l, l, 0.0f).rotate((Quaternionfc)quaternionf))).setColor(255);
            bufferBuilder.addVertex(vector3f.add((Vector3fc)new Vector3f(-l, l, 0.0f).rotate((Quaternionfc)quaternionf))).setColor(255);
            bufferBuilder.addVertex(vector3f.add((Vector3fc)new Vector3f(-l, -l, 0.0f).rotate((Quaternionfc)quaternionf))).setColor(255);
        }
        return bufferBuilder.buildOrThrow();
    }
}

