/*
 * Decompiled with CFR 0.152.
 */
package fr.tathan.sky_aesthetics.client.skies.utils;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import fr.tathan.sky_aesthetics.client.skies.record.CustomVanillaObject;
import fr.tathan.sky_aesthetics.client.skies.record.SkyObject;
import fr.tathan.sky_aesthetics.mixin.client.LevelRendererAccessor;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public class SkyHelper {
    public static void drawSky(Matrix4f matrix4f, Matrix4f projectionMatrix, ShaderInstance shaderInstance, Tesselator tesselator, PoseStack poseStack, float partialTick) {
        ((LevelRendererAccessor)Minecraft.getInstance().levelRenderer).stellaris$getSkyBuffer().bind();
        ((LevelRendererAccessor)Minecraft.getInstance().levelRenderer).stellaris$getSkyBuffer().drawWithShader(matrix4f, projectionMatrix, shaderInstance);
        VertexBuffer.unbind();
    }

    public static void drawMoonWithPhase(ClientLevel level, Tesselator tesselator, PoseStack poseStack, float y, CustomVanillaObject moon, float dayAngle) {
        int moonPhase = level.getMoonPhase();
        int xCoord = moonPhase % 4;
        int yCoord = moonPhase / 4 % 2;
        float startX = (float)xCoord / 4.0f;
        float startY = (float)yCoord / 2.0f;
        float endX = (float)(xCoord + 1) / 4.0f;
        float endY = (float)(yCoord + 1) / 2.0f;
        SkyHelper.drawCelestialBody(moon.moonTexture(), tesselator, poseStack, y, 20.0f, dayAngle, startX, endX, startY, endY, true);
    }

    public static void drawCelestialBody(SkyObject skyObject, Tesselator tesselator, PoseStack poseStack, float y, float dayAngle, boolean blend) {
        SkyHelper.drawCelestialBody(skyObject.texture(), tesselator, poseStack, y, skyObject.size(), dayAngle, blend);
    }

    public static void drawCelestialBody(ResourceLocation texture, Tesselator tesselator, PoseStack poseStack, float y, float size, float dayAngle, boolean blend) {
        SkyHelper.drawCelestialBody(texture, tesselator, poseStack, y, size, dayAngle, 0.0f, 1.0f, 1.0f, 0.0f, blend);
    }

    public static void drawCelestialBody(ResourceLocation texture, Tesselator tesselator, PoseStack poseStack, float y, float size, float dayAngle, float startX, float endX, float startY, float endY, boolean blend) {
        if (blend) {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        }
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
        poseStack.mulPose(Axis.XP.rotationDegrees(dayAngle));
        Matrix4f matrix4f = poseStack.last().pose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferBuilder.addVertex(matrix4f, -size, y, -size).setUv(startX, endY);
        bufferBuilder.addVertex(matrix4f, size, y, -size).setUv(endX, endY);
        bufferBuilder.addVertex(matrix4f, size, y, size).setUv(endX, startY);
        bufferBuilder.addVertex(matrix4f, -size, y, size).setUv(startX, startY);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        poseStack.popPose();
        if (blend) {
            RenderSystem.disableBlend();
        }
    }

    public static void drawCelestialBody(SkyObject object, Tesselator tesselator, PoseStack poseStack, float dayAngle) {
        if (object.blend()) {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        }
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees((float)object.rotation().y));
        if (Objects.equals(object.rotationType(), "DAY")) {
            poseStack.mulPose(Axis.XP.rotationDegrees(dayAngle));
        } else if (Objects.equals(object.rotationType(), "NIGHT")) {
            poseStack.mulPose(Axis.XP.rotationDegrees(dayAngle + 180.0f));
        } else {
            poseStack.mulPose(Axis.XP.rotationDegrees((float)object.rotation().x));
        }
        poseStack.mulPose(Axis.ZP.rotationDegrees((float)object.rotation().z));
        Matrix4f matrix4f = poseStack.last().pose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)object.texture());
        BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferBuilder.addVertex(matrix4f, -object.size(), (float)object.height(), -object.size()).setUv(0.0f, 0.0f);
        bufferBuilder.addVertex(matrix4f, object.size(), (float)object.height(), -object.size()).setUv(1.0f, 0.0f);
        bufferBuilder.addVertex(matrix4f, object.size(), (float)object.height(), object.size()).setUv(1.0f, 1.0f);
        bufferBuilder.addVertex(matrix4f, -object.size(), (float)object.height(), object.size()).setUv(0.0f, 1.0f);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        poseStack.popPose();
        if (object.blend()) {
            RenderSystem.disableBlend();
        }
    }

    public static void renderEndSky(PoseStack poseStack) {
        RenderSystem.enableBlend();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)((LevelRendererAccessor)Minecraft.getInstance().levelRenderer).stellaris$getEndSkyLocation());
        Tesselator tesselator = Tesselator.getInstance();
        for (int i = 0; i < 6; ++i) {
            poseStack.pushPose();
            if (i == 1) {
                poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            }
            if (i == 2) {
                poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
            }
            if (i == 3) {
                poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
            }
            if (i == 4) {
                poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
            }
            if (i == 5) {
                poseStack.mulPose(Axis.ZP.rotationDegrees(-90.0f));
            }
            Matrix4f matrix4f = poseStack.last().pose();
            BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
            bufferBuilder.addVertex(matrix4f, -100.0f, -100.0f, -100.0f).setUv(0.0f, 0.0f).setColor(-14145496);
            bufferBuilder.addVertex(matrix4f, -100.0f, -100.0f, 100.0f).setUv(0.0f, 16.0f).setColor(-14145496);
            bufferBuilder.addVertex(matrix4f, 100.0f, -100.0f, 100.0f).setUv(16.0f, 16.0f).setColor(-14145496);
            bufferBuilder.addVertex(matrix4f, 100.0f, -100.0f, -100.0f).setUv(16.0f, 0.0f).setColor(-14145496);
            BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
            poseStack.popPose();
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
    }

    public static boolean skyTypeToHasGround(String skyType) {
        String string = skyType;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"END"}, (Object)string, n)) {
            case 0 -> false;
            default -> true;
        };
    }
}

