/*
 * Decompiled with CFR 0.152.
 */
package fr.tathan.sky_aesthetics.client.skies.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import fr.tathan.sky_aesthetics.client.skies.record.CustomVanillaObject;
import fr.tathan.sky_aesthetics.client.skies.record.SkyObject;
import fr.tathan.sky_aesthetics.client.skies.record.SkyProperties;
import fr.tathan.sky_aesthetics.client.skies.record.Star;
import fr.tathan.sky_aesthetics.client.skies.utils.ShootingStar;
import fr.tathan.sky_aesthetics.client.skies.utils.SkyHelper;
import fr.tathan.sky_aesthetics.client.skies.utils.StarHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class SkyRenderer {
    private final SkyProperties properties;
    private final VertexBuffer starBuffer;
    private final Map<UUID, ShootingStar> shootingStars;

    public SkyRenderer(SkyProperties properties) {
        this.properties = properties;
        this.starBuffer = !properties.stars().vanilla() ? StarHelper.createStars(properties.stars().scale(), properties.stars().count(), properties.stars().color().r(), properties.stars().color().g(), properties.stars().color().b(), properties.constellations()) : StarHelper.createVanillaStars();
        this.shootingStars = new HashMap<UUID, ShootingStar>();
    }

    public void render(ClientLevel level, PoseStack poseStack, Matrix4f projectionMatrix, float partialTick, Camera camera, Runnable fogCallback) {
        if (!this.isSkyRendered()) {
            return;
        }
        if (this.properties.fog().booleanValue()) {
            fogCallback.run();
        }
        Tesselator tesselator = Tesselator.getInstance();
        CustomVanillaObject customVanillaObject = this.properties.customVanillaObject();
        float dayAngle = level.getTimeOfDay(partialTick) * 360.0f % 360.0f;
        float nightAngle = dayAngle + 180.0f;
        Vec3 vec3 = level.getSkyColor(camera.getPosition(), partialTick);
        if (this.properties.skyColor().customColor()) {
            vec3 = this.properties.skyColor().color();
        }
        float r = (float)vec3.x;
        float g = (float)vec3.y;
        float b = (float)vec3.z;
        FogRenderer.levelFogColor();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
        ShaderInstance shaderInstance = RenderSystem.getShader();
        if (Objects.equals(this.properties.skyType(), "NORMAL")) {
            SkyHelper.drawSky(poseStack.last().pose(), projectionMatrix, shaderInstance, tesselator, poseStack, partialTick);
        } else if (Objects.equals(this.properties.skyType(), "END")) {
            SkyHelper.renderEndSky(poseStack);
        }
        this.renderStars(level, partialTick, poseStack, projectionMatrix, fogCallback, nightAngle);
        this.properties.stars().shootingStars().ifPresent(shootingStar -> this.handleShootingStars(level, poseStack, projectionMatrix, this.properties.stars(), partialTick));
        if (customVanillaObject.sun()) {
            SkyHelper.drawCelestialBody(customVanillaObject.sunTexture(), tesselator, poseStack, customVanillaObject.sunHeight(), customVanillaObject.sunSize(), dayAngle, true);
        }
        if (customVanillaObject.moon()) {
            if (customVanillaObject.moonPhase()) {
                SkyHelper.drawMoonWithPhase(level, tesselator, poseStack, customVanillaObject.moonSize(), customVanillaObject, nightAngle);
            } else {
                SkyHelper.drawCelestialBody(customVanillaObject.moonTexture(), tesselator, poseStack, customVanillaObject.moonHeight(), customVanillaObject.moonSize(), nightAngle, 0.0f, 1.0f, 0.0f, 1.0f, false);
            }
        }
        for (SkyObject skyObject : this.properties.skyObjects()) {
            SkyHelper.drawCelestialBody(skyObject, tesselator, poseStack, dayAngle);
        }
        if (this.properties.fog().booleanValue()) {
            fogCallback.run();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.depthMask((boolean)true);
    }

    private void handleShootingStars(ClientLevel level, PoseStack poseStack, Matrix4f projectionMatrix, Star star, float partialTick) {
        if (!level.isClientSide) {
            return;
        }
        float starLight = level.getStarBrightness(partialTick) * (1.0f - level.getRainLevel(partialTick));
        if (!star.allDaysVisible() && !(starLight > 0.2f)) {
            if (!this.shootingStars.isEmpty()) {
                this.shootingStars.clear();
            }
            return;
        }
        Star.ShootingStars shootingStarConfig = star.shootingStars().get();
        Random random = new Random();
        if (random.nextInt(1001) >= shootingStarConfig.percentage()) {
            UUID starId = UUID.randomUUID();
            ShootingStar shootingStar = new ShootingStar(random.nextInt((int)shootingStarConfig.randomLifetime().x, (int)shootingStarConfig.randomLifetime().y), shootingStarConfig, starId);
            this.shootingStars.putIfAbsent(starId, shootingStar);
        }
        if (this.shootingStars == null || this.shootingStars.isEmpty()) {
            return;
        }
        ArrayList<UUID> starsToRemove = new ArrayList<UUID>();
        for (ShootingStar shootingStar : this.shootingStars.values()) {
            if (!shootingStar.render(poseStack, projectionMatrix)) continue;
            starsToRemove.add(shootingStar.starId);
        }
        starsToRemove.forEach(this.shootingStars::remove);
    }

    private void renderStars(ClientLevel level, float partialTick, PoseStack poseStack, Matrix4f projectionMatrix, Runnable fogCallback, float nightAngle) {
        float starsAngle;
        float starLight = level.getStarBrightness(partialTick) * (1.0f - level.getRainLevel(partialTick));
        if (this.properties.stars().vanilla()) {
            if (starLight > 0.0f) {
                RenderSystem.setShaderColor((float)starLight, (float)starLight, (float)starLight, (float)starLight);
                FogRenderer.setupNoFog();
                this.starBuffer.bind();
                this.starBuffer.drawWithShader(poseStack.last().pose(), projectionMatrix, GameRenderer.getPositionShader());
                VertexBuffer.unbind();
            }
            return;
        }
        float f = starsAngle = !this.properties.stars().movingStars() ? -90.0f : nightAngle;
        if (this.properties.stars().allDaysVisible()) {
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            RenderSystem.setShaderColor((float)(starLight + 1.0f), (float)(starLight + 1.0f), (float)(starLight + 1.0f), (float)(starLight + 1.0f));
            StarHelper.drawStars(this.starBuffer, poseStack, projectionMatrix, starsAngle);
        } else if (starLight > 0.2f) {
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            RenderSystem.setShaderColor((float)(starLight + 0.5f), (float)(starLight + 0.5f), (float)(starLight + 0.5f), (float)(starLight + 0.5f));
            StarHelper.drawStars(this.starBuffer, poseStack, projectionMatrix, starsAngle);
        }
        if (this.properties.fog().booleanValue()) {
            fogCallback.run();
        }
    }

    public Boolean shouldRemoveCloud() {
        return this.properties.cloud() == false;
    }

    public Boolean shouldRemoveSnowAndRain() {
        return this.properties.rain() == false;
    }

    public boolean isSkyRendered() {
        if (!this.properties.renderCondition().isPresent() || !this.properties.renderCondition().get().condition()) {
            return true;
        }
        SkyProperties.RenderCondition condition = this.properties.renderCondition().get();
        ServerLevel level = this.getServerLevel();
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || level == null) {
            return false;
        }
        if (condition.biomes().isPresent()) {
            return level.getBiome(player.getOnPos()).is(condition.biomes().get());
        }
        if (condition.biome().isPresent()) {
            return level.getBiome(player.getOnPos()).is(condition.biome().get());
        }
        return true;
    }

    private ServerLevel getServerLevel() {
        Minecraft minecraft = Minecraft.getInstance();
        IntegratedServer integratedServer = minecraft.getSingleplayerServer();
        return integratedServer != null ? integratedServer.getLevel(minecraft.level.dimension()) : null;
    }
}

