/*
 * Decompiled with CFR 0.152.
 */
package fr.tathan.sky_aesthetics.client.skies;

import fr.tathan.sky_aesthetics.client.skies.record.SkyProperties;
import fr.tathan.sky_aesthetics.client.skies.renderer.SkyRenderer;
import java.lang.runtime.SwitchBootstraps;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class PlanetSky
extends DimensionSpecialEffects {
    private final SkyRenderer renderer;
    private final SkyProperties properties;

    public PlanetSky(SkyProperties properties) {
        super(properties.cloudHeight().floatValue(), true, DimensionSpecialEffects.SkyType.valueOf((String)properties.skyType()), false, false);
        this.properties = properties;
        this.renderer = new SkyRenderer(properties);
    }

    @NotNull
    public Vec3 getBrightnessDependentFogColor(Vec3 fogColor, float brightness) {
        return this.getProperties().fog() != false ? fogColor.multiply((double)(brightness * 0.94f + 0.06f), (double)(brightness * 0.94f + 0.06f), (double)(brightness * 0.91f + 0.09f)) : fogColor;
    }

    public DimensionSpecialEffects.SkyType skyType() {
        String string = this.properties.skyType();
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"END", "NONE"}, (Object)string, n)) {
            case 0 -> DimensionSpecialEffects.SkyType.END;
            case 1 -> DimensionSpecialEffects.SkyType.NONE;
            default -> DimensionSpecialEffects.SkyType.NORMAL;
        };
    }

    public boolean isFoggyAt(int x, int y) {
        return false;
    }

    public SkyRenderer getRenderer() {
        return this.renderer;
    }

    public SkyProperties getProperties() {
        return this.properties;
    }
}

