/*
 * Decompiled with CFR 0.152.
 */
package fr.tathan.sky_aesthetics.client.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import fr.tathan.SkyAesthetics;
import fr.tathan.sky_aesthetics.client.skies.PlanetSky;
import fr.tathan.sky_aesthetics.client.skies.record.SkyProperties;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;

public class SkyPropertiesData
extends SimpleJsonResourceReloadListener {
    public static final Map<ResourceLocation, PlanetSky> SKY_PROPERTIES = new HashMap<ResourceLocation, PlanetSky>();

    public SkyPropertiesData() {
        super(SkyAesthetics.GSON, "sky");
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profiler) {
        object.forEach((key, value) -> {
            JsonObject json = GsonHelper.convertToJsonObject((JsonElement)value, (String)"sky_renderer");
            SkyProperties skyProperties = (SkyProperties)SkyProperties.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow();
            PlanetSky planetSky = new PlanetSky(skyProperties);
            if (skyProperties.id().isPresent()) {
                SKY_PROPERTIES.putIfAbsent(skyProperties.id().get(), planetSky);
                SkyAesthetics.LOG.info(String.valueOf(skyProperties.id().get()) + " | registered");
            } else {
                SKY_PROPERTIES.putIfAbsent(skyProperties.world().location(), planetSky);
                SkyAesthetics.LOG.info(String.valueOf(skyProperties.world().location()) + " | registered");
            }
        });
    }
}

