/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import dev.dubhe.curtain.CurtainRules;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.io.IOUtils;

public class TranslationHelper {
    private static final Gson GSON = new GsonBuilder().setLenient().create();
    private static final Map<String, Map<String, String>> TRANS_MAP = new HashMap<String, Map<String, String>>();

    @Nonnull
    public static IFormattableTextComponent translate(String key, TextFormatting formatting, Style style, Object ... args) {
        Map trans = TRANS_MAP.getOrDefault(CurtainRules.language, new HashMap());
        return new StringTextComponent(trans.getOrDefault(key, key).formatted(args)).func_240703_c_(style).func_240699_a_(formatting);
    }

    @Nonnull
    public static IFormattableTextComponent translate(String key, Object ... args) {
        Map trans = TRANS_MAP.getOrDefault(CurtainRules.language, new HashMap());
        return new StringTextComponent(trans.getOrDefault(key, key).formatted(args));
    }

    public static Collection<String> getLanguages() {
        return TRANS_MAP.keySet();
    }

    public static void addTransMap(String lang, Map<String, String> transMap) {
        if (!TRANS_MAP.containsKey(lang)) {
            TRANS_MAP.put(lang, transMap);
        } else {
            TRANS_MAP.get(lang).putAll(transMap);
        }
    }

    public static Map<String, String> getTranslationFromResourcePath(InputStream stream) {
        String dataJSON;
        try {
            dataJSON = IOUtils.toString((InputStream)Objects.requireNonNull(stream), (Charset)StandardCharsets.UTF_8);
            stream.close();
        }
        catch (IOException | NullPointerException e) {
            return Map.of();
        }
        return (Map)GSON.fromJson(dataJSON, new TypeToken<Map<String, String>>(){}.getType());
    }

    static {
        TRANS_MAP.put("zh_cn", new HashMap());
    }
}

