/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain.utils;

import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class Tracer {
    public static RayTraceResult rayTrace(Entity source, float partialTicks, double reach, boolean fluids) {
        EntityRayTraceResult entityHit;
        BlockRayTraceResult blockHit = Tracer.rayTraceBlocks(source, partialTicks, reach, fluids);
        double maxSqDist = reach * reach;
        if (blockHit != null) {
            maxSqDist = blockHit.func_216347_e().func_72436_e(source.func_174824_e(partialTicks));
        }
        return (entityHit = Tracer.rayTraceEntities(source, partialTicks, reach, maxSqDist)) == null ? blockHit : entityHit;
    }

    public static BlockRayTraceResult rayTraceBlocks(Entity source, float partialTicks, double reach, boolean fluids) {
        Vector3d pos = source.func_174824_e(partialTicks);
        Vector3d rotation = source.func_70676_i(partialTicks);
        Vector3d reachEnd = pos.func_72441_c(rotation.field_72450_a * reach, rotation.field_72448_b * reach, rotation.field_72449_c * reach);
        return source.field_70170_p.func_217299_a(new RayTraceContext(pos, reachEnd, RayTraceContext.BlockMode.OUTLINE, fluids ? RayTraceContext.FluidMode.ANY : RayTraceContext.FluidMode.NONE, source));
    }

    public static EntityRayTraceResult rayTraceEntities(Entity source, float partialTicks, double reach, double maxSqDist) {
        Vector3d pos = source.func_174824_e(partialTicks);
        Vector3d reachVec = source.func_70676_i(partialTicks).func_186678_a(reach);
        AxisAlignedBB box = source.func_174813_aQ().func_216361_a(reachVec).func_186662_g(1.0);
        return Tracer.rayTraceEntities(source, pos, pos.func_178787_e(reachVec), box, e -> !e.func_175149_v() && e.func_241845_aY(), maxSqDist);
    }

    public static EntityRayTraceResult rayTraceEntities(Entity source, Vector3d start, Vector3d end, AxisAlignedBB box, Predicate<Entity> predicate, double maxSqDistance) {
        World world = source.field_70170_p;
        double targetDistance = maxSqDistance;
        Entity target = null;
        Vector3d targetHitPos = null;
        for (Entity current : world.func_175674_a(source, box, predicate)) {
            Vector3d currentHitPos;
            double currentDistance;
            AxisAlignedBB currentBox = current.func_174813_aQ().func_186662_g((double)current.func_70111_Y());
            Optional currentHit = currentBox.func_216365_b(start, end);
            if (currentBox.func_72318_a(start)) {
                if (!(targetDistance >= 0.0)) continue;
                target = current;
                targetHitPos = currentHit.orElse(start);
                targetDistance = 0.0;
                continue;
            }
            if (!currentHit.isPresent() || !((currentDistance = start.func_72436_e(currentHitPos = (Vector3d)currentHit.get())) < targetDistance) && targetDistance != 0.0) continue;
            if (current.func_184208_bv() == source.func_184208_bv()) {
                if (targetDistance != 0.0) continue;
                target = current;
                targetHitPos = currentHitPos;
                continue;
            }
            target = current;
            targetHitPos = currentHitPos;
            targetDistance = currentDistance;
        }
        if (target == null) {
            return null;
        }
        return new EntityRayTraceResult(target, targetHitPos);
    }
}

