/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain.utils;

import dev.dubhe.curtain.Curtain;
import dev.dubhe.curtain.mixins.WeightedRandomItemMixin;
import dev.dubhe.curtain.utils.EvictingQueue;
import dev.dubhe.curtain.utils.Messenger;
import dev.dubhe.curtain.utils.WoolTool;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.passive.OcelotEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.WorldEntitySpawner;
import org.apache.commons.lang3.tuple.Pair;

public class SpawnReporter {
    public static boolean mock_spawns = false;
    public static Long track_spawns = 0L;
    public static final HashMap<RegistryKey<World>, Integer> chunkCounts = new HashMap();
    public static final HashMap<Pair<RegistryKey<World>, EntityClassification>, Object2LongMap<EntityType<?>>> spawn_stats = new HashMap();
    public static double mobcap_exponent = 0.0;
    public static final HashMap<Pair<RegistryKey<World>, EntityClassification>, Long> spawn_attempts = new HashMap();
    public static final HashMap<Pair<RegistryKey<World>, EntityClassification>, Long> overall_spawn_ticks = new HashMap();
    public static final HashMap<Pair<RegistryKey<World>, EntityClassification>, Long> spawn_ticks_full = new HashMap();
    public static final HashMap<Pair<RegistryKey<World>, EntityClassification>, Long> spawn_ticks_fail = new HashMap();
    public static final HashMap<Pair<RegistryKey<World>, EntityClassification>, Long> spawn_ticks_succ = new HashMap();
    public static final HashMap<Pair<RegistryKey<World>, EntityClassification>, Long> spawn_ticks_spawns = new HashMap();
    public static final HashMap<Pair<RegistryKey<World>, EntityClassification>, Long> spawn_cap_count = new HashMap();
    public static final HashMap<Pair<RegistryKey<World>, EntityClassification>, EvictingQueue<Pair<EntityType<?>, BlockPos>>> spawned_mobs = new HashMap();
    public static final HashMap<EntityClassification, Integer> spawn_tries = new HashMap();
    public static BlockPos lower_spawning_limit = null;
    public static BlockPos upper_spawning_limit = null;
    public static HashMap<EntityClassification, Long> local_spawns = null;
    public static HashSet<EntityClassification> first_chunk_marker = null;
    public static final int MAGIC_NUMBER;

    public static void registerSpawn(MobEntity mob, EntityClassification cat, BlockPos pos) {
        if (lower_spawning_limit != null && (lower_spawning_limit.func_177958_n() > pos.func_177958_n() || pos.func_177958_n() > upper_spawning_limit.func_177958_n() || lower_spawning_limit.func_177956_o() > pos.func_177956_o() || pos.func_177956_o() > upper_spawning_limit.func_177956_o() || lower_spawning_limit.func_177952_p() > pos.func_177952_p() || pos.func_177952_p() > upper_spawning_limit.func_177952_p())) {
            return;
        }
        Pair key = Pair.of((Object)mob.field_70170_p.func_234923_W_(), (Object)cat);
        long count = spawn_stats.get(key).getOrDefault((Object)mob.func_200600_R(), 0L);
        spawn_stats.get(key).put((Object)mob.func_200600_R(), count + 1L);
        spawned_mobs.get(key).put(Pair.of((Object)mob.func_200600_R(), (Object)pos));
        if (!local_spawns.containsKey(cat)) {
            Curtain.LOGGER.error("Rogue spawn detected for category " + cat.func_220363_a() + " for mob " + mob.func_200600_R().func_212546_e().getString() + ". If you see this message let curtain peeps know about it on github issues.");
            local_spawns.put(cat, 0L);
        }
        local_spawns.put(cat, local_spawns.get(cat) + 1L);
    }

    public static List<ITextComponent> printMobcapsForDimension(ServerWorld world, boolean multiline) {
        RegistryKey dim = world.func_234923_W_();
        String name = dim.func_240901_a_().func_110623_a();
        ArrayList<ITextComponent> lst = new ArrayList<ITextComponent>();
        if (multiline) {
            lst.add((ITextComponent)Messenger.s(String.format("Mobcaps for %s:", name)));
        }
        WorldEntitySpawner.EntityDensityManager lastSpawner = world.func_72863_F().func_241101_k_();
        Object2IntMap dimCounts = lastSpawner.func_234995_b_();
        int chunkcount = chunkCounts.getOrDefault(dim, -1);
        if (dimCounts == null || chunkcount < 0) {
            lst.add((ITextComponent)Messenger.c("g   --UNAVAILABLE--"));
            return lst;
        }
        ArrayList<Object> shortCodes = new ArrayList<Object>();
        for (EntityClassification enumcreaturetype : EntityClassification.values()) {
            int cur = dimCounts.getOrDefault((Object)enumcreaturetype, -1);
            int max = (int)((double)chunkcount * ((double)enumcreaturetype.func_75601_b() / (double)MAGIC_NUMBER));
            String color = Messenger.heatmap_color(cur, max);
            String mobColor = Messenger.creatureTypeColor(enumcreaturetype);
            if (multiline) {
                int rounds = spawn_tries.get(enumcreaturetype);
                lst.add((ITextComponent)Messenger.c(String.format("w   %s: ", enumcreaturetype.func_220363_a()), cur < 0 ? "g -" : color + " " + cur, "g  / ", mobColor + " " + max, rounds == 1 ? "w " : String.format("gi  (%d rounds/tick)", spawn_tries.get(enumcreaturetype))));
                continue;
            }
            shortCodes.add(color + " " + (Serializable)(cur < 0 ? "-" : Integer.valueOf(cur)));
            shortCodes.add("g /");
            shortCodes.add(mobColor + " " + max);
            shortCodes.add("g ,");
        }
        if (!multiline) {
            if (shortCodes.size() > 0) {
                shortCodes.remove(shortCodes.size() - 1);
                lst.add((ITextComponent)Messenger.c(shortCodes.toArray(new Object[0])));
            } else {
                lst.add((ITextComponent)Messenger.c("g   --UNAVAILABLE--"));
            }
        }
        return lst;
    }

    public static List<ITextComponent> recent_spawns(World world, EntityClassification creature_type) {
        ArrayList<ITextComponent> lst = new ArrayList<ITextComponent>();
        if (track_spawns == 0L) {
            lst.add((ITextComponent)Messenger.s("Spawn tracking not started"));
            return lst;
        }
        String type_code = creature_type.func_220363_a();
        lst.add((ITextComponent)Messenger.s(String.format("Recent %s spawns:", type_code)));
        for (Pair pair : spawned_mobs.get(Pair.of((Object)world.func_234923_W_(), (Object)creature_type)).keySet()) {
            lst.add((ITextComponent)Messenger.c("w  - ", Messenger.tp("wb", (BlockPos)pair.getRight()), String.format("w : %s", ((EntityType)pair.getLeft()).func_212546_e().getString())));
        }
        if (lst.size() == 1) {
            lst.add((ITextComponent)Messenger.s(" - Nothing spawned yet, sorry."));
        }
        return lst;
    }

    public static List<ITextComponent> show_mobcaps(BlockPos pos, ServerWorld worldIn) {
        DyeColor under = WoolTool.getWoolColorAtPosition((World)worldIn, pos.func_177977_b());
        if (under == null) {
            if (track_spawns > 0L) {
                return SpawnReporter.tracking_report((World)worldIn);
            }
            return SpawnReporter.printMobcapsForDimension(worldIn, true);
        }
        EntityClassification creature_type = SpawnReporter.get_type_code_from_wool_code(under);
        if (creature_type != null) {
            if (track_spawns > 0L) {
                return SpawnReporter.recent_spawns((World)worldIn, creature_type);
            }
            return SpawnReporter.printEntitiesByType(creature_type, (World)worldIn, true);
        }
        if (track_spawns > 0L) {
            return SpawnReporter.tracking_report((World)worldIn);
        }
        return SpawnReporter.printMobcapsForDimension(worldIn, true);
    }

    public static EntityClassification get_type_code_from_wool_code(DyeColor color) {
        return switch (color) {
            case DyeColor.RED -> EntityClassification.MONSTER;
            case DyeColor.GREEN -> EntityClassification.CREATURE;
            case DyeColor.BLUE -> EntityClassification.WATER_CREATURE;
            case DyeColor.BROWN -> EntityClassification.AMBIENT;
            case DyeColor.CYAN -> EntityClassification.WATER_AMBIENT;
            default -> null;
        };
    }

    public static List<ITextComponent> printEntitiesByType(EntityClassification cat, World worldIn, boolean all) {
        ArrayList<ITextComponent> lst = new ArrayList<ITextComponent>();
        lst.add((ITextComponent)Messenger.s(String.format("Loaded entities for %s class:", cat)));
        for (Entity entity : ((ServerWorld)worldIn).func_217482_a(null, e -> e.func_200600_R().func_220339_d() == cat)) {
            boolean persistent;
            boolean bl = persistent = entity instanceof MobEntity && (((MobEntity)entity).func_104002_bU() || ((MobEntity)entity).func_213392_I());
            if (!all && persistent) continue;
            EntityType type = entity.func_200600_R();
            BlockPos pos = entity.func_233580_cy_();
            lst.add((ITextComponent)Messenger.c("w  - ", Messenger.tp(persistent ? "gb" : "wb", pos), String.format(persistent ? "g : %s" : "w : %s", type.func_212546_e().getString())));
        }
        if (lst.size() == 1) {
            lst.add((ITextComponent)Messenger.s(" - Empty."));
        }
        return lst;
    }

    public static void initialize_mocking() {
        mock_spawns = true;
    }

    public static void stop_mocking() {
        mock_spawns = false;
    }

    public static void reset_spawn_stats(MinecraftServer server, boolean full) {
        spawn_stats.clear();
        spawned_mobs.clear();
        for (EntityClassification enumcreaturetype : EntityClassification.values()) {
            if (full) {
                spawn_tries.put(enumcreaturetype, 1);
            }
            if (server == null) continue;
            for (RegistryKey dim : server.func_240770_D_()) {
                Pair key = Pair.of((Object)dim, (Object)enumcreaturetype);
                overall_spawn_ticks.put((Pair<RegistryKey<World>, EntityClassification>)key, 0L);
                spawn_attempts.put((Pair<RegistryKey<World>, EntityClassification>)key, 0L);
                spawn_ticks_full.put((Pair<RegistryKey<World>, EntityClassification>)key, 0L);
                spawn_ticks_fail.put((Pair<RegistryKey<World>, EntityClassification>)key, 0L);
                spawn_ticks_succ.put((Pair<RegistryKey<World>, EntityClassification>)key, 0L);
                spawn_ticks_spawns.put((Pair<RegistryKey<World>, EntityClassification>)key, 0L);
                spawn_cap_count.put((Pair<RegistryKey<World>, EntityClassification>)key, 0L);
                spawn_stats.put((Pair<RegistryKey<World>, EntityClassification>)key, (Object2LongMap<EntityType<?>>)new Object2LongOpenHashMap());
                spawned_mobs.put((Pair<RegistryKey<World>, EntityClassification>)key, new EvictingQueue());
            }
        }
        track_spawns = 0L;
    }

    private static String getWorldCode(RegistryKey<World> world) {
        if (world == World.field_234918_g_) {
            return "";
        }
        return "(" + world.func_240901_a_().func_110623_a().toUpperCase(Locale.ROOT).replace("THE_", "").charAt(0) + ")";
    }

    public static List<ITextComponent> tracking_report(World worldIn) {
        ArrayList<ITextComponent> report = new ArrayList<ITextComponent>();
        if (track_spawns == 0L) {
            report.add((ITextComponent)Messenger.c("w Spawn tracking disabled, type '", "wi /spawn tracking start", "/spawn tracking start", "w ' to enable"));
            return report;
        }
        long duration = (long)worldIn.func_73046_m().func_71259_af() - track_spawns;
        report.add((ITextComponent)Messenger.c("bw --------------------"));
        String simulated = mock_spawns ? "[SIMULATED] " : "";
        String location = lower_spawning_limit != null ? String.format("[in (%d, %d, %d)x(%d, %d, %d)]", lower_spawning_limit.func_177958_n(), lower_spawning_limit.func_177956_o(), lower_spawning_limit.func_177952_p(), upper_spawning_limit.func_177958_n(), upper_spawning_limit.func_177956_o(), upper_spawning_limit.func_177952_p()) : "";
        report.add((ITextComponent)Messenger.s(String.format("%sSpawn statistics %s: for %.1f min", simulated, location, (double)duration / 72000.0 * 60.0)));
        for (EntityClassification enumcreaturetype : EntityClassification.values()) {
            for (RegistryKey dim : worldIn.func_73046_m().func_240770_D_()) {
                Pair code = Pair.of((Object)dim, (Object)enumcreaturetype);
                if (spawn_ticks_spawns.get(code) <= 0L) continue;
                double hours = (double)overall_spawn_ticks.get(code).longValue() / 72000.0;
                report.add((ITextComponent)Messenger.s(String.format(" > %s%s (%.1f min), %.1f m/t, %%{%.1fF %.1f- %.1f+}; %.2f s/att", enumcreaturetype.func_220363_a().substring(0, 3), SpawnReporter.getWorldCode((RegistryKey<World>)dim), 60.0 * hours, 1.0 * (double)spawn_cap_count.get(code).longValue() / (double)spawn_attempts.get(code).longValue(), 100.0 * (double)spawn_ticks_full.get(code).longValue() / (double)spawn_attempts.get(code).longValue(), 100.0 * (double)spawn_ticks_fail.get(code).longValue() / (double)spawn_attempts.get(code).longValue(), 100.0 * (double)spawn_ticks_succ.get(code).longValue() / (double)spawn_attempts.get(code).longValue(), 1.0 * (double)spawn_ticks_spawns.get(code).longValue() / (double)(spawn_ticks_fail.get(code) + spawn_ticks_succ.get(code)))));
                for (EntityType type : spawn_stats.get(code).keySet()) {
                    report.add((ITextComponent)Messenger.s(String.format("   - %s: %d spawns, %d per hour", type.func_212546_e().getString(), spawn_stats.get(code).getLong((Object)type), 72000L * spawn_stats.get(code).getLong((Object)type) / duration)));
                }
            }
        }
        return report;
    }

    public static void killEntity(LivingEntity entity) {
        if (entity.func_184218_aH()) {
            entity.func_184187_bx().func_70106_y();
        }
        if (entity.func_184207_aI()) {
            for (Entity e : entity.func_184188_bt()) {
                e.func_70106_y();
            }
        }
        if (entity instanceof OcelotEntity) {
            for (Entity e : entity.func_130014_f_().func_72839_b((Entity)entity, entity.func_174813_aQ())) {
                e.func_70106_y();
            }
        }
        entity.func_70106_y();
    }

    private static List<MobSpawnInfo.Spawners> method_29950(ServerWorld serverWorld, StructureManager structureAccessor, ChunkGenerator chunkGenerator, EntityClassification spawnGroup, BlockPos blockPos, Biome biome) {
        return spawnGroup == EntityClassification.MONSTER && serverWorld.func_180495_p(blockPos.func_177977_b()).func_177230_c() == Blocks.field_196653_dH && structureAccessor.func_235010_a_(blockPos, false, Structure.field_236378_n_).func_75069_d() ? Structure.field_236378_n_.func_202279_e() : chunkGenerator.func_230353_a_(biome != null ? biome : serverWorld.func_226691_t_(blockPos), structureAccessor, spawnGroup, blockPos);
    }

    public static List<TextComponent> report(BlockPos pos, ServerWorld worldIn) {
        ArrayList<TextComponent> rep = new ArrayList<TextComponent>();
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        IChunk chunk = worldIn.func_217349_x(pos);
        int lc = chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE, x, z) + 1;
        String where = String.format(y >= lc ? "%d blocks above it." : "%d blocks below it.", MathHelper.func_76130_a((int)(y - lc)));
        if (y == lc) {
            where = "right at it.";
        }
        rep.add(Messenger.s(String.format("Maximum spawn Y value for (%+d, %+d) is %d. You are " + where, x, z, lc)));
        rep.add(Messenger.s("Spawns:"));
        for (EntityClassification enumcreaturetype : EntityClassification.values()) {
            String type_code = String.format("%s", enumcreaturetype).substring(0, 3);
            List<MobSpawnInfo.Spawners> lst = SpawnReporter.method_29950(worldIn, worldIn.func_241112_a_(), worldIn.func_72863_F().func_201711_g(), enumcreaturetype, pos, worldIn.func_226691_t_(pos));
            if (lst == null || lst.isEmpty()) continue;
            for (MobSpawnInfo.Spawners spawnEntry : lst) {
                MobEntity mob;
                if (EntitySpawnPlacementRegistry.func_209344_a((EntityType)spawnEntry.field_242588_c) == null) continue;
                boolean canspawn = WorldEntitySpawner.func_209382_a((EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.func_209344_a((EntityType)spawnEntry.field_242588_c), (IWorldReader)worldIn, (BlockPos)pos, (EntityType)spawnEntry.field_242588_c);
                int will_spawn = -1;
                try {
                    mob = (MobEntity)spawnEntry.field_242588_c.func_200721_a((World)worldIn);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return rep;
                }
                boolean fits_true = false;
                boolean fits_false = false;
                if (canspawn) {
                    will_spawn = 0;
                    for (int attempt = 0; attempt < 50; ++attempt) {
                        boolean fits;
                        float f = (float)x + 0.5f;
                        float f1 = (float)z + 0.5f;
                        mob.func_70012_b((double)f, (double)y, (double)f1, worldIn.field_73012_v.nextFloat() * 360.0f, 0.0f);
                        boolean fits1 = worldIn.func_226669_j_((Entity)mob);
                        EntityType etype = mob.func_200600_R();
                        for (int i = 0; i < 20; ++i) {
                            if (!EntitySpawnPlacementRegistry.func_223515_a((EntityType)etype, (IServerWorld)worldIn, (SpawnReason)SpawnReason.NATURAL, (BlockPos)pos, (Random)worldIn.field_73012_v) || !WorldEntitySpawner.func_209382_a((EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.func_209344_a((EntityType)etype), (IWorldReader)worldIn, (BlockPos)pos, (EntityType)etype) || !mob.func_213380_a((IWorld)worldIn, SpawnReason.NATURAL)) continue;
                            if (etype == EntityType.field_200781_U) {
                                BlockState blockState = worldIn.func_180495_p(pos.func_177977_b());
                                if (pos.func_177956_o() < worldIn.func_181545_F() || !blockState.func_203425_a(Blocks.field_196658_i) && !blockState.func_235714_a_((ITag)BlockTags.field_206952_E)) continue;
                            }
                            ++will_spawn;
                        }
                        mob.func_213386_a((IServerWorld)worldIn, worldIn.func_175649_E(mob.func_233580_cy_()), SpawnReason.NATURAL, null, null);
                        boolean bl = fits = fits1 && worldIn.func_226669_j_((Entity)mob);
                        if (fits) {
                            fits_true = true;
                        } else {
                            fits_false = true;
                        }
                        SpawnReporter.killEntity((LivingEntity)mob);
                        try {
                            mob = (MobEntity)spawnEntry.field_242588_c.func_200721_a((World)worldIn);
                            continue;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            return rep;
                        }
                    }
                }
                String creature_name = mob.func_200600_R().func_212546_e().getString();
                String pack_size = String.format("%d", mob.func_70641_bl());
                int weight = ((WeightedRandomItemMixin)spawnEntry).getWeight();
                if (canspawn) {
                    String c = fits_true && will_spawn > 0 ? "e" : "gi";
                    rep.add(Messenger.c(String.format("%s %s: %s (%d:%d-%d/%d), can: ", c, type_code, creature_name, weight, spawnEntry.field_242589_d, spawnEntry.field_242590_e, mob.func_70641_bl()), "l YES", c + " , fit: ", fits_true && fits_false ? "y YES and NO" : (fits_true ? "l YES" : "r NO"), c + " , will: ", (will_spawn > 0 ? "l " : "r ") + Math.round((double)will_spawn) / 10L + "%"));
                } else {
                    rep.add(Messenger.c(String.format("gi %s: %s (%d:%d-%d/%d), can: ", type_code, creature_name, weight, spawnEntry.field_242589_d, spawnEntry.field_242590_e, mob.func_70641_bl()), "n NO"));
                }
                SpawnReporter.killEntity((LivingEntity)mob);
            }
        }
        return rep;
    }

    static {
        SpawnReporter.reset_spawn_stats(null, true);
        MAGIC_NUMBER = (int)Math.pow(17.0, 2.0);
    }
}

