/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain.utils;

import dev.dubhe.curtain.CurtainRules;
import dev.dubhe.curtain.features.logging.helper.ExplosionLogHelper;
import dev.dubhe.curtain.mixins.ExplosionAccessor;
import dev.dubhe.curtain.utils.Messenger;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.ProtectionEnchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class OptimizedExplosion {
    private static List<Entity> entitylist;
    private static Vector3d vec3dmem;
    private static long tickmem;
    public static int explosionSound;
    private static Object2DoubleOpenHashMap<Pair<Vector3d, AxisAlignedBB>> densityCache;
    private static MutablePair<Vector3d, AxisAlignedBB> pairMutable;
    private static Object2ObjectOpenHashMap<BlockPos, BlockState> stateCache;
    private static Object2ObjectOpenHashMap<BlockPos, FluidState> fluidCache;
    private static BlockPos.Mutable posMutable;
    private static ObjectOpenHashSet<BlockPos> affectedBlockPositionsSet;
    private static boolean firstRay;
    private static boolean rayCalcDone;
    private static ArrayList<Float> chances;
    private static BlockPos blastChanceLocation;

    public static void doExplosionA(Explosion e, ExplosionLogHelper eLogger) {
        ExplosionAccessor eAccess = (ExplosionAccessor)e;
        OptimizedExplosion.blastCalc(e);
        if (!CurtainRules.explosionNoBlockDamage) {
            rayCalcDone = false;
            firstRay = true;
            OptimizedExplosion.getAffectedPositionsOnPlaneY(e, 0, 0, 15, 0, 15);
            OptimizedExplosion.getAffectedPositionsOnPlaneY(e, 15, 0, 15, 0, 15);
            OptimizedExplosion.getAffectedPositionsOnPlaneX(e, 0, 1, 14, 0, 15);
            OptimizedExplosion.getAffectedPositionsOnPlaneX(e, 15, 1, 14, 0, 15);
            OptimizedExplosion.getAffectedPositionsOnPlaneZ(e, 0, 1, 14, 1, 14);
            OptimizedExplosion.getAffectedPositionsOnPlaneZ(e, 15, 1, 14, 1, 14);
            stateCache.clear();
            fluidCache.clear();
            e.func_180343_e().addAll(affectedBlockPositionsSet);
            affectedBlockPositionsSet.clear();
        }
        float f3 = eAccess.getRadius() * 2.0f;
        int k1 = MathHelper.func_76128_c((double)(eAccess.getX() - (double)f3 - 1.0));
        int l1 = MathHelper.func_76128_c((double)(eAccess.getX() + (double)f3 + 1.0));
        int i2 = MathHelper.func_76128_c((double)(eAccess.getY() - (double)f3 - 1.0));
        int i1 = MathHelper.func_76128_c((double)(eAccess.getY() + (double)f3 + 1.0));
        int j2 = MathHelper.func_76128_c((double)(eAccess.getZ() - (double)f3 - 1.0));
        int j1 = MathHelper.func_76128_c((double)(eAccess.getZ() + (double)f3 + 1.0));
        Vector3d vec3d = new Vector3d(eAccess.getX(), eAccess.getY(), eAccess.getZ());
        if (vec3dmem == null || !vec3dmem.equals((Object)vec3d) || tickmem != eAccess.getLevel().func_82737_E()) {
            vec3dmem = vec3d;
            tickmem = eAccess.getLevel().func_82737_E();
            entitylist = eAccess.getLevel().func_72839_b(null, new AxisAlignedBB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
            explosionSound = 0;
        }
        ++explosionSound;
        Entity explodingEntity = eAccess.getSource();
        for (int k2 = 0; k2 < entitylist.size(); ++k2) {
            PlayerEntity player;
            double d9;
            double d7;
            double d5;
            double d13;
            double d12;
            Entity entity = entitylist.get(k2);
            if (entity == explodingEntity) {
                OptimizedExplosion.removeFast(entitylist, k2);
                --k2;
                continue;
            }
            if (entity instanceof TNTEntity && explodingEntity != null && entity.func_226277_ct_() == explodingEntity.func_226277_ct_() && entity.func_226278_cu_() == explodingEntity.func_226278_cu_() && entity.func_226281_cx_() == explodingEntity.func_226281_cx_()) {
                if (eLogger == null) continue;
                eLogger.onEntityImpacted(entity, new Vector3d(0.0, -0.9923437498509884, 0.0));
                continue;
            }
            if (entity.func_180427_aV() || !((d12 = Math.sqrt(entity.func_70092_e(eAccess.getX(), eAccess.getY(), eAccess.getZ())) / (double)f3) <= 1.0) || (d13 = Math.sqrt((d5 = entity.func_226277_ct_() - eAccess.getX()) * d5 + (d7 = (entity instanceof TNTEntity ? entity.func_226278_cu_() : entity.func_226280_cw_()) - eAccess.getY()) * d7 + (d9 = entity.func_226281_cx_() - eAccess.getZ()) * d9)) == 0.0) continue;
            d5 /= d13;
            d7 /= d13;
            d9 /= d13;
            pairMutable.setLeft((Object)vec3d);
            pairMutable.setRight((Object)entity.func_174813_aQ());
            double density = densityCache.getOrDefault(pairMutable, Double.MAX_VALUE);
            if (density == Double.MAX_VALUE) {
                Pair pair = Pair.of((Object)vec3d, (Object)entity.func_174813_aQ());
                density = Explosion.func_222259_a((Vector3d)vec3d, (Entity)entity);
                densityCache.put((Object)pair, density);
            }
            double d10 = (1.0 - d12) * density;
            entity.func_70097_a(e.func_199591_b(), (float)((int)((d10 * d10 + d10) / 2.0 * 7.0 * (double)f3 + 1.0)));
            double d11 = d10;
            if (entity instanceof LivingEntity) {
                d11 = ProtectionEnchantment.func_92092_a((LivingEntity)((LivingEntity)entity), (double)d10);
            }
            if (eLogger != null) {
                eLogger.onEntityImpacted(entity, new Vector3d(d5 * d11, d7 * d11, d9 * d11));
            }
            entity.func_213317_d(entity.func_213322_ci().func_72441_c(d5 * d11, d7 * d11, d9 * d11));
            if (!(entity instanceof PlayerEntity) || (player = (PlayerEntity)entity).func_175149_v() || player.func_184812_l_() && player.field_71075_bZ.field_75100_b) continue;
            e.func_77277_b().put(player, new Vector3d(d5 * d10, d7 * d10, d9 * d10));
        }
        densityCache.clear();
    }

    public static <T> void shuffle(ObjectArrayList<T> objectArrayList, Random randomSource) {
        int i;
        for (int j = i = objectArrayList.size(); j > 1; --j) {
            int k = randomSource.nextInt(j);
            objectArrayList.set(j - 1, objectArrayList.set(k, objectArrayList.get(j - 1)));
        }
    }

    public static void doExplosionB(Explosion e, boolean spawnParticles) {
        boolean damagesTerrain;
        ExplosionAccessor eAccess = (ExplosionAccessor)e;
        World world = eAccess.getLevel();
        double posX = eAccess.getX();
        double posY = eAccess.getY();
        double posZ = eAccess.getZ();
        boolean bl = damagesTerrain = eAccess.getBlockInteraction() != Explosion.Mode.NONE;
        if (explosionSound < 100 || explosionSound % 100 == 0) {
            world.func_184148_a(null, posX, posY, posZ, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            if (spawnParticles) {
                if (eAccess.getRadius() >= 2.0f && damagesTerrain) {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197626_s, posX, posY, posZ, 1.0, 0.0, 0.0);
                } else {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197627_t, posX, posY, posZ, 1.0, 0.0, 0.0);
                }
            }
        }
        if (damagesTerrain) {
            ObjectArrayList objectArrayList = new ObjectArrayList();
            OptimizedExplosion.shuffle((ObjectArrayList)e.func_180343_e(), world.field_73012_v);
            for (BlockPos blockpos : e.func_180343_e()) {
                BlockState state = world.func_180495_p(blockpos);
                Block block = state.func_177230_c();
                if (state.func_185904_a() == Material.field_151579_a) continue;
                if (block.func_149659_a(e) && world instanceof ServerWorld) {
                    ServerWorld serverLevel = (ServerWorld)world;
                    TileEntity blockEntity = state.hasTileEntity() ? world.func_175625_s(blockpos) : null;
                    LootContext.Builder lootBuilder = new LootContext.Builder((ServerWorld)eAccess.getLevel()).func_216023_a(eAccess.getLevel().field_73012_v).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)blockpos)).func_216015_a(LootParameters.field_216289_i, (Object)ItemStack.field_190927_a).func_216021_b(LootParameters.field_216288_h, (Object)blockEntity).func_216021_b(LootParameters.field_216281_a, (Object)eAccess.getSource());
                    if (eAccess.getBlockInteraction() == Explosion.Mode.DESTROY) {
                        lootBuilder.func_216015_a(LootParameters.field_216290_j, (Object)Float.valueOf(eAccess.getRadius()));
                    }
                    state.func_215706_a(serverLevel, blockpos, ItemStack.field_190927_a);
                    state.func_215693_a(lootBuilder).forEach(itemStackx -> OptimizedExplosion.method_24023((ObjectArrayList<Pair<ItemStack, BlockPos>>)objectArrayList, itemStackx, blockpos.func_185334_h()));
                }
                world.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 3);
                block.func_180652_a(world, blockpos, e);
            }
            objectArrayList.forEach(p -> Block.func_180635_a((World)world, (BlockPos)((BlockPos)p.getRight()), (ItemStack)((ItemStack)p.getLeft())));
        }
        if (eAccess.isFire()) {
            for (BlockPos blockpos1 : e.func_180343_e()) {
                Chunk chunk = world.func_212866_a_(blockpos1.func_177958_n() >> 4, blockpos1.func_177952_p() >> 4);
                BlockPos down = blockpos1.func_177979_c(1);
                if (eAccess.getRandom().nextInt(3) != 0 || chunk.func_180495_p(blockpos1).func_185904_a() != Material.field_151579_a || !chunk.func_180495_p(down).func_200015_d((IBlockReader)world, down)) continue;
                world.func_175656_a(blockpos1, Blocks.field_150480_ab.func_176223_P());
            }
        }
    }

    private static void method_24023(ObjectArrayList<Pair<ItemStack, BlockPos>> objectArrayList, ItemStack itemStack, BlockPos blockPos) {
        int i = objectArrayList.size();
        for (int j = 0; j < i; ++j) {
            Pair pair = (Pair)objectArrayList.get(j);
            ItemStack itemStack2 = (ItemStack)pair.getLeft();
            if (!ItemEntity.func_226532_a_((ItemStack)itemStack2, (ItemStack)itemStack)) continue;
            ItemStack itemStack3 = ItemEntity.func_226533_a_((ItemStack)itemStack2, (ItemStack)itemStack, (int)16);
            objectArrayList.set(j, (Object)Pair.of((Object)itemStack3, (Object)((BlockPos)pair.getRight())));
            if (!itemStack.func_190926_b()) continue;
            return;
        }
        objectArrayList.add((Object)Pair.of((Object)itemStack, (Object)blockPos));
    }

    private static void removeFast(List<Entity> lst, int index) {
        if (index < lst.size() - 1) {
            lst.set(index, lst.get(lst.size() - 1));
        }
        lst.remove(lst.size() - 1);
    }

    private static void rayCalcs(Explosion e) {
        ExplosionAccessor eAccess = (ExplosionAccessor)e;
        boolean first = true;
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    float rand = eAccess.getLevel().field_73012_v.nextFloat();
                    if (CurtainRules.tntRandomRange >= 0.0) {
                        rand = (float)CurtainRules.tntRandomRange;
                    }
                    double d4 = eAccess.getX();
                    double d6 = eAccess.getY();
                    double d8 = eAccess.getZ();
                    float f1 = 0.3f;
                    for (float f = eAccess.getRadius() * (0.7f + rand * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        BlockPos blockpos = OptimizedExplosion.containing(d4, d6, d8);
                        BlockState state = eAccess.getLevel().func_180495_p(blockpos);
                        FluidState fluidState = eAccess.getLevel().func_204610_c(blockpos);
                        if (state.func_185904_a() != Material.field_151579_a) {
                            float f2 = Math.max(state.func_177230_c().func_149638_a(), fluidState.func_210200_l());
                            if (eAccess.getSource() != null) {
                                f2 = eAccess.getSource().func_180428_a(e, (IBlockReader)eAccess.getLevel(), blockpos, state, fluidState, f2);
                            }
                            f -= (f2 + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && (eAccess.getSource() == null || eAccess.getSource().func_174816_a(e, (IBlockReader)eAccess.getLevel(), blockpos, state, f))) {
                            affectedBlockPositionsSet.add((Object)blockpos);
                        } else if (first) {
                            return;
                        }
                        first = false;
                        d4 += d0 * (double)0.3f;
                        d6 += d1 * (double)0.3f;
                        d8 += d2 * (double)0.3f;
                    }
                }
            }
        }
    }

    private static void getAffectedPositionsOnPlaneX(Explosion e, int x, int yStart, int yEnd, int zStart, int zEnd) {
        if (!rayCalcDone) {
            double xRel = (double)x / 15.0 * 2.0 - 1.0;
            for (int z = zStart; z <= zEnd; ++z) {
                double zRel = (double)z / 15.0 * 2.0 - 1.0;
                for (int y = yStart; y <= yEnd; ++y) {
                    double yRel = (double)y / 15.0 * 2.0 - 1.0;
                    if (!OptimizedExplosion.checkAffectedPosition(e, xRel, yRel, zRel)) continue;
                    return;
                }
            }
        }
    }

    private static void getAffectedPositionsOnPlaneY(Explosion e, int y, int xStart, int xEnd, int zStart, int zEnd) {
        if (!rayCalcDone) {
            double yRel = (double)y / 15.0 * 2.0 - 1.0;
            for (int z = zStart; z <= zEnd; ++z) {
                double zRel = (double)z / 15.0 * 2.0 - 1.0;
                for (int x = xStart; x <= xEnd; ++x) {
                    double xRel = (double)x / 15.0 * 2.0 - 1.0;
                    if (!OptimizedExplosion.checkAffectedPosition(e, xRel, yRel, zRel)) continue;
                    return;
                }
            }
        }
    }

    private static void getAffectedPositionsOnPlaneZ(Explosion e, int z, int xStart, int xEnd, int yStart, int yEnd) {
        if (!rayCalcDone) {
            double zRel = (double)z / 15.0 * 2.0 - 1.0;
            for (int x = xStart; x <= xEnd; ++x) {
                double xRel = (double)x / 15.0 * 2.0 - 1.0;
                for (int y = yStart; y <= yEnd; ++y) {
                    double yRel = (double)y / 15.0 * 2.0 - 1.0;
                    if (!OptimizedExplosion.checkAffectedPosition(e, xRel, yRel, zRel)) continue;
                    return;
                }
            }
        }
    }

    private static boolean checkAffectedPosition(Explosion e, double xRel, double yRel, double zRel) {
        ExplosionAccessor eAccess = (ExplosionAccessor)e;
        double len = Math.sqrt(xRel * xRel + yRel * yRel + zRel * zRel);
        double xInc = xRel / len * 0.3;
        double yInc = yRel / len * 0.3;
        double zInc = zRel / len * 0.3;
        float rand = eAccess.getLevel().field_73012_v.nextFloat();
        float sizeRand = CurtainRules.tntRandomRange >= 0.0 ? (float)CurtainRules.tntRandomRange : rand;
        double posX = eAccess.getX();
        double posY = eAccess.getY();
        double posZ = eAccess.getZ();
        float f1 = 0.3f;
        for (float size = eAccess.getRadius() * (0.7f + sizeRand * 0.6f); size > 0.0f; size -= 0.22500001f) {
            posMutable.func_189532_c(posX, posY, posZ);
            BlockState state = (BlockState)stateCache.get((Object)posMutable);
            FluidState fluid = (FluidState)fluidCache.get((Object)posMutable);
            BlockPos posImmutable = null;
            if (state == null) {
                posImmutable = posMutable.func_185334_h();
                state = eAccess.getLevel().func_180495_p(posImmutable);
                stateCache.put((Object)posImmutable, (Object)state);
                fluid = eAccess.getLevel().func_204610_c(posImmutable);
                fluidCache.put((Object)posImmutable, (Object)fluid);
            }
            if (state.func_185904_a() != Material.field_151579_a) {
                float resistance = Math.max(state.func_177230_c().func_149638_a(), fluid.func_210200_l());
                if (eAccess.getSource() != null) {
                    resistance = eAccess.getSource().func_180428_a(e, (IBlockReader)eAccess.getLevel(), (BlockPos)posMutable, state, fluid, resistance);
                }
                size -= (resistance + 0.3f) * 0.3f;
            }
            if (size > 0.0f) {
                if (eAccess.getSource() == null || eAccess.getSource().func_174816_a(e, (IBlockReader)eAccess.getLevel(), (BlockPos)posMutable, state, size)) {
                    affectedBlockPositionsSet.add((Object)(posImmutable != null ? posImmutable : posMutable.func_185334_h()));
                }
            } else if (firstRay) {
                rayCalcDone = true;
                return true;
            }
            firstRay = false;
            posX += xInc;
            posY += yInc;
            posZ += zInc;
        }
        return false;
    }

    public static void setBlastChanceLocation(BlockPos p) {
        blastChanceLocation = p;
    }

    private static void blastCalc(Explosion e) {
        ExplosionAccessor eAccess = (ExplosionAccessor)e;
        if (blastChanceLocation == null || OptimizedExplosion.distToLowCornerSqr(blastChanceLocation, eAccess.getX(), eAccess.getY(), eAccess.getZ()) > 200.0) {
            return;
        }
        chances.clear();
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = eAccess.getX();
                    double d6 = eAccess.getY();
                    double d8 = eAccess.getZ();
                    boolean found = false;
                    float f1 = 0.3f;
                    for (float f = eAccess.getRadius() * 1.3f; f > 0.0f; f -= 0.22500001f) {
                        BlockPos blockpos = OptimizedExplosion.containing(d4, d6, d8);
                        BlockState state = eAccess.getLevel().func_180495_p(blockpos);
                        FluidState fluidState = eAccess.getLevel().func_204610_c(blockpos);
                        if (state.func_185904_a() != Material.field_151579_a) {
                            float f2 = Math.max(state.func_177230_c().func_149638_a(), fluidState.func_210200_l());
                            if (eAccess.getSource() != null) {
                                f2 = eAccess.getSource().func_180428_a(e, (IBlockReader)eAccess.getLevel(), blockpos, state, fluidState, f2);
                            }
                            f -= (f2 + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && (eAccess.getSource() == null || eAccess.getSource().func_174816_a(e, (IBlockReader)eAccess.getLevel(), blockpos, state, f)) && !found && blockpos.equals((Object)blastChanceLocation)) {
                            chances.add(Float.valueOf(f));
                            found = true;
                        }
                        d4 += d0 * (double)0.3f;
                        d6 += d1 * (double)0.3f;
                        d8 += d2 * (double)0.3f;
                    }
                }
            }
        }
    }

    private static void showTNTblastChance(Explosion e) {
        ExplosionAccessor eAccess = (ExplosionAccessor)e;
        double randMax = 0.6f * eAccess.getRadius();
        double total = 0.0;
        boolean fullyBlownUp = false;
        boolean first = true;
        int rays = 0;
        for (float f3 : chances) {
            ++rays;
            double calc = (double)f3 - randMax;
            if (calc > 0.0) {
                fullyBlownUp = true;
            }
            double chancePerRay = Math.abs(calc) / randMax;
            if (fullyBlownUp) continue;
            if (first) {
                first = false;
                total = chancePerRay;
                continue;
            }
            total *= chancePerRay;
        }
        if (fullyBlownUp) {
            total = 0.0;
        }
        double chance = 1.0 - total;
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setRoundingMode(RoundingMode.DOWN);
        nf.setMaximumFractionDigits(2);
        for (PlayerEntity player : eAccess.getLevel().func_217369_A()) {
            Messenger.m(player, "w Pop: ", "c " + nf.format(chance) + " ", "^w Chance for the block to be destroyed by the blast: " + chance, "?" + chance, "w Remain: ", String.format("c %.2f ", total), "^w Chance the block survives the blast: " + total, "?" + total, "w Rays: ", String.format("c %d ", rays), "^w TNT blast rays going through the block", "?" + rays, "w Size: ", String.format("c %.1f ", Float.valueOf(eAccess.getRadius())), "^w TNT blast size", "?" + eAccess.getRadius(), "w @: ", String.format("c [%.1f %.1f %.1f] ", eAccess.getX(), eAccess.getY(), eAccess.getZ()), "^w TNT blast location X:" + eAccess.getX() + " Y:" + eAccess.getY() + " Z:" + eAccess.getZ(), "?" + eAccess.getX() + " " + eAccess.getY() + " " + eAccess.getZ());
        }
    }

    public static BlockPos containing(double x, double y, double z) {
        return new BlockPos(MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z));
    }

    private static double distToLowCornerSqr(BlockPos pos, double x, double y, double z) {
        double var1 = (double)pos.func_177958_n() - x;
        double var2 = (double)pos.func_177956_o() - y;
        double var3 = (double)pos.func_177952_p() - z;
        return var1 * var1 + var2 * var2 + var3 * var3;
    }

    static {
        explosionSound = 0;
        densityCache = new Object2DoubleOpenHashMap();
        pairMutable = new MutablePair();
        stateCache = new Object2ObjectOpenHashMap();
        fluidCache = new Object2ObjectOpenHashMap();
        posMutable = new BlockPos.Mutable(0, 0, 0);
        affectedBlockPositionsSet = new ObjectOpenHashSet();
        chances = new ArrayList();
    }
}

