/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Messenger {
    public static final Logger LOG = LogManager.getLogger((String)"Messaging System");
    private static final Pattern colorExtract = Pattern.compile("#([0-9a-fA-F]{6})");

    public static Style parseStyle(String style) {
        Style myStyle = Style.field_240709_b_.func_240712_a_(TextFormatting.WHITE);
        for (CarpetFormatting cf : CarpetFormatting.values()) {
            myStyle = cf.apply(style, myStyle);
        }
        return myStyle;
    }

    public static String heatmap_color(double actual, double reference) {
        String color = "g";
        if (actual >= 0.0) {
            color = "e";
        }
        if (actual > 0.5 * reference) {
            color = "y";
        }
        if (actual > 0.8 * reference) {
            color = "r";
        }
        if (actual > reference) {
            color = "m";
        }
        return color;
    }

    public static String creatureTypeColor(EntityClassification type) {
        return switch (type) {
            case EntityClassification.MONSTER -> "n";
            case EntityClassification.CREATURE -> "e";
            case EntityClassification.AMBIENT -> "f";
            case EntityClassification.WATER_CREATURE -> "v";
            case EntityClassification.WATER_AMBIENT -> "q";
            default -> "w";
        };
    }

    private static TextComponent _getChatComponentFromDesc(String message, TextComponent previous_message) {
        if (((String)message).equalsIgnoreCase("")) {
            return new StringTextComponent("");
        }
        if (Character.isWhitespace(((String)message).charAt(0))) {
            message = "w" + (String)message;
        }
        int limit = ((String)message).indexOf(32);
        Object desc = message;
        String str = "";
        if (limit >= 0) {
            desc = ((String)message).substring(0, limit);
            str = ((String)message).substring(limit + 1);
        }
        if (((String)desc).charAt(0) == '/') {
            if (previous_message != null) {
                previous_message.func_230530_a_(previous_message.func_150256_b().func_240715_a_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, (String)message)));
            }
            return previous_message;
        }
        if (((String)desc).charAt(0) == '?') {
            if (previous_message != null) {
                previous_message.func_230530_a_(previous_message.func_150256_b().func_240715_a_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, ((String)message).substring(1))));
            }
            return previous_message;
        }
        if (((String)desc).charAt(0) == '!') {
            if (previous_message != null) {
                previous_message.func_230530_a_(previous_message.func_150256_b().func_240715_a_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, ((String)message).substring(1))));
            }
            return previous_message;
        }
        if (((String)desc).charAt(0) == '^') {
            if (previous_message != null) {
                previous_message.func_230530_a_(previous_message.func_150256_b().func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)Messenger.c(((String)message).substring(1)))));
            }
            return previous_message;
        }
        StringTextComponent txt = new StringTextComponent(str);
        txt.func_230530_a_(Messenger.parseStyle((String)desc));
        return txt;
    }

    public static TextComponent tp(String desc, Vector3d pos) {
        return Messenger.tp(desc, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
    }

    public static TextComponent tp(String desc, BlockPos pos) {
        return Messenger.tp(desc, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static TextComponent tp(String desc, double x, double y, double z) {
        return Messenger.tp(desc, (float)x, (float)y, (float)z);
    }

    public static TextComponent tp(String desc, float x, float y, float z) {
        return Messenger._getCoordsTextComponent(desc, x, y, z, false);
    }

    public static TextComponent tp(String desc, int x, int y, int z) {
        return Messenger._getCoordsTextComponent(desc, x, y, z, true);
    }

    public static TextComponent dbl(String style, double double_value) {
        return Messenger.c(String.format("%s %.1f", style, double_value), String.format("^w %f", double_value));
    }

    public static TextComponent dbls(String style, double ... doubles) {
        StringBuilder str = new StringBuilder(style + " [ ");
        String prefix = "";
        for (double dbl : doubles) {
            str.append(String.format("%s%.1f", prefix, dbl));
            prefix = ", ";
        }
        str.append(" ]");
        return Messenger.c(str.toString());
    }

    public static TextComponent dblf(String style, double ... doubles) {
        StringBuilder str = new StringBuilder(style + " [ ");
        String prefix = "";
        for (double dbl : doubles) {
            str.append(String.format("%s%f", prefix, dbl));
            prefix = ", ";
        }
        str.append(" ]");
        return Messenger.c(str.toString());
    }

    public static TextComponent dblt(String style, double ... doubles) {
        ArrayList<Object> components = new ArrayList<Object>();
        components.add(style + " [ ");
        String prefix = "";
        for (double dbl : doubles) {
            components.add(String.format("%s %s%.1f", style, prefix, dbl));
            components.add("?" + dbl);
            components.add("^w " + dbl);
            prefix = ", ";
        }
        components.add(style + "  ]");
        return Messenger.c(components.toArray(new Object[0]));
    }

    private static TextComponent _getCoordsTextComponent(String style, float x, float y, float z, boolean isInt) {
        String command;
        String text;
        if (isInt) {
            text = String.format("%s [ %d, %d, %d ]", style, (int)x, (int)y, (int)z);
            command = String.format("!/tp %d %d %d", (int)x, (int)y, (int)z);
        } else {
            text = String.format("%s [ %.1f, %.1f, %.1f]", style, Float.valueOf(x), Float.valueOf(y), Float.valueOf(z));
            command = String.format("!/tp %.3f %.3f %.3f", Float.valueOf(x), Float.valueOf(y), Float.valueOf(z));
        }
        return Messenger.c(text, command);
    }

    public static void m(CommandSource source, Object ... fields) {
        if (source != null) {
            source.func_197030_a((ITextComponent)Messenger.c(fields), source.func_197028_i() != null && source.func_197028_i().func_71218_a(World.field_234918_g_) != null);
        }
    }

    public static void m(PlayerEntity player, Object ... fields) {
        player.func_145747_a((ITextComponent)Messenger.c(fields), Util.field_240973_b_);
    }

    public static TextComponent c(Object ... fields) {
        StringTextComponent message = new StringTextComponent("");
        TextComponent previous_component = null;
        for (Object o : fields) {
            if (o instanceof TextComponent) {
                message.func_230529_a_((ITextComponent)((TextComponent)o));
                previous_component = (TextComponent)o;
                continue;
            }
            String txt = o.toString();
            TextComponent comp = Messenger._getChatComponentFromDesc(txt, previous_component);
            if (comp != previous_component) {
                message.func_230529_a_((ITextComponent)comp);
            }
            previous_component = comp;
        }
        return message;
    }

    public static TextComponent s(String text) {
        return Messenger.s(text, "");
    }

    public static TextComponent s(String text, String style) {
        StringTextComponent message = new StringTextComponent(text);
        message.func_230530_a_(Messenger.parseStyle(style));
        return message;
    }

    public static void send(PlayerEntity player, Collection<TextComponent> lines) {
        lines.forEach(message -> player.func_145747_a((ITextComponent)message, Util.field_240973_b_));
    }

    public static void send(CommandSource source, Collection<TextComponent> lines) {
        lines.stream().forEachOrdered(s -> source.func_197030_a((ITextComponent)s, false));
    }

    public static void print_server_message(MinecraftServer server, String message) {
        if (server == null) {
            LOG.error("Message not delivered: " + message);
        }
        server.func_145747_a((ITextComponent)new StringTextComponent(message), Util.field_240973_b_);
        TextComponent txt = Messenger.c("gi " + message);
        for (PlayerEntity entityplayer : server.func_184103_al().func_181057_v()) {
            entityplayer.func_145747_a((ITextComponent)txt, Util.field_240973_b_);
        }
    }

    public static void print_server_message(MinecraftServer server, TextComponent message) {
        if (server == null) {
            LOG.error("Message not delivered: " + message.getString());
        }
        server.func_145747_a((ITextComponent)message, Util.field_240973_b_);
        for (PlayerEntity entityplayer : server.func_184103_al().func_181057_v()) {
            entityplayer.func_145747_a((ITextComponent)message, Util.field_240973_b_);
        }
    }

    public static enum CarpetFormatting {
        ITALIC('i', (s, f) -> s.func_240722_b_(Boolean.valueOf(true))),
        STRIKE('s', (s, f) -> s.func_240721_b_(TextFormatting.STRIKETHROUGH)),
        UNDERLINE('u', (s, f) -> s.func_240721_b_(TextFormatting.UNDERLINE)),
        BOLD('b', (s, f) -> s.func_240713_a_(Boolean.valueOf(true))),
        OBFUSCATE('o', (s, f) -> s.func_240721_b_(TextFormatting.OBFUSCATED)),
        WHITE('w', (s, f) -> s.func_240712_a_(TextFormatting.WHITE)),
        YELLOW('y', (s, f) -> s.func_240712_a_(TextFormatting.YELLOW)),
        LIGHT_PURPLE('m', (s, f) -> s.func_240712_a_(TextFormatting.LIGHT_PURPLE)),
        RED('r', (s, f) -> s.func_240712_a_(TextFormatting.RED)),
        AQUA('c', (s, f) -> s.func_240712_a_(TextFormatting.AQUA)),
        GREEN('l', (s, f) -> s.func_240712_a_(TextFormatting.GREEN)),
        BLUE('t', (s, f) -> s.func_240712_a_(TextFormatting.BLUE)),
        DARK_GRAY('f', (s, f) -> s.func_240712_a_(TextFormatting.DARK_GRAY)),
        GRAY('g', (s, f) -> s.func_240712_a_(TextFormatting.GRAY)),
        GOLD('d', (s, f) -> s.func_240712_a_(TextFormatting.GOLD)),
        DARK_PURPLE('p', (s, f) -> s.func_240712_a_(TextFormatting.DARK_PURPLE)),
        DARK_RED('n', (s, f) -> s.func_240712_a_(TextFormatting.DARK_RED)),
        DARK_AQUA('q', (s, f) -> s.func_240712_a_(TextFormatting.DARK_AQUA)),
        DARK_GREEN('e', (s, f) -> s.func_240712_a_(TextFormatting.DARK_GREEN)),
        DARK_BLUE('v', (s, f) -> s.func_240712_a_(TextFormatting.DARK_BLUE)),
        BLACK('k', (s, f) -> s.func_240712_a_(TextFormatting.BLACK)),
        COLOR('#', (s, f) -> {
            Color color = Color.func_240745_a_((String)("#" + f));
            return color == null ? s : s.func_240718_a_(color);
        }, s -> {
            Matcher m = colorExtract.matcher((CharSequence)s);
            return m.find() ? m.group(1) : null;
        });

        public char code;
        public BiFunction<Style, String, Style> applier;
        public Function<String, String> container;

        private CarpetFormatting(char code, BiFunction<Style, String, Style> applier) {
            this(code, applier, s -> s.indexOf(code) >= 0 ? Character.toString(code) : null);
        }

        private CarpetFormatting(char code, BiFunction<Style, String, Style> applier, Function<String, String> container) {
            this.code = code;
            this.applier = applier;
            this.container = container;
        }

        public Style apply(String format, Style previous) {
            String fmt = this.container.apply(format);
            if (fmt != null) {
                return this.applier.apply(previous, fmt);
            }
            return previous;
        }
    }
}

