/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain.utils;

import dev.dubhe.curtain.Curtain;
import dev.dubhe.curtain.api.rules.CurtainRule;
import dev.dubhe.curtain.api.rules.RuleManager;
import dev.dubhe.curtain.utils.TranslationHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;

public class MenuHelper {
    public static TextComponent main() {
        StringTextComponent main = new StringTextComponent("");
        IFormattableTextComponent title = TranslationHelper.translate("curtain.menu.title", new Object[0]).func_240700_a_(s -> s.func_240713_a_(Boolean.valueOf(true)));
        main.func_230529_a_((ITextComponent)title).func_240702_b_("\n");
        for (CurtainRule<?> rule : Curtain.rules.ruleMap.values()) {
            main.func_230529_a_((ITextComponent)MenuHelper.rule(rule)).func_240702_b_("\n");
        }
        String v = ((ModContainer)ModList.get().getModContainerById("curtain").get()).getModInfo().getVersion().toString();
        IFormattableTextComponent version = TranslationHelper.translate("curtain.menu.version", v).func_240700_a_(s -> s.func_240712_a_(TextFormatting.GRAY));
        main.func_230529_a_((ITextComponent)version).func_240702_b_("\n");
        IFormattableTextComponent categories = TranslationHelper.translate("curtain.menu.categories", new Object[0]).func_240700_a_(s -> s.func_240713_a_(Boolean.valueOf(true)));
        main.func_230529_a_((ITextComponent)categories);
        for (String s2 : RuleManager.CATEGORIES_RULES.keySet()) {
            IFormattableTextComponent category = new StringTextComponent("").func_240700_a_(style -> style.func_240712_a_(TextFormatting.AQUA));
            category.func_240702_b_("[");
            category.func_230529_a_((ITextComponent)TranslationHelper.translate("%s.categories.%s".formatted("curtain", s2), new Object[0]));
            category.func_240702_b_("]");
            category.func_240702_b_(" ");
            category.func_240700_a_(style -> style.func_240715_a_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/curtain category %s".formatted(s2))));
            main.func_230529_a_((ITextComponent)category);
        }
        return main;
    }

    public static IFormattableTextComponent category(String name) {
        StringTextComponent main = new StringTextComponent("");
        StringTextComponent display = new StringTextComponent(name);
        if (RuleManager.CATEGORIES_RULES.containsKey(name)) {
            display = TranslationHelper.translate("%s.categories.%s".formatted("curtain", name), new Object[0]);
        }
        main.func_230529_a_((ITextComponent)TranslationHelper.translate("curtain.menu.category", display.getString()).func_240700_a_(style -> style.func_240713_a_(Boolean.valueOf(true))));
        for (String rule : (List)RuleManager.CATEGORIES_RULES.getOrDefault(name, new ArrayList())) {
            main.func_240702_b_("\n").func_230529_a_((ITextComponent)MenuHelper.rule(RuleManager.RULES.get(rule)));
        }
        return main;
    }

    public static TextComponent rule(CurtainRule<?> rule) {
        StringTextComponent main = new StringTextComponent("");
        StringTextComponent name = new StringTextComponent("");
        name.func_230529_a_((ITextComponent)rule.getNameComponent());
        name.func_230529_a_((ITextComponent)new StringTextComponent("(%s): ".formatted(rule.getNormalName())));
        name.func_240700_a_(style -> style.func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)rule.getDescComponent())));
        String value = String.valueOf(rule.getValue());
        Collection<String> suggestion = rule.getExamples();
        main.func_230529_a_((ITextComponent)name);
        IFormattableTextComponent v = new StringTextComponent("[%s]".formatted(value)).func_240700_a_(style -> style.func_240712_a_(rule.isDefault(value) ? TextFormatting.DARK_GREEN : TextFormatting.YELLOW).func_244282_c(Boolean.valueOf(true)).func_240715_a_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/curtain setValue %s %s".formatted(rule.getNormalName(), value))).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new StringTextComponent("\u5355\u51fb\u6765\u5feb\u901f\u586b\u5145"))));
        main.func_230529_a_((ITextComponent)v);
        for (String s : suggestion) {
            if (s.equals(value)) continue;
            main.func_240702_b_(" ");
            IFormattableTextComponent x = new StringTextComponent("[%s]".formatted(MenuHelper.replaceQuotation(s))).func_240700_a_(style -> style.func_240712_a_(rule.isDefault(MenuHelper.replaceQuotation(s)) ? TextFormatting.DARK_GREEN : TextFormatting.YELLOW).func_240715_a_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/curtain setValue %s %s".formatted(rule.getNormalName(), s))).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new StringTextComponent("\u5355\u51fb\u6765\u5feb\u901f\u586b\u5145"))));
            main.func_230529_a_((ITextComponent)x);
        }
        return main;
    }

    private static String replaceQuotation(String s) {
        return s.replace("\"", "");
    }
}

