/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain.utils;

import dev.dubhe.curtain.CurtainRules;
import dev.dubhe.curtain.api.rules.CurtainRule;
import dev.dubhe.curtain.api.rules.RuleManager;
import dev.dubhe.curtain.utils.TranslationHelper;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class CurtainRulesGenerator {
    public static void main(String[] args) {
        RuleManager.addRules(CurtainRules.class);
        CurtainRulesGenerator.setTrans();
        StringBuilder sb = new StringBuilder("* Add Features\n");
        for (Map.Entry<String, CurtainRule<?>> entry : RuleManager.RULES.entrySet()) {
            CurtainRule<?> rule = entry.getValue();
            sb.append("    * ").append(entry.getKey()).append("\n");
            sb.append("        * \u540d\u79f0\uff1a`").append(TranslationHelper.translate(rule.getNameTranslationKey(), new Object[0]).getString()).append("`\n");
            sb.append("        * \u63cf\u8ff0\uff1a`").append(TranslationHelper.translate(rule.getDescTranslationKey(), new Object[0]).getString()).append("`\n");
            sb.append("        * \u7c7b\u578b\uff1a`").append(CurtainRulesGenerator.getTypeString(rule.getType())).append("`\n");
            sb.append("        * \u9ed8\u8ba4\uff1a`").append(rule.getDefaultValue()).append("`\n");
            String[] suggestions = rule.getSuggestions();
            StringBuilder suggestion = new StringBuilder();
            for (String s : suggestions) {
                suggestion.append("`").append(s).append("`").append(", ");
            }
            String str = suggestion.toString();
            sb.append("        * \u5efa\u8bae\uff1a").append(str, 0, str.length() - 2).append("\n");
            String[] categories = rule.getCategories();
            StringBuilder category = new StringBuilder();
            for (String s : categories) {
                category.append("`").append(TranslationHelper.translate("%s.categories.%s".formatted("curtain", s), new Object[0]).getString()).append("`").append(", ");
            }
            str = category.toString();
            sb.append("        * \u5206\u7c7b\uff1a").append(str, 0, str.length() - 2).append("\n");
        }
        try (FileWriter fileWriter = new FileWriter("RULES.MD");){
            fileWriter.write("");
            fileWriter.write(sb.toString());
            fileWriter.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void setTrans() {
        InputStream stream = TranslationHelper.class.getClassLoader().getResourceAsStream("assets/curtain/lang/zh_cn.json");
        TranslationHelper.addTransMap("zh_cn", TranslationHelper.getTranslationFromResourcePath(stream));
        stream = TranslationHelper.class.getClassLoader().getResourceAsStream("assets/curtain/lang/en_us.json");
        TranslationHelper.addTransMap("en_us", TranslationHelper.getTranslationFromResourcePath(stream));
    }

    private static String getTypeString(Class<?> clazz) {
        if (clazz != Boolean.TYPE && clazz != Boolean.class) {
            if (clazz != Integer.TYPE && clazz != Integer.class) {
                if (clazz == String.class) {
                    return "String";
                }
                return clazz != Double.TYPE && clazz != Double.class ? null : "Double";
            }
            return "Integer";
        }
        return "Boolean";
    }
}

