/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain.utils;

import dev.dubhe.curtain.CurtainRules;
import dev.dubhe.curtain.features.player.fakes.IPistonBlock;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.EndRodBlock;
import net.minecraft.block.HopperBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.ObserverBlock;
import net.minecraft.block.PistonBlock;
import net.minecraft.block.PistonBlockStructureHelper;
import net.minecraft.block.RailBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.dispenser.OptionalDispenseBehavior;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class BlockRotator {
    public static boolean flipBlockWithCactus(BlockState state, World world, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (!(player.field_71075_bZ.field_75099_e && CurtainRules.flippingCactus && BlockRotator.playerHoldsCactusMainhand(player))) {
            return false;
        }
        CurtainRules.impendingFillSkipUpdates.set(true);
        boolean retval = BlockRotator.flipBlock(state, world, player, hand, hit);
        CurtainRules.impendingFillSkipUpdates.set(false);
        return retval;
    }

    private static Direction rotateClockwise(Direction direction, Direction.Axis direction$Axis_1) {
        switch (direction$Axis_1) {
            case X: {
                if (direction != Direction.WEST && direction != Direction.EAST) {
                    return BlockRotator.rotateXClockwise(direction);
                }
                return direction;
            }
            case Y: {
                if (direction != Direction.UP && direction != Direction.DOWN) {
                    return BlockRotator.rotateYClockwise(direction);
                }
                return direction;
            }
            case Z: {
                if (direction != Direction.NORTH && direction != Direction.SOUTH) {
                    return BlockRotator.rotateZClockwise(direction);
                }
                return direction;
            }
        }
        throw new IllegalStateException("Unable to get CW facing for axis " + direction$Axis_1);
    }

    private static Direction rotateYClockwise(Direction dir) {
        switch (dir) {
            case NORTH: {
                return Direction.EAST;
            }
            case EAST: {
                return Direction.SOUTH;
            }
            case SOUTH: {
                return Direction.WEST;
            }
            case WEST: {
                return Direction.NORTH;
            }
        }
        throw new IllegalStateException("Unable to get Y-rotated facing of " + dir);
    }

    private static Direction rotateXClockwise(Direction dir) {
        switch (dir) {
            case NORTH: {
                return Direction.DOWN;
            }
            default: {
                throw new IllegalStateException("Unable to get X-rotated facing of " + dir);
            }
            case SOUTH: {
                return Direction.UP;
            }
            case UP: {
                return Direction.NORTH;
            }
            case DOWN: 
        }
        return Direction.SOUTH;
    }

    private static Direction rotateZClockwise(Direction dir) {
        switch (dir) {
            case EAST: {
                return Direction.DOWN;
            }
            default: {
                throw new IllegalStateException("Unable to get Z-rotated facing of " + dir);
            }
            case WEST: {
                return Direction.UP;
            }
            case UP: {
                return Direction.EAST;
            }
            case DOWN: 
        }
        return Direction.WEST;
    }

    public static ItemStack dispenserRotate(IBlockSource source, ItemStack stack) {
        Direction face;
        BlockPos blockpos;
        Direction sourceFace = (Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a);
        ServerWorld world = source.func_197524_h();
        BlockState blockstate = world.func_180495_p(blockpos = source.func_180699_d().func_177972_a(sourceFace));
        Block block = blockstate.func_177230_c();
        if (block instanceof DirectionalBlock || block instanceof DispenserBlock) {
            Direction face2 = (Direction)blockstate.func_177229_b((Property)DirectionalBlock.field_176387_N);
            if (block instanceof PistonBlock && (((Boolean)blockstate.func_177229_b((Property)PistonBlock.field_176320_b)).booleanValue() || ((IPistonBlock)block).publicShouldExtend((World)world, blockpos, face2) && new PistonBlockStructureHelper((World)world, blockpos, face2, true).func_177253_a())) {
                return stack;
            }
            Direction rotatedFace = BlockRotator.rotateClockwise(face2, sourceFace.func_176740_k());
            if (sourceFace.func_176745_a() % 2 == 0 || rotatedFace == face2) {
                rotatedFace = rotatedFace.func_176734_d();
            }
            world.func_180501_a(blockpos, (BlockState)blockstate.func_206870_a((Property)DirectionalBlock.field_176387_N, (Comparable)rotatedFace), 3);
        } else if (block instanceof HorizontalBlock) {
            if (block instanceof BedBlock) {
                return stack;
            }
            Direction face3 = (Direction)blockstate.func_177229_b((Property)HorizontalBlock.field_185512_D);
            if (sourceFace == Direction.DOWN) {
                face3 = face3.func_176734_d();
            }
            world.func_180501_a(blockpos, (BlockState)blockstate.func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)face3), 3);
        } else if (block == Blocks.field_150438_bZ && (face = (Direction)blockstate.func_177229_b((Property)HopperBlock.field_176430_a)) != Direction.DOWN) {
            face = BlockRotator.rotateClockwise(face, Direction.Axis.Y);
            world.func_180501_a(blockpos, (BlockState)blockstate.func_206870_a((Property)HopperBlock.field_176430_a, (Comparable)face), 3);
        }
        world.func_190524_a(blockpos, block, source.func_180699_d());
        return stack;
    }

    public static boolean flipBlock(BlockState state, World world, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        Block block = state.func_177230_c();
        BlockPos pos = hit.func_216350_a();
        Vector3d hitVec = hit.func_216347_e().func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        Direction facing = hit.func_216354_b();
        BlockState newState = null;
        if ((block instanceof HorizontalBlock || block instanceof RailBlock) && !(block instanceof BedBlock)) {
            newState = state.func_185907_a(Rotation.CLOCKWISE_90);
        } else if (block instanceof ObserverBlock || block instanceof EndRodBlock) {
            newState = (BlockState)state.func_206870_a((Property)DirectionalBlock.field_176387_N, (Comparable)((Direction)state.func_177229_b((Property)DirectionalBlock.field_176387_N)).func_176734_d());
        } else if (block instanceof DispenserBlock) {
            newState = (BlockState)state.func_206870_a((Property)DispenserBlock.field_176441_a, (Comparable)((Direction)state.func_177229_b((Property)DispenserBlock.field_176441_a)).func_176734_d());
        } else if (block instanceof PistonBlock) {
            if (!((Boolean)state.func_177229_b((Property)PistonBlock.field_176320_b)).booleanValue()) {
                newState = (BlockState)state.func_206870_a((Property)DirectionalBlock.field_176387_N, (Comparable)((Direction)state.func_177229_b((Property)DirectionalBlock.field_176387_N)).func_176734_d());
            }
        } else if (block instanceof SlabBlock) {
            if (((SlabBlock)block).func_220074_n(state)) {
                newState = (BlockState)state.func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)(state.func_177229_b((Property)SlabBlock.field_196505_a) == SlabType.TOP ? SlabType.BOTTOM : SlabType.TOP));
            }
        } else if (block instanceof HopperBlock) {
            if (state.func_177229_b((Property)HopperBlock.field_176430_a) != Direction.DOWN) {
                newState = (BlockState)state.func_206870_a((Property)HopperBlock.field_176430_a, (Comparable)((Direction)state.func_177229_b((Property)HopperBlock.field_176430_a)).func_176746_e());
            }
        } else if (block instanceof StairsBlock) {
            if (facing == Direction.UP && hitVec.field_72448_b == 1.0 || facing == Direction.DOWN && hitVec.field_72448_b == 0.0) {
                newState = (BlockState)state.func_206870_a((Property)StairsBlock.field_176308_b, (Comparable)(state.func_177229_b((Property)StairsBlock.field_176308_b) == Half.TOP ? Half.BOTTOM : Half.TOP));
            } else {
                boolean turnCounterClockwise = switch (facing) {
                    case Direction.NORTH -> {
                        if (hitVec.field_72450_a <= 0.5) {
                            yield true;
                        }
                        yield false;
                    }
                    case Direction.SOUTH -> {
                        if (!(hitVec.field_72450_a <= 0.5)) {
                            yield true;
                        }
                        yield false;
                    }
                    case Direction.EAST -> {
                        if (hitVec.field_72449_c <= 0.5) {
                            yield true;
                        }
                        yield false;
                    }
                    case Direction.WEST -> {
                        if (!(hitVec.field_72449_c <= 0.5)) {
                            yield true;
                        }
                        yield false;
                    }
                    default -> false;
                };
                newState = state.func_185907_a(turnCounterClockwise ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90);
            }
        } else if (block instanceof RotatedPillarBlock) {
            newState = (BlockState)state.func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)(switch ((Direction.Axis)state.func_177229_b((Property)RotatedPillarBlock.field_176298_M)) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.Axis.X -> Direction.Axis.Z;
                case Direction.Axis.Y -> Direction.Axis.X;
                case Direction.Axis.Z -> Direction.Axis.Y;
            }));
        }
        if (newState != null) {
            world.func_180501_a(pos, newState, 1026);
            world.func_225319_b(pos, state, newState);
            return true;
        }
        return false;
    }

    private static boolean playerHoldsCactusMainhand(PlayerEntity playerIn) {
        return playerIn.func_184614_ca().func_77973_b() == Items.field_221774_cw;
    }

    public static boolean flippinEligibility(Entity entity) {
        PlayerEntity p;
        return CurtainRules.flippingCactus && entity instanceof PlayerEntity && (p = (PlayerEntity)entity).func_184592_cb().func_77973_b() == Items.field_221774_cw;
    }

    public static class CactusDispenserBehaviour
    extends OptionalDispenseBehavior
    implements IDispenseItemBehavior {
        protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            if (CurtainRules.rotatorBlock) {
                return BlockRotator.dispenserRotate(source, stack);
            }
            return super.func_82487_b(source, stack);
        }
    }
}

