/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain.mixins.rules.stackable_shulker_boxes;

import dev.dubhe.curtain.CurtainRules;
import dev.dubhe.curtain.features.rules.fakes.ItemEntityInterface;
import dev.dubhe.curtain.utils.InventoryHelper;
import java.util.Objects;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemEntity.class})
public abstract class ItemEntityMixin
extends Entity
implements ItemEntityInterface {
    @Shadow
    private int field_145804_b;
    @Shadow
    private int field_70292_b;

    public ItemEntityMixin(EntityType<?> entityType, World world) {
        super(entityType, world);
    }

    @Override
    public int getPickupDelayCM() {
        return this.field_145804_b;
    }

    @Inject(method={"<init>(Lnet/minecraft/world/World;DDDLnet/minecraft/item/ItemStack;)V"}, at={@At(value="RETURN")})
    private void removeEmptyShulkerBoxTags(World worldIn, double x, double y, double z, ItemStack stack, CallbackInfo ci) {
        BlockItem blockItem;
        Item item;
        if (CurtainRules.shulkerBoxStackSize > 1 && (item = stack.func_77973_b()) instanceof BlockItem && (blockItem = (BlockItem)item).func_179223_d() instanceof ShulkerBoxBlock) {
            InventoryHelper.cleanUpShulkerBoxTag(stack);
        }
    }

    @Redirect(method={"isMergable()Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;getMaxStackSize()I"))
    private int getItemStackMaxAmount(ItemStack stack) {
        BlockItem blockItem;
        Item item;
        if (CurtainRules.shulkerBoxStackSize > 1 && (item = stack.func_77973_b()) instanceof BlockItem && (blockItem = (BlockItem)item).func_179223_d() instanceof ShulkerBoxBlock) {
            return CurtainRules.shulkerBoxStackSize;
        }
        return stack.func_77976_d();
    }

    @Inject(method={"tryToMerge"}, at={@At(value="HEAD")}, cancellable=true)
    private void tryStackShulkerBoxes(ItemEntity other, CallbackInfo ci) {
        BlockItem blockItem;
        Item item;
        ItemEntity self = (ItemEntity)this;
        ItemStack selfStack = self.func_92059_d();
        if (CurtainRules.shulkerBoxStackSize == 1 || !((item = selfStack.func_77973_b()) instanceof BlockItem) || !((blockItem = (BlockItem)item).func_179223_d() instanceof ShulkerBoxBlock)) {
            return;
        }
        ItemStack otherStack = other.func_92059_d();
        if (selfStack.func_77973_b() == otherStack.func_77973_b() && !InventoryHelper.shulkerBoxHasItems(selfStack) && !InventoryHelper.shulkerBoxHasItems(otherStack) && Objects.equals(selfStack.func_77978_p(), otherStack.func_77978_p()) && selfStack.func_190916_E() != CurtainRules.shulkerBoxStackSize) {
            int amount = Math.min(otherStack.func_190916_E(), CurtainRules.shulkerBoxStackSize - selfStack.func_190916_E());
            selfStack.func_190917_f(amount);
            self.func_92058_a(selfStack);
            this.field_145804_b = Math.max(((ItemEntityInterface)other).getPickupDelayCM(), this.field_145804_b);
            this.field_70292_b = Math.min(other.func_174872_o(), this.field_70292_b);
            otherStack.func_190918_g(amount);
            if (otherStack.func_190926_b()) {
                other.func_70106_y();
            } else {
                other.func_92058_a(otherStack);
            }
            ci.cancel();
        }
    }
}

