/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain.mixins.rules.players_sleeping_percentage;

import dev.dubhe.curtain.CurtainRules;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerWorld.class})
public class ServerWorldMixin {
    @Shadow
    @Final
    private List<ServerPlayerEntity> field_217491_A;
    @Shadow
    private boolean field_73068_P;

    @Inject(method={"updateSleepingPlayerList"}, cancellable=true, at={@At(value="HEAD")})
    private void updateOnePlayerSleeping(CallbackInfo ci) {
        if (CurtainRules.playersSleepingPercentage != 100) {
            this.field_73068_P = false;
            int playerNumber = 0;
            int sleepingPlayerNumber = 0;
            for (ServerPlayerEntity p : this.field_217491_A) {
                if (p.func_175149_v()) continue;
                ++playerNumber;
                if (!p.func_70608_bn()) continue;
                ++sleepingPlayerNumber;
            }
            this.field_73068_P = sleepingPlayerNumber > playerNumber * (CurtainRules.playersSleepingPercentage / 100);
            ci.cancel();
        }
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Ljava/util/stream/Stream;noneMatch(Ljava/util/function/Predicate;)Z"))
    private <T extends ServerPlayerEntity> boolean noneMatchSleep(Stream<T> instance, Predicate<? super T> predicate) {
        if (CurtainRules.playersSleepingPercentage != 100) {
            return instance.anyMatch(p -> !p.func_175149_v() && p.func_71026_bH());
        }
        return instance.noneMatch(predicate);
    }
}

