/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain.mixins.rules.better_sign_interaction;

import dev.dubhe.curtain.CurtainRules;
import net.minecraft.block.AbstractSignBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.WallSignBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractSignBlock.class})
public abstract class SignBlockMixin {
    private final AbstractSignBlock self = (AbstractSignBlock)this;

    @Inject(method={"use"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;getItem()Lnet/minecraft/item/Item;")}, cancellable=true)
    public void use(BlockState pState, World pLevel, BlockPos pPos, PlayerEntity pPlayer, Hand pHand, BlockRayTraceResult pHit, CallbackInfoReturnable<ActionResultType> cir) {
        if (CurtainRules.betterSignInteraction && this.self instanceof WallSignBlock) {
            Direction direction = (Direction)pState.func_177229_b((Property)WallSignBlock.field_176412_a);
            BlockPos blockPos = pPos.func_177967_a(direction, -1);
            BlockState blockState = pLevel.func_180495_p(blockPos);
            if (blockState.func_177230_c() instanceof WallSignBlock) {
                return;
            }
            BlockRayTraceResult hitResult = new BlockRayTraceResult(Vector3d.func_237489_a_((Vector3i)blockPos), direction, blockPos, false);
            blockState.func_227031_a_(pLevel, pPlayer, pHand, hitResult);
            cir.setReturnValue((Object)ActionResultType.SUCCESS);
        }
    }
}

