/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain.mixins;

import dev.dubhe.curtain.CurtainRules;
import dev.dubhe.curtain.features.logging.helper.TNTLogHelper;
import dev.dubhe.curtain.features.rules.fakes.TntEntityInterface;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TNTEntity.class})
public abstract class PrimedTntMixin
extends Entity
implements TntEntityInterface {
    private TNTLogHelper logHelper;
    private boolean mergeBool = false;
    private int mergedTNT = 1;

    @Shadow
    public abstract int func_184535_k();

    public PrimedTntMixin(EntityType<?> type, World world) {
        super(type, world);
    }

    @Inject(method={"<init>(Lnet/minecraft/world/World;DDDLnet/minecraft/entity/LivingEntity;)V"}, at={@At(value="RETURN")})
    private void modifyTNTAngle(World world, double x, double y, double z, LivingEntity entity, CallbackInfo ci) {
        if (CurtainRules.hardcodeTNTAngle != -1.0) {
            this.func_213293_j(-Math.sin(CurtainRules.hardcodeTNTAngle) * 0.02, 0.2, -Math.cos(CurtainRules.hardcodeTNTAngle) * 0.02);
        }
    }

    @Inject(method={"<init>(Lnet/minecraft/entity/EntityType;Lnet/minecraft/world/World;)V"}, at={@At(value="RETURN")})
    private void initTNTLoggerPrime(EntityType<? extends TNTEntity> type, World world, CallbackInfo ci) {
        if (!world.field_72995_K) {
            this.logHelper = new TNTLogHelper();
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void initTracker(CallbackInfo ci) {
        if (this.logHelper != null && !this.logHelper.initialized) {
            this.logHelper.onPrimed(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.func_213322_ci());
        }
    }

    @Inject(method={"<init>(Lnet/minecraft/world/World;DDDLnet/minecraft/entity/LivingEntity;)V"}, at={@At(value="RETURN")})
    private void initTNTLogger(World world, double x, double y, double z, LivingEntity entity, CallbackInfo ci) {
        if (CurtainRules.tntPrimerMomentumRemoved) {
            this.func_213293_j(0.0, 0.2f, 0.0);
        }
    }

    @Inject(method={"explode"}, at={@At(value="HEAD")})
    private void onExplode(CallbackInfo ci) {
        if (this.logHelper != null) {
            this.logHelper.onExploded(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70170_p.func_82737_E());
        }
        if (this.mergedTNT > 1) {
            for (int i = 0; i < this.mergedTNT - 1; ++i) {
                this.field_70170_p.func_217385_a((Entity)this, this.func_226277_ct_(), this.func_226278_cu_() + (double)(this.func_213302_cg() / 16.0f), this.func_226281_cx_(), 4.0f, Explosion.Mode.DESTROY);
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/item/TNTEntity;setDeltaMovement(Lnet/minecraft/util/math/vector/Vector3d;)V", ordinal=2)})
    private void tryMergeTnt(CallbackInfo ci) {
        if (CurtainRules.mergeTNT) {
            Vector3d velocity = this.func_213322_ci();
            if (!this.field_70170_p.field_72995_K && this.mergeBool && velocity.field_72450_a == 0.0 && velocity.field_72448_b == 0.0 && velocity.field_72449_c == 0.0) {
                this.mergeBool = false;
                for (Entity entity : this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ())) {
                    if (!(entity instanceof TNTEntity) || entity.field_70128_L) continue;
                    TNTEntity entityTNTPrimed = (TNTEntity)entity;
                    Vector3d tntVelocity = entityTNTPrimed.func_213322_ci();
                    if (tntVelocity.field_72450_a != 0.0 || tntVelocity.field_72448_b != 0.0 || tntVelocity.field_72449_c != 0.0 || this.func_226277_ct_() != entityTNTPrimed.func_226277_ct_() || this.func_226281_cx_() != entityTNTPrimed.func_226281_cx_() || this.func_226278_cu_() != entityTNTPrimed.func_226278_cu_() || this.func_184535_k() != entityTNTPrimed.func_184535_k()) continue;
                    this.mergedTNT += ((TntEntityInterface)entityTNTPrimed).getMergedTNT();
                    entityTNTPrimed.func_70106_y();
                }
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="FIELD", target="Lnet/minecraft/entity/item/TNTEntity;life:I")})
    private void setMergeable(CallbackInfo ci) {
        Vector3d velocity = this.func_213322_ci();
        if (!(this.field_70170_p.field_72995_K || velocity.field_72448_b == 0.0 && velocity.field_72450_a == 0.0 && velocity.field_72449_c == 0.0)) {
            this.mergeBool = true;
        }
    }

    @Override
    public int getMergedTNT() {
        return this.mergedTNT;
    }
}

