/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain.mixins;

import dev.dubhe.curtain.utils.SpawnReporter;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.WorldEntitySpawner;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WorldEntitySpawner.class})
public abstract class NaturalSpawnerMixin {
    @Redirect(method={"spawnCategoryForPosition(Lnet/minecraft/entity/EntityClassification;Lnet/minecraft/world/server/ServerWorld;Lnet/minecraft/world/chunk/IChunk;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/world/spawner/WorldEntitySpawner$IDensityCheck;Lnet/minecraft/world/spawner/WorldEntitySpawner$IOnSpawnDensityAdder;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/server/ServerWorld;addFreshEntityWithPassengers(Lnet/minecraft/entity/Entity;)V"))
    private static void spawnEntity(ServerWorld world, Entity entity_1, EntityClassification group, ServerWorld world2, IChunk chunk, BlockPos pos, WorldEntitySpawner.IDensityCheck checker, WorldEntitySpawner.IOnSpawnDensityAdder runner) {
        if (SpawnReporter.track_spawns > 0L && SpawnReporter.local_spawns != null) {
            SpawnReporter.registerSpawn((MobEntity)entity_1, group, entity_1.func_233580_cy_());
        }
        if (!SpawnReporter.mock_spawns) {
            world.func_242417_l(entity_1);
        }
    }

    @Redirect(method={"spawnCategoryForPosition(Lnet/minecraft/entity/EntityClassification;Lnet/minecraft/world/server/ServerWorld;Lnet/minecraft/world/chunk/IChunk;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/world/spawner/WorldEntitySpawner$IDensityCheck;Lnet/minecraft/world/spawner/WorldEntitySpawner$IOnSpawnDensityAdder;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/MobEntity;finalizeSpawn(Lnet/minecraft/world/IServerWorld;Lnet/minecraft/world/DifficultyInstance;Lnet/minecraft/entity/SpawnReason;Lnet/minecraft/entity/ILivingEntityData;Lnet/minecraft/nbt/CompoundNBT;)Lnet/minecraft/entity/ILivingEntityData;"))
    private static ILivingEntityData spawnEntity(MobEntity mobEntity, IServerWorld serverWorldAccess, DifficultyInstance difficulty, SpawnReason spawnReason, ILivingEntityData entityData, CompoundNBT entityTag) {
        if (!SpawnReporter.mock_spawns) {
            return mobEntity.func_213386_a(serverWorldAccess, difficulty, spawnReason, entityData, entityTag);
        }
        return null;
    }

    @Redirect(method={"spawnForChunk"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/spawner/WorldEntitySpawner;spawnCategoryForChunk(Lnet/minecraft/entity/EntityClassification;Lnet/minecraft/world/server/ServerWorld;Lnet/minecraft/world/chunk/Chunk;Lnet/minecraft/world/spawner/WorldEntitySpawner$IDensityCheck;Lnet/minecraft/world/spawner/WorldEntitySpawner$IOnSpawnDensityAdder;)V"))
    private static void spawnMultipleTimes(EntityClassification category, ServerWorld world, Chunk chunk, WorldEntitySpawner.IDensityCheck checker, WorldEntitySpawner.IOnSpawnDensityAdder runner) {
        for (int i = 0; i < SpawnReporter.spawn_tries.get(category); ++i) {
            WorldEntitySpawner.func_234967_a_((EntityClassification)category, (ServerWorld)world, (Chunk)chunk, (WorldEntitySpawner.IDensityCheck)checker, (WorldEntitySpawner.IOnSpawnDensityAdder)runner);
        }
    }

    @Inject(method={"spawnForChunk"}, at={@At(value="HEAD")})
    private static void checkSpawns(ServerWorld world, Chunk chunk, WorldEntitySpawner.EntityDensityManager info, boolean spawnAnimals, boolean spawnMonsters, boolean shouldSpawnAnimals, CallbackInfo ci) {
        if (SpawnReporter.track_spawns > 0L) {
            for (EntityClassification entityCategory : WorldEntitySpawner.field_234961_c_) {
                if (!spawnAnimals && entityCategory.func_75599_d() || !spawnMonsters && !entityCategory.func_75599_d() || !shouldSpawnAnimals && entityCategory.func_82705_e()) continue;
                RegistryKey dim = world.func_234923_W_();
                int newCap = entityCategory.func_75601_b();
                int int_2 = SpawnReporter.chunkCounts.get(dim);
                int int_3 = newCap * int_2 / SpawnReporter.MAGIC_NUMBER;
                int mobCount = info.func_234995_b_().getInt((Object)entityCategory);
                if (SpawnReporter.track_spawns > 0L && !SpawnReporter.first_chunk_marker.contains(entityCategory)) {
                    SpawnReporter.first_chunk_marker.add(entityCategory);
                    Pair key = Pair.of((Object)dim, (Object)entityCategory);
                    int spawnTries = SpawnReporter.spawn_tries.get(entityCategory);
                    SpawnReporter.spawn_attempts.put((Pair<RegistryKey<World>, EntityClassification>)key, SpawnReporter.spawn_attempts.get(key) + (long)spawnTries);
                    SpawnReporter.spawn_cap_count.put((Pair<RegistryKey<World>, EntityClassification>)key, SpawnReporter.spawn_cap_count.get(key) + (long)mobCount);
                }
                if (mobCount > int_3 && !SpawnReporter.mock_spawns) continue;
                SpawnReporter.local_spawns.putIfAbsent(entityCategory, 0L);
            }
        }
    }
}

