/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain.features.player.menu;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import dev.dubhe.curtain.api.menu.CustomMenu;
import dev.dubhe.curtain.api.menu.control.AutoResetButton;
import dev.dubhe.curtain.api.menu.control.Button;
import dev.dubhe.curtain.api.menu.control.RadioList;
import dev.dubhe.curtain.features.player.fakes.IServerPlayer;
import dev.dubhe.curtain.features.player.helpers.EntityPlayerActionPack;
import dev.dubhe.curtain.utils.TranslationHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;

public class FakePlayerInventoryMenu
extends CustomMenu {
    public final NonNullList<ItemStack> items;
    public final NonNullList<ItemStack> armor;
    public final NonNullList<ItemStack> offhand;
    private final NonNullList<ItemStack> buttons = NonNullList.func_191197_a((int)13, (Object)ItemStack.field_190927_a);
    private final List<NonNullList<ItemStack>> compartments;
    private final PlayerEntity player;
    private final EntityPlayerActionPack ap;

    public FakePlayerInventoryMenu(PlayerEntity player) {
        this.player = player;
        this.items = this.player.field_71071_by.field_70462_a;
        this.armor = this.player.field_71071_by.field_70460_b;
        this.offhand = this.player.field_71071_by.field_184439_c;
        this.ap = ((IServerPlayer)this.player).getActionPack();
        this.compartments = ImmutableList.of(this.items, this.armor, this.offhand, this.buttons);
        this.createButton();
        this.ap.setSlot(1);
    }

    public int func_70302_i_() {
        return this.items.size() + this.armor.size() + this.offhand.size() + this.buttons.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemStack : this.items) {
            if (itemStack.func_190926_b()) continue;
            return false;
        }
        for (ItemStack itemStack : this.armor) {
            if (itemStack.func_190926_b()) continue;
            return false;
        }
        for (ItemStack itemStack : this.offhand) {
            if (itemStack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int slot) {
        Pair<NonNullList<ItemStack>, Integer> pair = this.getItemSlot(slot);
        if (pair != null) {
            return (ItemStack)((NonNullList)pair.getFirst()).get(((Integer)pair.getSecond()).intValue());
        }
        return ItemStack.field_190927_a;
    }

    public Pair<NonNullList<ItemStack>, Integer> getItemSlot(int slot) {
        switch (slot) {
            case 0: {
                return new Pair(this.buttons, (Object)0);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return new Pair(this.armor, (Object)(4 - slot));
            }
            case 5: 
            case 6: {
                return new Pair(this.buttons, (Object)(slot - 4));
            }
            case 7: {
                return new Pair(this.offhand, (Object)0);
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                return new Pair(this.buttons, (Object)(slot - 5));
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                return new Pair(this.items, (Object)(slot - 9));
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                return new Pair(this.items, (Object)(slot - 45));
            }
        }
        return null;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        Pair<NonNullList<ItemStack>, Integer> pair = this.getItemSlot(slot);
        NonNullList list = null;
        if (pair != null) {
            list = (NonNullList)pair.getFirst();
            slot = (Integer)pair.getSecond();
        }
        if (list != null && !((ItemStack)list.get(slot)).func_190926_b()) {
            return ItemStackHelper.func_188382_a((List)list, (int)slot, (int)amount);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int slot) {
        Pair<NonNullList<ItemStack>, Integer> pair = this.getItemSlot(slot);
        NonNullList list = null;
        if (pair != null) {
            list = (NonNullList)pair.getFirst();
            slot = (Integer)pair.getSecond();
        }
        if (list != null && !((ItemStack)list.get(slot)).func_190926_b()) {
            ItemStack itemStack = (ItemStack)list.get(slot);
            list.set(slot, (Object)ItemStack.field_190927_a);
            return itemStack;
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        Pair<NonNullList<ItemStack>, Integer> pair = this.getItemSlot(slot);
        NonNullList list = null;
        if (pair != null) {
            list = (NonNullList)pair.getFirst();
            slot = (Integer)pair.getSecond();
        }
        if (list != null) {
            list.set(slot, (Object)stack);
        }
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(PlayerEntity player) {
        return player.func_70089_S() && !(player.func_70068_e((Entity)player) > 64.0);
    }

    public void func_174888_l() {
        for (List list : this.compartments) {
            list.clear();
        }
    }

    private void createButton() {
        ArrayList<Button> hotBarList = new ArrayList<Button>();
        for (int i = 0; i < 9; ++i) {
            IFormattableTextComponent hotBarComponent = TranslationHelper.translate("gac.hotbar", TextFormatting.WHITE, Style.field_240709_b_.func_240713_a_(Boolean.valueOf(true)).func_240722_b_(Boolean.valueOf(false)), new Object[]{i + 1});
            boolean defaultState = i == 0;
            Button button = new Button(defaultState, i + 1, hotBarComponent, hotBarComponent);
            int finalI = i + 1;
            button.addTurnOnFunction(() -> this.ap.setSlot(finalI));
            this.addButton(i + 9, button);
            hotBarList.add(button);
        }
        this.addButtonList(new RadioList(hotBarList, true));
        AutoResetButton stopAll = new AutoResetButton("action.stop_all");
        Button attackInterval14 = new Button(false, "action.attack.interval.14");
        Button attackContinuous = new Button(false, "action.attack.continuous");
        Button useContinuous = new Button(false, "action.use.continuous");
        stopAll.addTurnOnFunction(() -> {
            attackInterval14.turnOffWithoutFunction();
            attackContinuous.turnOffWithoutFunction();
            useContinuous.turnOffWithoutFunction();
            this.ap.stopAll();
        });
        attackInterval14.addTurnOnFunction(() -> {
            this.ap.start(EntityPlayerActionPack.ActionType.ATTACK, EntityPlayerActionPack.Action.interval(14));
            attackContinuous.turnOffWithoutFunction();
        });
        attackInterval14.addTurnOffFunction(() -> this.ap.start(EntityPlayerActionPack.ActionType.ATTACK, EntityPlayerActionPack.Action.once()));
        attackContinuous.addTurnOnFunction(() -> {
            this.ap.start(EntityPlayerActionPack.ActionType.ATTACK, EntityPlayerActionPack.Action.continuous());
            attackInterval14.turnOffWithoutFunction();
        });
        attackContinuous.addTurnOffFunction(() -> this.ap.start(EntityPlayerActionPack.ActionType.ATTACK, EntityPlayerActionPack.Action.once()));
        useContinuous.addTurnOnFunction(() -> this.ap.start(EntityPlayerActionPack.ActionType.USE, EntityPlayerActionPack.Action.continuous()));
        useContinuous.addTurnOffFunction(() -> this.ap.start(EntityPlayerActionPack.ActionType.USE, EntityPlayerActionPack.Action.once()));
        this.addButton(0, stopAll);
        this.addButton(5, attackInterval14);
        this.addButton(6, attackContinuous);
        this.addButton(8, useContinuous);
    }
}

