/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain.features.player.helpers;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.dubhe.curtain.CurtainRules;
import dev.dubhe.curtain.features.player.menu.MenuHashMap;
import dev.dubhe.curtain.features.player.patches.EntityPlayerMPFake;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.storage.FolderName;

public class FakePlayerResident {
    public static void onServerStop(MinecraftServer server) {
        if (CurtainRules.fakePlayerResident) {
            JsonObject fakePlayerList = new JsonObject();
            MenuHashMap.FAKE_PLAYER_INVENTORY_MENU_MAP.forEach((player, fakePlayerInventoryContainer) -> {
                if (!(player instanceof EntityPlayerMPFake)) {
                    return;
                }
                String username = player.func_200200_C_().getString();
                fakePlayerList.add(username, (JsonElement)FakePlayerResident.save(player));
            });
            File file = server.func_240776_a_(FolderName.field_237253_i_).resolve("fake_player.gca.json").toFile();
            if (!file.isFile()) {
                try {
                    file.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try (BufferedWriter bfw = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                bfw.write(new Gson().toJson((JsonElement)fakePlayerList));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        MenuHashMap.FAKE_PLAYER_INVENTORY_MENU_MAP.clear();
    }

    public static void onServerStart(MinecraftServer server) {
        if (CurtainRules.fakePlayerResident) {
            JsonObject fakePlayerList = new JsonObject();
            File file = server.func_240776_a_(FolderName.field_237253_i_).resolve("fake_player.gca.json").toFile();
            if (!file.isFile()) {
                return;
            }
            try (BufferedReader bfr = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);){
                fakePlayerList = (JsonObject)new Gson().fromJson((Reader)bfr, JsonObject.class);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            for (Map.Entry entry : fakePlayerList.entrySet()) {
                FakePlayerResident.load(entry, server);
            }
            file.delete();
        }
    }

    public static JsonObject save(PlayerEntity player) {
        double pos_x = player.func_226277_ct_();
        double pos_y = player.func_226278_cu_();
        double pos_z = player.func_226281_cx_();
        double yaw = player.field_70177_z;
        double pitch = player.field_70125_A;
        String dimension = player.field_70170_p.func_234923_W_().func_240901_a_().func_110623_a();
        String gamemode = ((ServerPlayerEntity)player).field_71134_c.func_73081_b().func_77149_b();
        boolean flying = player.field_71075_bZ.field_75100_b;
        JsonObject fakePlayer = new JsonObject();
        fakePlayer.addProperty("pos_x", (Number)pos_x);
        fakePlayer.addProperty("pos_y", (Number)pos_y);
        fakePlayer.addProperty("pos_z", (Number)pos_z);
        fakePlayer.addProperty("yaw", (Number)yaw);
        fakePlayer.addProperty("pitch", (Number)pitch);
        fakePlayer.addProperty("dimension", dimension);
        fakePlayer.addProperty("gamemode", gamemode);
        fakePlayer.addProperty("flying", Boolean.valueOf(flying));
        return fakePlayer;
    }

    public static void load(Map.Entry<String, JsonElement> entry, MinecraftServer server) {
        String username = entry.getKey();
        JsonObject fakePlayer = entry.getValue().getAsJsonObject();
        double pos_x = fakePlayer.get("pos_x").getAsDouble();
        double pos_y = fakePlayer.get("pos_y").getAsDouble();
        double pos_z = fakePlayer.get("pos_z").getAsDouble();
        double yaw = fakePlayer.get("yaw").getAsDouble();
        double pitch = fakePlayer.get("pitch").getAsDouble();
        String dimension = fakePlayer.get("dimension").getAsString();
        String gamemode = fakePlayer.get("gamemode").getAsString();
        boolean flying = fakePlayer.get("flying").getAsBoolean();
        EntityPlayerMPFake.createFake(username, server, pos_x, pos_y, pos_z, yaw, pitch, (RegistryKey<World>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(dimension)), GameType.func_77142_a((String)gamemode), flying);
    }
}

