/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain.features.player.helpers;

import dev.dubhe.curtain.features.player.fakes.IServerPlayer;
import dev.dubhe.curtain.utils.Tracer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.block.BlockState;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.item.minecart.MinecartEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CPlayerDiggingPacket;
import net.minecraft.network.play.server.SHeldItemChangePacket;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EntityPlayerActionPack {
    private final ServerPlayerEntity player;
    private final Map<ActionType, Action> actions = new TreeMap<ActionType, Action>();
    private BlockPos currentBlock;
    private int blockHitDelay;
    private boolean isHittingBlock;
    private float curBlockDamageMP;
    private boolean sneaking;
    private boolean sprinting;
    private float forward;
    private float strafing;
    private int itemUseCooldown;

    public EntityPlayerActionPack(ServerPlayerEntity playerIn) {
        this.player = playerIn;
        this.stopAll();
    }

    public void copyFrom(EntityPlayerActionPack other) {
        this.actions.putAll(other.actions);
        this.currentBlock = other.currentBlock;
        this.blockHitDelay = other.blockHitDelay;
        this.isHittingBlock = other.isHittingBlock;
        this.curBlockDamageMP = other.curBlockDamageMP;
        this.sneaking = other.sneaking;
        this.sprinting = other.sprinting;
        this.forward = other.forward;
        this.strafing = other.strafing;
        this.itemUseCooldown = other.itemUseCooldown;
    }

    public EntityPlayerActionPack start(ActionType type, Action action) {
        Action previous = this.actions.remove((Object)type);
        if (previous != null) {
            type.stop(this.player, previous);
        }
        if (action != null) {
            this.actions.put(type, action);
            type.start(this.player, action);
        }
        return this;
    }

    public EntityPlayerActionPack setSneaking(boolean doSneak) {
        this.sneaking = doSneak;
        this.player.func_226284_e_(doSneak);
        if (this.sprinting && this.sneaking) {
            this.setSprinting(false);
        }
        return this;
    }

    public EntityPlayerActionPack setSprinting(boolean doSprint) {
        this.sprinting = doSprint;
        this.player.func_70031_b(doSprint);
        if (this.sneaking && this.sprinting) {
            this.setSneaking(false);
        }
        return this;
    }

    public EntityPlayerActionPack setForward(float value) {
        this.forward = value;
        return this;
    }

    public EntityPlayerActionPack setStrafing(float value) {
        this.strafing = value;
        return this;
    }

    public EntityPlayerActionPack look(Direction direction) {
        switch (direction) {
            case NORTH: {
                return this.look(180.0f, 0.0f);
            }
            case SOUTH: {
                return this.look(0.0f, 0.0f);
            }
            case EAST: {
                return this.look(-90.0f, 0.0f);
            }
            case WEST: {
                return this.look(90.0f, 0.0f);
            }
            case UP: {
                return this.look(this.player.func_195046_g(1.0f), -90.0f);
            }
            case DOWN: {
                return this.look(this.player.func_195046_g(1.0f), 90.0f);
            }
        }
        return this;
    }

    public EntityPlayerActionPack look(Vector2f rotation) {
        return this.look(rotation.field_189982_i, rotation.field_189983_j);
    }

    public EntityPlayerActionPack look(float yaw, float pitch) {
        this.player.func_70080_a(this.player.func_226277_ct_(), this.player.func_226278_cu_(), this.player.func_226281_cx_(), yaw % 360.0f, MathHelper.func_76131_a((float)pitch, (float)-90.0f, (float)90.0f));
        return this;
    }

    public EntityPlayerActionPack lookAt(Vector3d position) {
        this.player.func_200602_a(EntityAnchorArgument.Type.EYES, position);
        return this;
    }

    public EntityPlayerActionPack turn(float yaw, float pitch) {
        return this.look(this.player.func_195046_g(1.0f) + yaw, this.player.func_195050_f(1.0f) + pitch);
    }

    public EntityPlayerActionPack turn(Vector2f rotation) {
        return this.turn(rotation.field_189982_i, rotation.field_189983_j);
    }

    public EntityPlayerActionPack stopMovement() {
        this.setSneaking(false);
        this.setSprinting(false);
        this.forward = 0.0f;
        this.strafing = 0.0f;
        return this;
    }

    public EntityPlayerActionPack stopAll() {
        for (ActionType type : this.actions.keySet()) {
            type.stop(this.player, this.actions.get((Object)type));
        }
        this.actions.clear();
        return this.stopMovement();
    }

    public EntityPlayerActionPack mount(boolean onlyRideables) {
        List entities = onlyRideables ? this.player.field_70170_p.func_175674_a((Entity)this.player, this.player.func_174813_aQ().func_72321_a(3.0, 1.0, 3.0), e -> e instanceof MinecartEntity || e instanceof BoatEntity || e instanceof HorseEntity) : this.player.field_70170_p.func_175674_a((Entity)this.player, this.player.func_174813_aQ().func_72321_a(3.0, 1.0, 3.0), EntityPredicates.field_180132_d);
        if (entities.size() == 0) {
            return this;
        }
        Entity closest = null;
        double distance = Double.POSITIVE_INFINITY;
        Entity currentVehicle = this.player.func_184187_bx();
        for (Entity e2 : entities) {
            double dd;
            if (e2 == this.player || currentVehicle == e2 || !((dd = this.player.func_70068_e(e2)) < distance)) continue;
            distance = dd;
            closest = e2;
        }
        if (closest == null) {
            return this;
        }
        if (closest instanceof AbstractHorseEntity && onlyRideables) {
            ((AbstractHorseEntity)closest).func_230254_b_((PlayerEntity)this.player, Hand.MAIN_HAND);
        } else {
            this.player.func_184205_a(closest, true);
        }
        return this;
    }

    public EntityPlayerActionPack dismount() {
        this.player.func_184210_p();
        return this;
    }

    public void onUpdate() {
        HashMap<ActionType, Boolean> actionAttempts = new HashMap<ActionType, Boolean>();
        this.actions.entrySet().removeIf(e -> ((Action)e.getValue()).done);
        for (Map.Entry<ActionType, Action> e2 : this.actions.entrySet()) {
            Action using;
            Boolean actionStatus;
            Action action = e2.getValue();
            if (!(actionAttempts.getOrDefault((Object)ActionType.USE, false).booleanValue() && e2.getKey() == ActionType.ATTACK || (actionStatus = action.tick(this, e2.getKey())) == null)) {
                actionAttempts.put(e2.getKey(), actionStatus);
            }
            if (e2.getKey() != ActionType.ATTACK || !actionAttempts.getOrDefault((Object)ActionType.ATTACK, false).booleanValue() || actionAttempts.getOrDefault((Object)ActionType.USE, true).booleanValue() || (using = this.actions.get((Object)ActionType.USE)) == null) continue;
            using.retry(this, ActionType.USE);
        }
        if (this.forward != 0.0f) {
            this.player.field_191988_bg = this.forward * (this.sneaking ? 0.3f : 1.0f);
        }
        if (this.strafing != 0.0f) {
            this.player.field_70702_br = this.strafing * (this.sneaking ? 0.3f : 1.0f);
        }
    }

    static RayTraceResult getTarget(ServerPlayerEntity player) {
        double reach = player.field_71134_c.func_73083_d() ? 5.0 : 4.5;
        return Tracer.rayTrace((Entity)player, 1.0f, reach, false);
    }

    private void dropItemFromSlot(int slot, boolean dropAll) {
        PlayerInventory inv = this.player.field_71071_by;
        if (!inv.func_70301_a(slot).func_190926_b()) {
            this.player.func_146097_a(inv.func_70298_a(slot, dropAll ? inv.func_70301_a(slot).func_190916_E() : 1), false, true);
        }
    }

    public void drop(int selectedSlot, boolean dropAll) {
        PlayerInventory inv = this.player.field_71071_by;
        if (selectedSlot == -2) {
            for (int i = inv.func_70302_i_(); i >= 0; --i) {
                this.dropItemFromSlot(i, dropAll);
            }
        } else {
            if (selectedSlot == -1) {
                selectedSlot = inv.field_70461_c;
            }
            this.dropItemFromSlot(selectedSlot, dropAll);
        }
    }

    public void setSlot(int slot) {
        this.player.field_71071_by.field_70461_c = slot - 1;
        this.player.field_71135_a.func_147359_a((IPacket)new SHeldItemChangePacket(slot - 1));
    }

    public static class Action {
        public boolean done = false;
        public final int limit;
        public final int interval;
        public final int offset;
        private int count;
        private int next;
        private final boolean isContinuous;

        private Action(int limit, int interval, int offset, boolean continuous) {
            this.limit = limit;
            this.interval = interval;
            this.offset = offset;
            this.next = interval + offset;
            this.isContinuous = continuous;
        }

        public static Action once() {
            return new Action(1, 1, 0, false);
        }

        public static Action continuous() {
            return new Action(-1, 1, 0, true);
        }

        public static Action interval(int interval) {
            return new Action(-1, interval, 0, false);
        }

        public static Action interval(int interval, int offset) {
            return new Action(-1, interval, offset, false);
        }

        Boolean tick(EntityPlayerActionPack actionPack, ActionType type) {
            --this.next;
            Boolean cancel = null;
            if (this.next <= 0) {
                if (!(this.interval != 1 || this.isContinuous || type.preventSpectator && actionPack.player.func_175149_v())) {
                    type.inactiveTick(actionPack.player, this);
                }
                if (!type.preventSpectator || !actionPack.player.func_175149_v()) {
                    cancel = type.execute(actionPack.player, this);
                }
                ++this.count;
                if (this.count == this.limit) {
                    type.stop(actionPack.player, null);
                    this.done = true;
                    return cancel;
                }
                this.next = this.interval;
            } else if (!type.preventSpectator || !actionPack.player.func_175149_v()) {
                type.inactiveTick(actionPack.player, this);
            }
            return cancel;
        }

        void retry(EntityPlayerActionPack actionPack, ActionType type) {
            if (!type.preventSpectator || !actionPack.player.func_175149_v()) {
                type.execute(actionPack.player, this);
            }
            ++this.count;
            if (this.count == this.limit) {
                type.stop(actionPack.player, null);
                this.done = true;
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ActionType {
        USE(true){

            @Override
            boolean execute(ServerPlayerEntity player, Action action) {
                EntityPlayerActionPack ap = ((IServerPlayer)player).getActionPack();
                if (ap.itemUseCooldown > 0) {
                    --ap.itemUseCooldown;
                    return true;
                }
                if (player.func_184587_cr()) {
                    return true;
                }
                RayTraceResult hit = EntityPlayerActionPack.getTarget(player);
                for (Hand hand : Hand.values()) {
                    switch (hit.func_216346_c()) {
                        case BLOCK: {
                            ActionResultType result;
                            player.func_143004_u();
                            ServerWorld world = player.func_71121_q();
                            BlockRayTraceResult blockHit = (BlockRayTraceResult)hit;
                            BlockPos pos = blockHit.func_216350_a();
                            Direction side = blockHit.func_216354_b();
                            if (pos.func_177956_o() >= player.field_71133_b.func_71207_Z() - (side == Direction.UP ? 1 : 0) || !world.func_175660_a((PlayerEntity)player, pos) || !(result = player.field_71134_c.func_219441_a(player, (World)world, player.func_184586_b(hand), hand, blockHit)).func_226246_a_()) break;
                            if (result.func_226247_b_()) {
                                player.func_184609_a(hand);
                            }
                            ap.itemUseCooldown = 3;
                            return true;
                        }
                        case ENTITY: {
                            player.func_143004_u();
                            EntityRayTraceResult entityHit = (EntityRayTraceResult)hit;
                            Entity entity = entityHit.func_216348_a();
                            boolean handWasEmpty = player.func_184586_b(hand).func_190926_b();
                            boolean itemFrameEmpty = entity instanceof ItemFrameEntity && ((ItemFrameEntity)entity).func_82335_i().func_190926_b();
                            Vector3d relativeHitPos = entityHit.func_216347_e().func_178786_a(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
                            if (entity.func_184199_a((PlayerEntity)player, relativeHitPos, hand).func_226246_a_()) {
                                ap.itemUseCooldown = 3;
                                return true;
                            }
                            if (!player.func_190775_a(entity, hand).func_226246_a_() || handWasEmpty && itemFrameEmpty) break;
                            ap.itemUseCooldown = 3;
                            return true;
                        }
                    }
                    ItemStack handItem = player.func_184586_b(hand);
                    if (!player.field_71134_c.func_187250_a(player, (World)player.func_71121_q(), handItem, hand).func_226246_a_()) continue;
                    ap.itemUseCooldown = 3;
                    return true;
                }
                return false;
            }

            @Override
            void inactiveTick(ServerPlayerEntity player, Action action) {
                EntityPlayerActionPack ap = ((IServerPlayer)player).getActionPack();
                ap.itemUseCooldown = 0;
                player.func_184597_cx();
            }
        }
        ,
        ATTACK(true){

            @Override
            boolean execute(ServerPlayerEntity player, Action action) {
                RayTraceResult hit = EntityPlayerActionPack.getTarget(player);
                switch (hit.func_216346_c()) {
                    case ENTITY: {
                        EntityRayTraceResult entityHit = (EntityRayTraceResult)hit;
                        if (!action.isContinuous) {
                            player.func_71059_n(entityHit.func_216348_a());
                            player.func_184609_a(Hand.MAIN_HAND);
                        }
                        player.func_184821_cY();
                        player.func_143004_u();
                        return true;
                    }
                    case BLOCK: {
                        EntityPlayerActionPack ap = ((IServerPlayer)player).getActionPack();
                        if (ap.blockHitDelay > 0) {
                            --ap.blockHitDelay;
                            return false;
                        }
                        BlockRayTraceResult blockHit = (BlockRayTraceResult)hit;
                        BlockPos pos = blockHit.func_216350_a();
                        Direction side = blockHit.func_216354_b();
                        if (player.func_223729_a(player.field_70170_p, pos, player.field_71134_c.func_73081_b())) {
                            return false;
                        }
                        if (ap.currentBlock != null && player.field_70170_p.func_180495_p(ap.currentBlock).func_196958_f()) {
                            ap.currentBlock = null;
                            return false;
                        }
                        BlockState state = player.field_70170_p.func_180495_p(pos);
                        boolean blockBroken = false;
                        if (player.field_71134_c.func_73081_b().func_77145_d()) {
                            player.field_71134_c.func_225416_a(pos, CPlayerDiggingPacket.Action.START_DESTROY_BLOCK, side, player.field_71133_b.func_71207_Z());
                            ap.blockHitDelay = 5;
                            blockBroken = true;
                        } else if (ap.currentBlock == null || !ap.currentBlock.equals((Object)pos)) {
                            boolean notAir;
                            if (ap.currentBlock != null) {
                                player.field_71134_c.func_225416_a(ap.currentBlock, CPlayerDiggingPacket.Action.ABORT_DESTROY_BLOCK, side, player.field_71133_b.func_71207_Z());
                            }
                            player.field_71134_c.func_225416_a(pos, CPlayerDiggingPacket.Action.START_DESTROY_BLOCK, side, player.field_71133_b.func_71207_Z());
                            boolean bl = notAir = !state.func_196958_f();
                            if (notAir && ap.curBlockDamageMP == 0.0f) {
                                state.func_196942_a(player.field_70170_p, pos, (PlayerEntity)player);
                            }
                            if (notAir && state.func_185903_a((PlayerEntity)player, (IBlockReader)player.field_70170_p, pos) >= 1.0f) {
                                ap.currentBlock = null;
                                blockBroken = true;
                            } else {
                                ap.currentBlock = pos;
                                ap.curBlockDamageMP = 0.0f;
                            }
                        } else {
                            ap.curBlockDamageMP += state.func_185903_a((PlayerEntity)player, (IBlockReader)player.field_70170_p, pos);
                            if (ap.curBlockDamageMP >= 1.0f) {
                                player.field_71134_c.func_225416_a(pos, CPlayerDiggingPacket.Action.STOP_DESTROY_BLOCK, side, player.field_71133_b.func_71207_Z());
                                ap.currentBlock = null;
                                ap.blockHitDelay = 5;
                                blockBroken = true;
                            }
                            player.field_70170_p.func_175715_c(-1, pos, (int)(ap.curBlockDamageMP * 10.0f));
                        }
                        player.func_143004_u();
                        player.func_184609_a(Hand.MAIN_HAND);
                        return blockBroken;
                    }
                }
                return false;
            }

            @Override
            void inactiveTick(ServerPlayerEntity player, Action action) {
                EntityPlayerActionPack ap = ((IServerPlayer)player).getActionPack();
                if (ap.currentBlock == null) {
                    return;
                }
                player.field_70170_p.func_175715_c(-1, ap.currentBlock, -1);
                player.field_71134_c.func_225416_a(ap.currentBlock, CPlayerDiggingPacket.Action.ABORT_DESTROY_BLOCK, Direction.DOWN, player.field_71133_b.func_71207_Z());
                ap.currentBlock = null;
            }
        }
        ,
        JUMP(true){

            @Override
            boolean execute(ServerPlayerEntity player, Action action) {
                if (action.limit == 1) {
                    if (player.func_233570_aj_()) {
                        player.func_70664_aZ();
                    }
                } else {
                    player.func_70637_d(true);
                }
                return false;
            }

            @Override
            void inactiveTick(ServerPlayerEntity player, Action action) {
                player.func_70637_d(false);
            }
        }
        ,
        DROP_ITEM(true){

            @Override
            boolean execute(ServerPlayerEntity player, Action action) {
                player.func_143004_u();
                player.func_225609_n_(false);
                return false;
            }
        }
        ,
        DROP_STACK(true){

            @Override
            boolean execute(ServerPlayerEntity player, Action action) {
                player.func_143004_u();
                player.func_225609_n_(true);
                return false;
            }
        }
        ,
        SWAP_HANDS(true){

            @Override
            boolean execute(ServerPlayerEntity player, Action action) {
                player.func_143004_u();
                ItemStack itemStack_1 = player.func_184586_b(Hand.OFF_HAND);
                player.func_184611_a(Hand.OFF_HAND, player.func_184586_b(Hand.MAIN_HAND));
                player.func_184611_a(Hand.MAIN_HAND, itemStack_1);
                return false;
            }
        };

        public final boolean preventSpectator;

        private ActionType(boolean preventSpectator) {
            this.preventSpectator = preventSpectator;
        }

        void start(ServerPlayerEntity player, Action action) {
        }

        abstract boolean execute(ServerPlayerEntity var1, Action var2);

        void inactiveTick(ServerPlayerEntity player, Action action) {
        }

        void stop(ServerPlayerEntity player, Action action) {
            this.inactiveTick(player, action);
        }
    }
}

