/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain.features.logging.helper;

import dev.dubhe.curtain.features.logging.AbstractLogger;
import dev.dubhe.curtain.features.logging.LoggerManager;
import dev.dubhe.curtain.utils.Messenger;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.world.Explosion;
import net.minecraftforge.registries.ForgeRegistries;

public class ExplosionLogHelper {
    private final boolean createFire;
    private final Explosion.Mode blockDestructionType;
    private final DynamicRegistries regs;
    public final Vector3d pos;
    private final float power;
    private boolean affectBlocks = false;
    private final Object2IntMap<EntityChangedStatusWithCount> impactedEntities = new Object2IntOpenHashMap();
    private static long lastGametime = 0L;
    private static int explosionCountInCurrentGT = 0;
    private static boolean newTick;
    private static ITextComponent log;

    public ExplosionLogHelper(double x, double y, double z, float power, boolean createFire, Explosion.Mode blockDestructionType, DynamicRegistries regs) {
        this.power = power;
        this.pos = new Vector3d(x, y, z);
        this.createFire = createFire;
        this.blockDestructionType = blockDestructionType;
        this.regs = regs;
    }

    public void setAffectBlocks(boolean b) {
        this.affectBlocks = b;
    }

    public void onExplosionDone(long gametime) {
        newTick = false;
        if (lastGametime != gametime) {
            explosionCountInCurrentGT = 0;
            lastGametime = gametime;
            newTick = true;
        }
        ++explosionCountInCurrentGT;
        ArrayList<TextComponent> messages = new ArrayList<TextComponent>();
        if (newTick) {
            messages.add(Messenger.c("wb tick : ", "d " + gametime));
        }
        messages.add(Messenger.c("d #" + explosionCountInCurrentGT, "gb ->", Messenger.dblt("l", this.pos.field_72450_a, this.pos.field_72448_b, this.pos.field_72449_c)));
        messages.add(Messenger.c("w   affects blocks: ", "m " + this.affectBlocks));
        messages.add(Messenger.c("w   creates fire: ", "m " + this.createFire));
        messages.add(Messenger.c("w   power: ", "c " + this.power));
        messages.add(Messenger.c("w   destruction: ", "c " + this.blockDestructionType.name()));
        if (this.impactedEntities.isEmpty()) {
            messages.add(Messenger.c("w   affected entities: ", "m None"));
        } else {
            messages.add(Messenger.c("w   affected entities:"));
            this.impactedEntities.forEach((k, v) -> messages.add(Messenger.c(k.pos.equals((Object)this.pos) ? "r   - TNT" : "w   - ", Messenger.dblt(k.pos.equals((Object)this.pos) ? "r" : "y", k.pos.field_72450_a, k.pos.field_72448_b, k.pos.field_72449_c), "w  dV", Messenger.dblt("d", k.accel.field_72450_a, k.accel.field_72448_b, k.accel.field_72449_c), "w  " + ForgeRegistries.ENTITIES.getKey(k.type).func_110623_a(), v > 1 ? "l (" + v + ")" : "")));
        }
        Iterator iterator = messages.iterator();
        StringTextComponent rt = new StringTextComponent("");
        ITextComponent component = (ITextComponent)iterator.next();
        while (iterator.hasNext()) {
            rt.func_230529_a_(component);
            if (iterator.hasNext()) {
                rt.func_230529_a_((ITextComponent)new StringTextComponent("\n"));
            }
            component = (ITextComponent)iterator.next();
        }
        log = rt;
        LoggerManager.ableSendToChat("explosion");
    }

    public void onEntityImpacted(Entity entity, Vector3d accel) {
        EntityChangedStatusWithCount ent = new EntityChangedStatusWithCount(entity, accel);
        this.impactedEntities.put((Object)ent, this.impactedEntities.getOrDefault((Object)ent, 0) + 1);
    }

    public record EntityChangedStatusWithCount(Vector3d pos, EntityType<?> type, Vector3d accel) {
        public EntityChangedStatusWithCount(Entity e, Vector3d accel) {
            this(e.func_213303_ch(), e.func_200600_R(), accel);
        }
    }

    public static class ExplosionLogger
    extends AbstractLogger {
        public ExplosionLogger() {
            super("explosion");
        }

        @Override
        public ITextComponent display(ServerPlayerEntity player) {
            return log;
        }
    }
}

