/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain.features.logging.builtin;

import dev.dubhe.curtain.Curtain;
import dev.dubhe.curtain.features.logging.AbstractHudLogger;
import java.util.Arrays;
import java.util.OptionalDouble;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class TPSLogger
extends AbstractHudLogger {
    private static final double MAX_TPS = 20.0;

    public TPSLogger() {
        super("tps");
    }

    @Override
    public ITextComponent display(ServerPlayerEntity player) {
        MinecraftServer server = Curtain.minecraftServer;
        OptionalDouble averageTPS = Arrays.stream(server.field_71311_j).average();
        if (averageTPS.isEmpty()) {
            return new StringTextComponent("No TPS data available").func_240699_a_(TextFormatting.RED);
        }
        double MSPT = Arrays.stream(server.field_71311_j).average().getAsDouble() * 1.0E-6;
        double TPS = Math.min(1000.0 / MSPT, 20.0);
        TextFormatting color = TextFormatting.GREEN;
        if (MSPT >= 0.0) {
            color = TextFormatting.DARK_GREEN;
        }
        if (MSPT >= 20.0) {
            color = TextFormatting.GREEN;
        }
        if (MSPT >= 35.0) {
            color = TextFormatting.YELLOW;
        }
        if (MSPT >= 45.0) {
            color = TextFormatting.RED;
        }
        TextFormatting finalColor = color;
        return new StringTextComponent("TPS: ").func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)new StringTextComponent("%.1f".formatted(TPS)).func_240699_a_(finalColor)).func_230529_a_((ITextComponent)new StringTextComponent(" MSPT: ").func_240699_a_(TextFormatting.GRAY)).func_230529_a_((ITextComponent)new StringTextComponent("%.1f".formatted(MSPT)).func_240699_a_(finalColor));
    }
}

