/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain.features.logging;

import dev.dubhe.curtain.Curtain;
import dev.dubhe.curtain.features.logging.AbstractLogger;
import dev.dubhe.curtain.features.logging.DisplayType;
import dev.dubhe.curtain.features.logging.builtin.MemoryLogger;
import dev.dubhe.curtain.features.logging.builtin.MobcapsLogger;
import dev.dubhe.curtain.features.logging.builtin.TPSLogger;
import dev.dubhe.curtain.features.logging.helper.ExplosionLogHelper;
import dev.dubhe.curtain.features.logging.helper.TNTLogHelper;
import dev.dubhe.curtain.mixins.SPlayerListHeaderFooterPacketMixin;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlayerListHeaderFooterPacket;
import net.minecraft.util.Util;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class LoggerManager {
    private static final Map<String, AbstractLogger> registeredLogger = new HashMap<String, AbstractLogger>();
    private static final Map<String, Set<String>> subscribedPlayer = new HashMap<String, Set<String>>();

    public static void ableSendToChat(String loggerName) {
        if (!registeredLogger.containsKey(loggerName)) {
            Curtain.LOGGER.error("Can' t find logger named: {}", (Object)loggerName);
            return;
        }
        AbstractLogger logger = registeredLogger.get(loggerName);
        if (logger.getType() != DisplayType.CHAT) {
            Curtain.LOGGER.error("Logger {} not a chat logger", (Object)loggerName);
            return;
        }
        for (Map.Entry<String, Set<String>> entry : subscribedPlayer.entrySet()) {
            ServerPlayerEntity player;
            if (!entry.getValue().contains(loggerName) || (player = Curtain.minecraftServer.func_184103_al().func_152612_a(entry.getKey())) == null) continue;
            ITextComponent msg = logger.display(player);
            player.func_241151_a_(msg, ChatType.SYSTEM, Util.field_240973_b_);
        }
    }

    public static void updateHUD() {
        for (Map.Entry<String, Set<String>> entry : subscribedPlayer.entrySet()) {
            ServerPlayerEntity player = Curtain.minecraftServer.func_184103_al().func_152612_a(entry.getKey());
            if (player == null) continue;
            StringTextComponent msg = new StringTextComponent("");
            Iterator<String> iterator = entry.getValue().iterator();
            while (iterator.hasNext()) {
                String loggerName = iterator.next();
                if (!registeredLogger.containsKey(loggerName) || registeredLogger.get(loggerName).getType() != DisplayType.HUD) continue;
                msg.func_230529_a_(registeredLogger.get(loggerName).display(player));
                if (!iterator.hasNext()) continue;
                msg.func_240702_b_("\n");
            }
            SPlayerListHeaderFooterPacket packet = new SPlayerListHeaderFooterPacket();
            ((SPlayerListHeaderFooterPacketMixin)packet).setHeader((ITextComponent)new StringTextComponent(""));
            ((SPlayerListHeaderFooterPacketMixin)packet).setFooter((ITextComponent)msg);
            player.field_71135_a.func_147359_a((IPacket)packet);
        }
    }

    public static void registerLogger(AbstractLogger logger) {
        registeredLogger.put(logger.getName(), logger);
    }

    public static void subscribeLogger(String playerName, String loggerName) {
        if (!registeredLogger.containsKey(loggerName)) {
            Curtain.LOGGER.error("Can' t find logger named: {}", (Object)loggerName);
            return;
        }
        Set<Object> loggerSet = !subscribedPlayer.containsKey(playerName) ? new HashSet() : subscribedPlayer.get(playerName);
        loggerSet.add(loggerName);
        subscribedPlayer.put(playerName, loggerSet);
        ServerPlayerEntity player = Curtain.minecraftServer.func_184103_al().func_152612_a(playerName);
        if (player != null) {
            player.func_241151_a_((ITextComponent)new StringTextComponent("%s subscribed logger %s".formatted(playerName, loggerName)).func_240699_a_(TextFormatting.GRAY), ChatType.SYSTEM, Util.field_240973_b_);
        }
    }

    public static void subscribeLogger(String playerName, String[] loggers) {
        Set<Object> loggerSet = !subscribedPlayer.containsKey(playerName) ? new HashSet() : subscribedPlayer.get(playerName);
        loggerSet.addAll(Arrays.asList(loggers));
        subscribedPlayer.put(playerName, loggerSet);
    }

    public static void unsubscribeLogger(String playerName, String loggerName) {
        if (!registeredLogger.containsKey(loggerName)) {
            Curtain.LOGGER.error("Can' t find logger named: {}", (Object)loggerName);
            return;
        }
        Set<Object> loggerSet = !subscribedPlayer.containsKey(playerName) ? new HashSet() : subscribedPlayer.get(playerName);
        loggerSet.remove(loggerName);
        subscribedPlayer.put(playerName, loggerSet);
        ServerPlayerEntity player = Curtain.minecraftServer.func_184103_al().func_152612_a(playerName);
        if (player != null) {
            player.func_241151_a_((ITextComponent)new StringTextComponent("%s unsubscribed logger %s".formatted(playerName, loggerName)).func_240699_a_(TextFormatting.GRAY), ChatType.SYSTEM, Util.field_240973_b_);
        }
    }

    public static void unsubscribeAllLogger(String playerName) {
        subscribedPlayer.remove(playerName);
    }

    public static boolean isSubscribedLogger(String playerName, String loggerName) {
        if (!registeredLogger.containsKey(loggerName)) {
            Curtain.LOGGER.error("Can' t find logger named: {}", (Object)loggerName);
            return false;
        }
        Set<Object> loggerSet = !subscribedPlayer.containsKey(playerName) ? new HashSet() : subscribedPlayer.get(playerName);
        return loggerSet.contains(loggerName);
    }

    public static boolean hasSubscribedLogger(String playerName) {
        return subscribedPlayer.containsKey(playerName);
    }

    public static void registryBuiltinLogger() {
        LoggerManager.registerLogger(new TPSLogger());
        LoggerManager.registerLogger(new MobcapsLogger());
        LoggerManager.registerLogger(new MemoryLogger());
        LoggerManager.registerLogger(new ExplosionLogHelper.ExplosionLogger());
        LoggerManager.registerLogger(new TNTLogHelper.TNTLogger());
    }

    public static Set<String> getLoggerSet() {
        return registeredLogger.keySet();
    }
}

