/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain.events.utils;

import com.mojang.brigadier.CommandDispatcher;
import dev.dubhe.curtain.Curtain;
import dev.dubhe.curtain.api.rules.RuleManager;
import dev.dubhe.curtain.commands.LogCommand;
import dev.dubhe.curtain.commands.PlayerCommand;
import dev.dubhe.curtain.commands.RuleCommand;
import dev.dubhe.curtain.events.WorldTickEvent;
import dev.dubhe.curtain.utils.PlanExecution;
import net.minecraft.command.CommandSource;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;

public class ServerLifecycleEventHandler {
    @SubscribeEvent
    public void onServerAboutToStart(FMLServerAboutToStartEvent event) {
        Curtain.rules = new RuleManager(event.getServer(), "curtain");
        Curtain.minecraftServer = event.getServer();
        Curtain.planExecution = new PlanExecution();
        RuleCommand.register((CommandDispatcher<CommandSource>)event.getServer().func_195571_aL().func_197054_a(), Curtain.rules);
        PlayerCommand.register((CommandDispatcher<CommandSource>)event.getServer().func_195571_aL().func_197054_a());
        LogCommand.register((CommandDispatcher<CommandSource>)event.getServer().func_195571_aL().func_197054_a());
    }

    @SubscribeEvent
    public void onServerTick(WorldTickEvent event) {
        IWorld iWorld = event.getWorld();
        if (iWorld instanceof ServerWorld) {
            ServerWorld level = (ServerWorld)iWorld;
            long time = level.func_82737_E();
            if (Curtain.planExecution != null) {
                Curtain.planExecution.execute(time);
            }
        }
    }

    @SubscribeEvent
    public void onServerStopped(FMLServerStoppedEvent event) {
        Curtain.rules.saveToFile();
    }
}

