/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain.events.rules;

import dev.dubhe.curtain.CurtainRules;
import dev.dubhe.curtain.events.events.ItemStackEvent;
import dev.dubhe.curtain.features.player.helpers.FakePlayerAutoReplaceTool;
import dev.dubhe.curtain.features.player.helpers.FakePlayerAutoReplenishment;
import dev.dubhe.curtain.features.player.menu.FakePlayerInventoryMenu;
import dev.dubhe.curtain.features.player.menu.MenuHashMap;
import dev.dubhe.curtain.features.player.patches.EntityPlayerMPFake;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PlayerEventHandler {
    @SubscribeEvent
    public void onTick(TickEvent.PlayerTickEvent playerTickEvent) {
        ServerPlayerEntity serverPlayer;
        PlayerEntity playerEntity;
        if (CurtainRules.openFakePlayerInventory && (playerEntity = playerTickEvent.player) instanceof ServerPlayerEntity && (serverPlayer = (ServerPlayerEntity)playerEntity) instanceof EntityPlayerMPFake && serverPlayer.func_70089_S()) {
            MenuHashMap.FAKE_PLAYER_INVENTORY_MENU_MAP.get(serverPlayer).tick();
        }
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            MenuHashMap.FAKE_PLAYER_INVENTORY_MENU_MAP.put(player, new FakePlayerInventoryMenu(player));
        }
    }

    @SubscribeEvent
    public void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            MenuHashMap.FAKE_PLAYER_INVENTORY_MENU_MAP.remove(player);
        }
    }

    @SubscribeEvent
    public void onBreak(ItemStackEvent.BreakSpeed event) {
        BlockState state = event.getState();
        event.setSpeed(CurtainRules.missingTools && state.func_177230_c().func_220072_p(state) == SoundType.field_185853_f ? event.getSpeed() : event.getOriginalSpeed());
    }

    @SubscribeEvent
    public void onUse(ItemStackEvent.Use event) {
        PlayerEntity playerEntity;
        if (CurtainRules.fakePlayerAutoReplenishment && (playerEntity = event.getPlayer()) instanceof EntityPlayerMPFake) {
            EntityPlayerMPFake fakePlayer = (EntityPlayerMPFake)playerEntity;
            FakePlayerAutoReplenishment.autoReplenishment((PlayerEntity)fakePlayer);
        }
    }

    @SubscribeEvent
    public void onHurtAndBreak(ItemStackEvent.HurtAndBreak event) {
        PlayerEntity playerEntity;
        if (CurtainRules.fakePlayerAutoReplaceTool && (playerEntity = event.getPlayer()) instanceof EntityPlayerMPFake) {
            EntityPlayerMPFake fakePlayer = (EntityPlayerMPFake)playerEntity;
            FakePlayerAutoReplaceTool.autoReplaceTool((PlayerEntity)fakePlayer);
        }
    }
}

