/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.dubhe.curtain.Curtain;
import dev.dubhe.curtain.api.rules.Categories;
import dev.dubhe.curtain.api.rules.CurtainRule;
import dev.dubhe.curtain.api.rules.RuleException;
import dev.dubhe.curtain.api.rules.RuleManager;
import dev.dubhe.curtain.utils.MenuHelper;
import dev.dubhe.curtain.utils.TranslationHelper;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;

public class RuleCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher, RuleManager manager) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)manager.getId()).requires(stack -> stack.func_197034_c(2))).executes(RuleCommand::showMenu)).then(Commands.func_197057_a((String)"category").then(Commands.func_197056_a((String)"name", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> ISuggestionProvider.func_197005_b(Categories.getCategories(), (SuggestionsBuilder)builder)).executes(RuleCommand::showCategory)))).then(RuleCommand.valueNode(false, Commands.func_197057_a((String)"setValue")))).then(RuleCommand.valueNode(true, Commands.func_197057_a((String)"setDefault"))));
    }

    private static int showMenu(CommandContext<CommandSource> context) {
        TextComponent component = MenuHelper.main();
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)component, false);
        return 1;
    }

    private static int showCategory(CommandContext<CommandSource> context) {
        IFormattableTextComponent component = MenuHelper.category((String)context.getArgument("name", String.class));
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)component, false);
        return 1;
    }

    private static ArgumentBuilder<CommandSource, ?> valueNode(boolean setDefault, ArgumentBuilder<CommandSource, ?> builder) {
        for (CurtainRule<?> rule : RuleManager.RULES.values()) {
            builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)rule.getNormalName()).executes(context -> RuleCommand.getValue((CommandContext<CommandSource>)context, rule))).then(Commands.func_197056_a((String)"value", RuleCommand.getValue(rule.getType())).suggests((c, b) -> ISuggestionProvider.func_197005_b(rule.getExamples(), (SuggestionsBuilder)b)).executes(context -> RuleCommand.setValue(rule.getNormalName(), (CommandContext<CommandSource>)context, setDefault))));
        }
        return builder;
    }

    private static ArgumentType<?> getValue(Class<?> type) {
        if (type == String.class) {
            return StringArgumentType.string();
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return BoolArgumentType.bool();
        }
        if (type == Byte.class || type == Byte.TYPE) {
            return IntegerArgumentType.integer();
        }
        if (type == Short.class || type == Short.TYPE) {
            return IntegerArgumentType.integer();
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return IntegerArgumentType.integer();
        }
        if (type == Long.class || type == Long.TYPE) {
            return IntegerArgumentType.integer();
        }
        if (type == Float.class || type == Float.TYPE) {
            return FloatArgumentType.floatArg();
        }
        if (type == Double.class || type == Double.TYPE) {
            return DoubleArgumentType.doubleArg();
        }
        throw RuleException.type();
    }

    private static int getValue(CommandContext<CommandSource> context, CurtainRule<?> rule) {
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)MenuHelper.rule(rule), false);
        return 1;
    }

    private static int setValue(String name, CommandContext<CommandSource> context, boolean setDefault) {
        CurtainRule<?> rule = RuleManager.RULES.get(name);
        if (null == rule) {
            throw RuleException.nu11();
        }
        Object obj = context.getArgument("value", rule.getType());
        if (!rule.validate((CommandSource)context.getSource(), String.valueOf(obj))) {
            throw RuleException.legal();
        }
        rule.setValue(obj, rule.getType());
        String ruleName = rule.getNameComponent().getString();
        if (!setDefault) {
            IFormattableTextComponent component = TranslationHelper.translate("curtain.menu.change", ruleName, obj).func_240700_a_(s -> s.func_240712_a_(TextFormatting.GRAY)).func_240702_b_(" ").func_230529_a_((ITextComponent)TranslationHelper.translate("curtain.menu.as_default", new Object[0]).func_240700_a_(s -> s.func_240712_a_(TextFormatting.DARK_GREEN).func_240715_a_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/curtain setDefault %s %s".formatted(name, obj)))));
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)component, false);
            return 0;
        }
        Curtain.rules.setDefault(rule.getNormalName());
        Curtain.rules.saveToFile();
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)TranslationHelper.translate("curtain.menu.change.default", ruleName, obj).func_240699_a_(TextFormatting.GRAY), false);
        return 1;
    }
}

