/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain.commands;

import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.dubhe.curtain.CurtainRules;
import dev.dubhe.curtain.features.player.fakes.IServerPlayer;
import dev.dubhe.curtain.features.player.helpers.EntityPlayerActionPack;
import dev.dubhe.curtain.features.player.patches.EntityPlayerMPFake;
import dev.dubhe.curtain.utils.CommandHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.function.Consumer;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.DimensionArgument;
import net.minecraft.command.arguments.RotationArgument;
import net.minecraft.command.arguments.Vec3Argument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;
import net.minecraft.world.World;

public class PlayerCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        String[] gamemodes = Arrays.stream(GameType.values()).map(GameType::func_77149_b).toList().toArray(new String[0]);
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"player").requires(player -> CommandHelper.canUseCommand(player, CurtainRules.commandPlayer))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"player", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> ISuggestionProvider.func_197005_b(PlayerCommand.getPlayers((CommandSource)c.getSource()), (SuggestionsBuilder)b)).then(Commands.func_197057_a((String)"stop").executes(PlayerCommand::stop))).then(PlayerCommand.makeActionCommand("use", EntityPlayerActionPack.ActionType.USE))).then(PlayerCommand.makeActionCommand("jump", EntityPlayerActionPack.ActionType.JUMP))).then(PlayerCommand.makeActionCommand("attack", EntityPlayerActionPack.ActionType.ATTACK))).then(PlayerCommand.makeActionCommand("drop", EntityPlayerActionPack.ActionType.DROP_ITEM))).then(PlayerCommand.makeDropCommand("drop", false))).then(PlayerCommand.makeActionCommand("dropStack", EntityPlayerActionPack.ActionType.DROP_STACK))).then(PlayerCommand.makeDropCommand("dropStack", true))).then(PlayerCommand.makeActionCommand("swapHands", EntityPlayerActionPack.ActionType.SWAP_HANDS))).then(Commands.func_197057_a((String)"hotbar").then(Commands.func_197056_a((String)"slot", (ArgumentType)IntegerArgumentType.integer((int)1, (int)9)).executes(c -> PlayerCommand.manipulate((CommandContext<CommandSource>)c, ap -> ap.setSlot(IntegerArgumentType.getInteger((CommandContext)c, (String)"slot"))))))).then(Commands.func_197057_a((String)"kill").executes(PlayerCommand::kill))).then(Commands.func_197057_a((String)"shadow").executes(PlayerCommand::shadow))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"mount").executes(PlayerCommand.manipulation(ap -> ap.mount(true)))).then(Commands.func_197057_a((String)"anything").executes(PlayerCommand.manipulation(ap -> ap.mount(false)))))).then(Commands.func_197057_a((String)"dismount").executes(PlayerCommand.manipulation(EntityPlayerActionPack::dismount)))).then(Commands.func_197057_a((String)"sneak").executes(PlayerCommand.manipulation(ap -> ap.setSneaking(true))))).then(Commands.func_197057_a((String)"unsneak").executes(PlayerCommand.manipulation(ap -> ap.setSneaking(false))))).then(Commands.func_197057_a((String)"sprint").executes(PlayerCommand.manipulation(ap -> ap.setSprinting(true))))).then(Commands.func_197057_a((String)"unsprint").executes(PlayerCommand.manipulation(ap -> ap.setSprinting(false))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"look").then(Commands.func_197057_a((String)"north").executes(PlayerCommand.manipulation(ap -> ap.look(Direction.NORTH))))).then(Commands.func_197057_a((String)"south").executes(PlayerCommand.manipulation(ap -> ap.look(Direction.SOUTH))))).then(Commands.func_197057_a((String)"east").executes(PlayerCommand.manipulation(ap -> ap.look(Direction.EAST))))).then(Commands.func_197057_a((String)"west").executes(PlayerCommand.manipulation(ap -> ap.look(Direction.WEST))))).then(Commands.func_197057_a((String)"up").executes(PlayerCommand.manipulation(ap -> ap.look(Direction.UP))))).then(Commands.func_197057_a((String)"down").executes(PlayerCommand.manipulation(ap -> ap.look(Direction.DOWN))))).then(Commands.func_197057_a((String)"at").then(Commands.func_197056_a((String)"position", (ArgumentType)Vec3Argument.func_197301_a()).executes(PlayerCommand::lookAt)))).then(Commands.func_197056_a((String)"direction", (ArgumentType)RotationArgument.func_197288_a()).executes(c -> PlayerCommand.manipulate((CommandContext<CommandSource>)c, ap -> ap.look(RotationArgument.func_200384_a((CommandContext)c, (String)"direction").func_197282_b((CommandSource)c.getSource()))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"turn").then(Commands.func_197057_a((String)"left").executes(c -> PlayerCommand.manipulate((CommandContext<CommandSource>)c, ap -> ap.turn(-90.0f, 0.0f))))).then(Commands.func_197057_a((String)"right").executes(c -> PlayerCommand.manipulate((CommandContext<CommandSource>)c, ap -> ap.turn(90.0f, 0.0f))))).then(Commands.func_197057_a((String)"back").executes(c -> PlayerCommand.manipulate((CommandContext<CommandSource>)c, ap -> ap.turn(180.0f, 0.0f))))).then(Commands.func_197056_a((String)"rotation", (ArgumentType)RotationArgument.func_197288_a()).executes(c -> PlayerCommand.manipulate((CommandContext<CommandSource>)c, ap -> ap.turn(RotationArgument.func_200384_a((CommandContext)c, (String)"rotation").func_197282_b((CommandSource)c.getSource()))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"move").executes(c -> PlayerCommand.manipulate((CommandContext<CommandSource>)c, EntityPlayerActionPack::stopMovement))).then(Commands.func_197057_a((String)"forward").executes(c -> PlayerCommand.manipulate((CommandContext<CommandSource>)c, ap -> ap.setForward(1.0f))))).then(Commands.func_197057_a((String)"backward").executes(c -> PlayerCommand.manipulate((CommandContext<CommandSource>)c, ap -> ap.setForward(-1.0f))))).then(Commands.func_197057_a((String)"left").executes(c -> PlayerCommand.manipulate((CommandContext<CommandSource>)c, ap -> ap.setStrafing(1.0f))))).then(Commands.func_197057_a((String)"right").executes(c -> PlayerCommand.manipulate((CommandContext<CommandSource>)c, ap -> ap.setStrafing(-1.0f)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"spawn").executes(PlayerCommand::spawn)).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"in").requires(player -> player.func_197034_c(2))).then(Commands.func_197056_a((String)"gamemode", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> ISuggestionProvider.func_197008_a((String[])gamemodes, (SuggestionsBuilder)b)).executes(PlayerCommand::spawn)))).then(Commands.func_197057_a((String)"at").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"position", (ArgumentType)Vec3Argument.func_197301_a()).executes(PlayerCommand::spawn)).then(Commands.func_197057_a((String)"facing").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"direction", (ArgumentType)RotationArgument.func_197288_a()).executes(PlayerCommand::spawn)).then(Commands.func_197057_a((String)"in").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"dimension", (ArgumentType)DimensionArgument.func_212595_a()).executes(PlayerCommand::spawn)).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"in").requires(player -> player.func_197034_c(2))).then(Commands.func_197056_a((String)"gamemode", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> ISuggestionProvider.func_197008_a((String[])gamemodes, (SuggestionsBuilder)b)).executes(PlayerCommand::spawn)))))))))));
        dispatcher.register(builder);
    }

    private static LiteralArgumentBuilder<CommandSource> makeActionCommand(String actionName, EntityPlayerActionPack.ActionType type) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)actionName).executes(c -> PlayerCommand.action((CommandContext<CommandSource>)c, type, EntityPlayerActionPack.Action.once()))).then(Commands.func_197057_a((String)"once").executes(c -> PlayerCommand.action((CommandContext<CommandSource>)c, type, EntityPlayerActionPack.Action.once())))).then(Commands.func_197057_a((String)"continuous").executes(c -> PlayerCommand.action((CommandContext<CommandSource>)c, type, EntityPlayerActionPack.Action.continuous())))).then(Commands.func_197057_a((String)"interval").then(Commands.func_197056_a((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(c -> PlayerCommand.action((CommandContext<CommandSource>)c, type, EntityPlayerActionPack.Action.interval(IntegerArgumentType.getInteger((CommandContext)c, (String)"ticks"))))));
    }

    private static LiteralArgumentBuilder<CommandSource> makeDropCommand(String actionName, boolean dropAll) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)actionName).then(Commands.func_197057_a((String)"all").executes(c -> PlayerCommand.manipulate((CommandContext<CommandSource>)c, ap -> ap.drop(-2, dropAll))))).then(Commands.func_197057_a((String)"mainhand").executes(c -> PlayerCommand.manipulate((CommandContext<CommandSource>)c, ap -> ap.drop(-1, dropAll))))).then(Commands.func_197057_a((String)"offhand").executes(c -> PlayerCommand.manipulate((CommandContext<CommandSource>)c, ap -> ap.drop(40, dropAll))))).then(Commands.func_197056_a((String)"slot", (ArgumentType)IntegerArgumentType.integer((int)0, (int)40)).executes(c -> PlayerCommand.manipulate((CommandContext<CommandSource>)c, ap -> ap.drop(IntegerArgumentType.getInteger((CommandContext)c, (String)"slot"), dropAll))));
    }

    private static Collection<String> getPlayers(CommandSource source) {
        LinkedHashSet players = Sets.newLinkedHashSet(Arrays.asList("Steve", "Alex"));
        players.addAll(source.func_197011_j());
        return players;
    }

    private static ServerPlayerEntity getPlayer(CommandContext<CommandSource> context) {
        String playerName = StringArgumentType.getString(context, (String)"player");
        MinecraftServer server = ((CommandSource)context.getSource()).func_197028_i();
        return server.func_184103_al().func_152612_a(playerName);
    }

    private static boolean cantManipulate(CommandContext<CommandSource> context) {
        ServerPlayerEntity sendingPlayer;
        ServerPlayerEntity player = PlayerCommand.getPlayer(context);
        if (player == null) {
            PlayerCommand.sendFeedback((CommandSource)context.getSource(), (ITextComponent)new StringTextComponent("Can only manipulate existing players").func_240699_a_(TextFormatting.RED));
            return true;
        }
        try {
            sendingPlayer = ((CommandSource)context.getSource()).func_197035_h();
        }
        catch (CommandSyntaxException e) {
            return false;
        }
        if (!((CommandSource)context.getSource()).func_197028_i().func_184103_al().func_152596_g(sendingPlayer.func_146103_bH()) && sendingPlayer != player && !(player instanceof EntityPlayerMPFake)) {
            PlayerCommand.sendFeedback((CommandSource)context.getSource(), (ITextComponent)new StringTextComponent("Non OP players can't control other real players").func_240699_a_(TextFormatting.RED));
            return true;
        }
        return false;
    }

    private static boolean cantReMove(CommandContext<CommandSource> context) {
        if (PlayerCommand.cantManipulate(context)) {
            return true;
        }
        ServerPlayerEntity player = PlayerCommand.getPlayer(context);
        if (player instanceof EntityPlayerMPFake) {
            return false;
        }
        PlayerCommand.sendFeedback((CommandSource)context.getSource(), (ITextComponent)new StringTextComponent("Only fake players can be moved or killed").func_240699_a_(TextFormatting.RED));
        return true;
    }

    private static boolean cantSpawn(CommandContext<CommandSource> context) {
        Object playerName = StringArgumentType.getString(context, (String)"player");
        String prefix = "none".equals(CurtainRules.fakePlayerNamePrefix) ? "" : CurtainRules.fakePlayerNamePrefix;
        String suffix = "none".equals(CurtainRules.fakePlayerNameSuffix) ? "" : CurtainRules.fakePlayerNameSuffix;
        playerName = prefix + (String)playerName + suffix;
        MinecraftServer server = ((CommandSource)context.getSource()).func_197028_i();
        PlayerList manager = server.func_184103_al();
        ServerPlayerEntity player = manager.func_152612_a((String)playerName);
        if (player != null) {
            PlayerCommand.sendFeedback((CommandSource)context.getSource(), (ITextComponent)new StringTextComponent("Player ").func_240699_a_(TextFormatting.RED).func_230529_a_((ITextComponent)new StringTextComponent((String)playerName).func_240699_a_(TextFormatting.RED)).func_230529_a_((ITextComponent)new StringTextComponent(" is already logged on").func_240699_a_(TextFormatting.RED).func_240699_a_(TextFormatting.BOLD)));
            return true;
        }
        GameProfile profile = server.func_152358_ax().func_152655_a((String)playerName);
        if (profile == null) {
            profile = new GameProfile(PlayerEntity.func_175147_b((String)playerName), (String)playerName);
        }
        if (manager.func_152608_h().func_152702_a(profile)) {
            PlayerCommand.sendFeedback((CommandSource)context.getSource(), (ITextComponent)new StringTextComponent("Player ").func_240699_a_(TextFormatting.RED).func_230529_a_((ITextComponent)new StringTextComponent((String)playerName).func_240699_a_(TextFormatting.RED)).func_230529_a_((ITextComponent)new StringTextComponent(" is banned on this server").func_240699_a_(TextFormatting.RED).func_240699_a_(TextFormatting.BOLD)));
            return true;
        }
        if (manager.func_72383_n() && manager.func_152607_e(profile) && !((CommandSource)context.getSource()).func_197034_c(2)) {
            PlayerCommand.sendFeedback((CommandSource)context.getSource(), (ITextComponent)new StringTextComponent("Whitelisted players can only be spawned by operators").func_240699_a_(TextFormatting.RED));
            return true;
        }
        return false;
    }

    private static int kill(CommandContext<CommandSource> context) {
        if (PlayerCommand.cantReMove(context)) {
            return 0;
        }
        PlayerCommand.getPlayer(context).func_174812_G();
        return 1;
    }

    private static int lookAt(CommandContext<CommandSource> context) {
        return PlayerCommand.manipulate(context, ap -> {
            try {
                ap.lookAt(Vec3Argument.func_197300_a((CommandContext)context, (String)"position"));
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        });
    }

    private static <T> T tryGetArg(SupplierWithCommandSyntaxException<T> a, SupplierWithCommandSyntaxException<T> b) throws CommandSyntaxException {
        try {
            return a.get();
        }
        catch (IllegalArgumentException e) {
            return b.get();
        }
    }

    private static int spawn(CommandContext<CommandSource> context) throws CommandSyntaxException {
        String suffix;
        if (PlayerCommand.cantSpawn(context)) {
            return 0;
        }
        CommandSource source = (CommandSource)context.getSource();
        Vector3d pos = PlayerCommand.tryGetArg(() -> Vec3Argument.func_197300_a((CommandContext)context, (String)"position"), () -> ((CommandSource)source).func_197036_d());
        Vector2f facing = PlayerCommand.tryGetArg(() -> RotationArgument.func_200384_a((CommandContext)context, (String)"direction").func_197282_b((CommandSource)context.getSource()), () -> ((CommandSource)source).func_201004_i());
        RegistryKey dimType = PlayerCommand.tryGetArg(() -> DimensionArgument.func_212592_a((CommandContext)context, (String)"dimension").func_234923_W_(), () -> source.func_197023_e().func_234923_W_());
        GameType mode = GameType.CREATIVE;
        boolean flying = false;
        try {
            ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
            mode = player.field_71134_c.func_73081_b();
            flying = player.field_71075_bZ.field_75100_b;
        }
        catch (CommandSyntaxException player) {
            // empty catch block
        }
        try {
            String opGameMode = StringArgumentType.getString(context, (String)"gamemode");
            mode = GameType.func_185328_a((String)opGameMode, null);
            if (mode == null) {
                PlayerCommand.sendFeedback((CommandSource)context.getSource(), (ITextComponent)new StringTextComponent("Invalid game mode: " + opGameMode + ".").func_240699_a_(TextFormatting.RED).func_240699_a_(TextFormatting.BOLD));
                return 0;
            }
        }
        catch (IllegalArgumentException opGameMode) {
            // empty catch block
        }
        if (mode == GameType.SPECTATOR) {
            flying = true;
        }
        Object playerName = StringArgumentType.getString(context, (String)"player");
        String prefix = "none".equals(CurtainRules.fakePlayerNamePrefix) ? "" : CurtainRules.fakePlayerNamePrefix;
        playerName = prefix + (String)playerName + (suffix = "none".equals(CurtainRules.fakePlayerNameSuffix) ? "" : CurtainRules.fakePlayerNameSuffix);
        if (((String)playerName).length() > PlayerCommand.maxPlayerLength(source.func_197028_i())) {
            PlayerCommand.sendFeedback((CommandSource)context.getSource(), (ITextComponent)new StringTextComponent("Player name: " + (String)playerName + " is too long").func_240699_a_(TextFormatting.RED).func_240699_a_(TextFormatting.BOLD));
            return 0;
        }
        MinecraftServer server = source.func_197028_i();
        if (!World.func_175701_a((BlockPos)new BlockPos(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c))) {
            PlayerCommand.sendFeedback((CommandSource)context.getSource(), (ITextComponent)new StringTextComponent("Player " + (String)playerName + " cannot be placed outside of the world").func_240699_a_(TextFormatting.RED).func_240699_a_(TextFormatting.BOLD));
            return 0;
        }
        EntityPlayerMPFake player = EntityPlayerMPFake.createFake((String)playerName, server, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, facing.field_189983_j, facing.field_189982_i, (RegistryKey<World>)dimType, mode, flying);
        if (player == null) {
            PlayerCommand.sendFeedback((CommandSource)context.getSource(), (ITextComponent)new StringTextComponent("Player " + StringArgumentType.getString(context, (String)"player") + " doesn't exist and cannot spawn in online mode. Turn the server offline to spawn non-existing players").func_240699_a_(TextFormatting.RED).func_240699_a_(TextFormatting.BOLD));
            return 0;
        }
        return 1;
    }

    private static int maxPlayerLength(MinecraftServer server) {
        return server.func_71215_F() >= 0 ? 16 : 40;
    }

    private static int stop(CommandContext<CommandSource> context) {
        if (PlayerCommand.cantManipulate(context)) {
            return 0;
        }
        ServerPlayerEntity player = PlayerCommand.getPlayer(context);
        ((IServerPlayer)player).getActionPack().stopAll();
        return 1;
    }

    private static int manipulate(CommandContext<CommandSource> context, Consumer<EntityPlayerActionPack> action) {
        if (PlayerCommand.cantManipulate(context)) {
            return 0;
        }
        ServerPlayerEntity player = PlayerCommand.getPlayer(context);
        action.accept(((IServerPlayer)player).getActionPack());
        return 1;
    }

    private static Command<CommandSource> manipulation(Consumer<EntityPlayerActionPack> action) {
        return c -> PlayerCommand.manipulate((CommandContext<CommandSource>)c, action);
    }

    private static int action(CommandContext<CommandSource> context, EntityPlayerActionPack.ActionType type, EntityPlayerActionPack.Action action) {
        return PlayerCommand.manipulate(context, ap -> ap.start(type, action));
    }

    private static int shadow(CommandContext<CommandSource> context) {
        ServerPlayerEntity player = PlayerCommand.getPlayer(context);
        if (player instanceof EntityPlayerMPFake) {
            PlayerCommand.sendFeedback((CommandSource)context.getSource(), (ITextComponent)new StringTextComponent("Cannot shadow fake players").func_240699_a_(TextFormatting.RED));
            return 0;
        }
        ServerPlayerEntity sendingPlayer = null;
        try {
            sendingPlayer = ((CommandSource)context.getSource()).func_197035_h();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        if (sendingPlayer != player && PlayerCommand.cantManipulate(context)) {
            return 0;
        }
        EntityPlayerMPFake.createShadow(player.field_71133_b, player);
        return 1;
    }

    private static void sendFeedback(CommandSource source, ITextComponent message) {
        source.func_197030_a(message, source.func_197028_i().func_71218_a(World.field_234918_g_) != null);
    }

    @FunctionalInterface
    static interface SupplierWithCommandSyntaxException<T> {
        public T get() throws CommandSyntaxException;
    }
}

