/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain.api.menu.control;

import dev.dubhe.curtain.api.Function;
import dev.dubhe.curtain.utils.TranslationHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;

public class Button {
    private boolean init = false;
    private boolean flag;
    private final Item onItem;
    private final Item offItem;
    private final int itemCount;
    private final IFormattableTextComponent onText;
    private final IFormattableTextComponent offText;
    CompoundNBT compoundTag = new CompoundNBT();
    private final List<Function> turnOnFunctions = new ArrayList<Function>();
    private final List<Function> turnOffFunctions = new ArrayList<Function>();

    public Button() {
        this(true, Items.field_221803_eL, Items.field_221966_go);
    }

    public Button(boolean defaultState) {
        this(defaultState, Items.field_221803_eL, Items.field_221966_go);
    }

    public Button(boolean defaultState, int itemCount) {
        this(defaultState, Items.field_221803_eL, Items.field_221966_go, itemCount);
    }

    public Button(boolean defaultState, int itemCount, IFormattableTextComponent onText, IFormattableTextComponent offText) {
        this(defaultState, Items.field_221803_eL, Items.field_221966_go, itemCount, onText, offText);
    }

    public Button(boolean defaultState, IFormattableTextComponent onText, IFormattableTextComponent offText) {
        this(defaultState, Items.field_221803_eL, Items.field_221966_go, 1, onText, offText);
    }

    public Button(boolean defaultState, String key) {
        this(defaultState, Items.field_221803_eL, Items.field_221966_go, 1, TranslationHelper.translate(key, TextFormatting.GREEN, Style.field_240709_b_.func_240713_a_(Boolean.valueOf(true)).func_240722_b_(Boolean.valueOf(false)), new Object[]{"on"}), TranslationHelper.translate(key, TextFormatting.RED, Style.field_240709_b_.func_240713_a_(Boolean.valueOf(true)).func_240722_b_(Boolean.valueOf(false)), new Object[]{"off"}));
    }

    public Button(boolean defaultState, Item onItem, Item offItem) {
        this(defaultState, onItem, offItem, 1);
    }

    public Button(boolean defaultState, Item onItem, Item offItem, int itemCount) {
        this(defaultState, onItem, offItem, itemCount, TranslationHelper.translate("on", TextFormatting.GREEN, Style.field_240709_b_.func_240713_a_(Boolean.valueOf(true)).func_240722_b_(Boolean.valueOf(false)), new Object[0]), TranslationHelper.translate("off", TextFormatting.RED, Style.field_240709_b_.func_240713_a_(Boolean.valueOf(true)).func_240722_b_(Boolean.valueOf(false)), new Object[0]));
    }

    public Button(boolean defaultState, Item onItem, Item offItem, int itemCount, IFormattableTextComponent onText, IFormattableTextComponent offText) {
        this.flag = defaultState;
        this.onText = onText;
        this.offText = offText;
        this.onItem = onItem;
        this.offItem = offItem;
        this.itemCount = itemCount;
        this.compoundTag.func_74757_a("CurtainGUIItem", true);
    }

    public void checkButton(IInventory container, int slot) {
        ItemStack item;
        ItemStack onItemStack = new ItemStack((IItemProvider)this.onItem, this.itemCount);
        onItemStack.func_77982_d(this.compoundTag.func_74737_b());
        onItemStack.func_200302_a((ITextComponent)this.onText);
        ItemStack offItemStack = new ItemStack((IItemProvider)this.offItem, this.itemCount);
        offItemStack.func_77982_d(this.compoundTag.func_74737_b());
        offItemStack.func_200302_a((ITextComponent)this.offText);
        if (!this.init) {
            this.updateButton(container, slot, onItemStack, offItemStack);
            this.init = true;
        }
        if ((item = container.func_70301_a(slot)).func_190926_b()) {
            boolean bl = this.flag = !this.flag;
            if (this.flag) {
                this.runTurnOnFunction();
            } else {
                this.runTurnOffFunction();
            }
        }
        this.updateButton(container, slot, onItemStack, offItemStack);
    }

    public void updateButton(IInventory container, int slot, ItemStack onItemStack, ItemStack offItemStack) {
        if (container.func_70301_a(slot).func_77973_b() != onItemStack.func_77973_b() && container.func_70301_a(slot).func_77973_b() != offItemStack.func_77973_b() && !container.func_70301_a(slot).func_190926_b()) {
            return;
        }
        if (this.flag) {
            container.func_70299_a(slot, onItemStack);
        } else {
            container.func_70299_a(slot, offItemStack);
        }
    }

    public void addTurnOnFunction(Function function) {
        this.turnOnFunctions.add(function);
    }

    public void addTurnOffFunction(Function function) {
        this.turnOffFunctions.add(function);
    }

    public void turnOnWithoutFunction() {
        this.flag = true;
    }

    public void turnOffWithoutFunction() {
        this.flag = false;
    }

    public void turnOn() {
        this.flag = true;
        this.runTurnOnFunction();
    }

    public void turnOff() {
        this.flag = false;
        this.runTurnOffFunction();
    }

    public void runTurnOnFunction() {
        for (Function turnOnFunction : this.turnOnFunctions) {
            turnOnFunction.accept();
        }
    }

    public void runTurnOffFunction() {
        for (Function turnOffFunction : this.turnOffFunctions) {
            turnOffFunction.accept();
        }
    }

    public boolean getFlag() {
        return this.flag;
    }
}

