/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain;

import dev.dubhe.curtain.api.rules.CurtainRule;
import dev.dubhe.curtain.api.rules.IValidator;
import dev.dubhe.curtain.api.rules.Rule;
import dev.dubhe.curtain.api.rules.Validators;
import dev.dubhe.curtain.utils.TranslationHelper;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.rcon.IServer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class CurtainRules {
    public static final ThreadLocal<Boolean> impendingFillSkipUpdates = ThreadLocal.withInitial(() -> false);
    @Rule(categories={"feature"}, validators={LanguageValidator.class}, suggestions={"zh_cn", "en_us"})
    public static String language = "zh_cn";
    @Rule(categories={"creative"}, validators={ViewDistanceValidator.class}, suggestions={"0", "12", "16", "32"})
    public static int viewDistance = 0;
    @Rule(categories={"creative"})
    public static boolean xpNoCooldown = false;
    @Rule(categories={"command"})
    public static boolean allowSpawningOfflinePlayers = false;
    @Rule(categories={"command"}, validators={Validators.CommandLevel.class}, suggestions={"ops", "true", "false"})
    public static String commandPlayer = "ops";
    @Rule(categories={"command"}, validators={Validators.CommandLevel.class}, suggestions={"ops", "true", "false"})
    public static String commandLog = "true";
    @Rule(categories={"survival"})
    public static boolean missingTools = false;
    @Rule(categories={"creative", "survival", "feature"})
    public static boolean flippingCactus = false;
    @Rule(categories={"feature"})
    public static boolean rotatorBlock = false;
    @Rule(categories={"bugfix"})
    public static boolean placementRotationFix = false;
    @Rule(categories={"creative", "survival"}, suggestions={"none", "tps", "mobcaps", "mobcaps,tps"})
    public static String defaultLoggers = "none";
    @Rule(categories={"survival"}, suggestions={"1", "5", "20", "100"}, serializedName="hud_logger_update_interval")
    public static int HUDLoggerUpdateInterval = 20;
    @Rule(categories={"creative"}, suggestions={"none"}, serializedName="custom_motd")
    public static String customMOTD = "none";
    @Rule(categories={"survival", "feature"}, suggestions={"false", "true", "16"}, validators={StackableShulkerBoxValidator.class})
    public static String stackableShulkerBoxes = "false";
    public static int shulkerBoxStackSize = 1;
    @Rule(categories={"creative", "client"})
    public static boolean creativeNoClip = false;
    @Rule(categories={"command", "bot"}, suggestions={"none", "bot_"}, validators={FakePlayerNameValidator.class})
    public static String fakePlayerNamePrefix = "none";
    @Rule(categories={"command", "bot"}, suggestions={"none", "_fake"}, validators={FakePlayerNameValidator.class})
    public static String fakePlayerNameSuffix = "none";
    @Rule(categories={"survival"})
    public static boolean quickLeafDecay = false;
    @Rule(categories={"feature", "client"})
    public static boolean superLead = false;
    @Rule(categories={"feature"})
    public static boolean desertShrubs = false;
    @Rule(categories={"creative"})
    public static boolean turtleEggTrampledDisabled = false;
    @Rule(categories={"creative"})
    public static boolean farmlandTrampledDisabled = false;
    @Rule(categories={"creative", "tnt"})
    public static boolean explosionNoBlockDamage = false;
    @Rule(categories={"tnt"}, serializedName="optimized_tnt")
    public static boolean optimizedTNT = false;
    @Rule(categories={"tnt"}, suggestions={"-1"}, validators={CheckOptimizedTntEnabledValidator.class, TNTRandomRangeValidator.class})
    public static double tntRandomRange = -1.0;
    @Rule(categories={"tnt", "creative"})
    public static boolean tntPrimerMomentumRemoved = false;
    @Rule(categories={"tnt"}, suggestions={"0"}, validators={TNTAngleValidator.class}, serializedName="hardcode_tnt_angle")
    public static double hardcodeTNTAngle = -1.0;
    @Rule(categories={"tnt"}, serializedName="merge_tnt")
    public static boolean mergeTNT = false;
    @Rule(categories={"bugfix", "survival"})
    public static boolean ctrlQCraftingFix = false;
    @Rule(categories={"creative", "survival", "bot"})
    public static boolean openFakePlayerInventory = false;
    @Rule(categories={"creative", "survival", "bot"})
    public static boolean openFakePlayerEnderChest = false;
    @Rule(validators={ScaffoldingDistanceValidator.class}, categories={"creative"}, suggestions={"2", "3", "5", "7"})
    public static int scaffoldingDistance = 7;
    @Rule(categories={"creative", "bot"})
    public static boolean fakePlayerAutoFish;
    @Rule(categories={"survival"})
    public static boolean betterSignInteraction;
    @Rule(categories={"survival"})
    public static boolean betterWoodStrip;
    @Rule(categories={"survival"})
    public static boolean betterFenceGatePlacement;
    @Rule(categories={"creative", "survival", "bot"})
    public static boolean fakePlayerResident;
    @Rule(categories={"creative", "survival", "bot"})
    public static boolean fakePlayerAutoReplenishment;
    @Rule(categories={"creative", "survival", "bot"})
    public static boolean fakePlayerAutoReplaceTool;
    @Rule(categories={"creative", "survival"})
    public static boolean blockPlacementIgnoreEntity;
    @Rule(categories={"feature"})
    public static boolean emptyShulkerBoxStackAlways;
    @Rule(categories={"feature"})
    public static boolean chickenShearing;
    @Rule(categories={"survival"}, suggestions={"0", "50", "100"})
    public static int playersSleepingPercentage;
    @Rule(categories={"survival"})
    public static boolean betterSignEditing;
    @Rule(categories={"creative", "survival"})
    public static boolean antiCheatDisabled;

    public static boolean isCreativeFlying(Entity entity) {
        return creativeNoClip && entity instanceof PlayerEntity && ((PlayerEntity)entity).func_184812_l_() && ((PlayerEntity)entity).field_71075_bZ.field_75100_b;
    }

    static {
        betterSignInteraction = false;
        betterWoodStrip = false;
        betterFenceGatePlacement = false;
        fakePlayerResident = false;
        fakePlayerAutoReplenishment = false;
        fakePlayerAutoReplaceTool = false;
        blockPlacementIgnoreEntity = false;
        emptyShulkerBoxStackAlways = false;
        chickenShearing = false;
        playersSleepingPercentage = 100;
        betterSignEditing = false;
        antiCheatDisabled = false;
    }

    public static class ScaffoldingDistanceValidator
    implements IValidator<Integer> {
        @Override
        public boolean validate(CommandSource source, CurtainRule<Integer> rule, String newValue) {
            int value = Integer.parseInt(newValue);
            return value >= 0 && value <= 7;
        }
    }

    public static class TNTAngleValidator
    implements IValidator<Double> {
        @Override
        public boolean validate(CommandSource source, CurtainRule<Double> rule, String newValue) {
            boolean b;
            double value = Double.parseDouble(newValue);
            boolean bl = b = value >= 0.0 && value < Math.PI * 2 || rule.isDefault(newValue);
            if (!b) {
                source.func_197021_a((ITextComponent)new StringTextComponent("Must be between 0 and 2pi, or -1"));
            }
            return b;
        }
    }

    public static class TNTRandomRangeValidator
    implements IValidator<Integer> {
        @Override
        public boolean validate(CommandSource source, CurtainRule<Integer> rule, String newValue) {
            double value = Double.parseDouble(newValue);
            return value == -1.0 || value >= 0.0;
        }
    }

    public static class CheckOptimizedTntEnabledValidator
    implements IValidator<Integer> {
        @Override
        public boolean validate(CommandSource source, CurtainRule<Integer> rule, String newValue) {
            boolean b;
            boolean bl = b = optimizedTNT || rule.isDefault(newValue);
            if (!b) {
                source.func_197021_a((ITextComponent)new StringTextComponent("optimizedTNT must be enabled"));
            }
            return b;
        }
    }

    public static class FakePlayerNameValidator
    implements IValidator<String> {
        @Override
        public boolean validate(CommandSource source, CurtainRule<String> rule, String newValue) {
            return newValue.matches("^\\w*$");
        }
    }

    public static class StackableShulkerBoxValidator
    implements IValidator<String> {
        @Override
        public boolean validate(CommandSource source, CurtainRule<String> rule, String newValue) {
            int value;
            if (newValue.matches("^[0-9]+$") && (value = Integer.parseInt(newValue)) <= 64 && value >= 2) {
                shulkerBoxStackSize = value;
                return true;
            }
            if (newValue.equalsIgnoreCase("false")) {
                shulkerBoxStackSize = 1;
                return true;
            }
            if (newValue.equalsIgnoreCase("true")) {
                shulkerBoxStackSize = 64;
                return true;
            }
            return false;
        }
    }

    public static class ViewDistanceValidator
    implements IValidator<Integer> {
        @Override
        public boolean validate(CommandSource source, CurtainRule<Integer> rule, String newValue) {
            int value;
            try {
                value = Integer.parseInt(newValue);
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (value < 0 || value > 32) {
                source.func_197021_a((ITextComponent)new StringTextComponent("view distance has to be between 0 and 32"));
                return false;
            }
            MinecraftServer server = source.func_197028_i();
            if (server.func_71262_S()) {
                int vd;
                int n = vd = value > 2 ? value : ((IServer)server).func_213221_d_().field_218999_L;
                if (vd != server.func_184103_al().func_72395_o()) {
                    server.func_184103_al().func_217884_a(vd);
                }
                return true;
            }
            source.func_197021_a((ITextComponent)new StringTextComponent("view distance can only be changed on a server"));
            return false;
        }
    }

    public static class LanguageValidator
    implements IValidator<String> {
        @Override
        public boolean validate(CommandSource source, CurtainRule<String> rule, String newValue) {
            return TranslationHelper.getLanguages().contains(newValue);
        }
    }
}

