/*
 * Decompiled with CFR 0.152.
 */
package dev.dubhe.curtain;

import dev.dubhe.curtain.CurtainRules;
import dev.dubhe.curtain.ICurtain;
import dev.dubhe.curtain.api.rules.RuleManager;
import dev.dubhe.curtain.events.MyEventHandlers;
import dev.dubhe.curtain.features.logging.LoggerManager;
import dev.dubhe.curtain.utils.PlanExecution;
import dev.dubhe.curtain.utils.TranslationHelper;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="curtain")
public class Curtain
implements ICurtain {
    public static final String MODID = "curtain";
    public static final Logger LOGGER = LogManager.getLogger((String)"curtain");
    public static final List<ICurtain> SUB_MODS = new ArrayList<ICurtain>();
    public static PlanExecution planExecution = null;
    public static RuleManager rules = null;
    public static MinecraftServer minecraftServer = null;

    public Curtain() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        MyEventHandlers.register();
        LoggerManager.registryBuiltinLogger();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        this.addRules(CurtainRules.class);
        this.setTrans();
    }

    public static void addSubMod(ICurtain curtain) {
        SUB_MODS.add(curtain);
    }

    private void setTrans() {
        InputStream stream = TranslationHelper.class.getClassLoader().getResourceAsStream("assets/curtain/lang/zh_cn.json");
        this.parseTrans("zh_cn", stream);
        stream = TranslationHelper.class.getClassLoader().getResourceAsStream("assets/curtain/lang/en_us.json");
        this.parseTrans("en_us", stream);
    }

    public static ResourceLocation of(String str) {
        return new ResourceLocation(MODID, str);
    }
}

