/*
 * Decompiled with CFR 0.152.
 */
package vazkii.ambience.commands;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldServer;
import vazkii.ambience.Ambience;
import vazkii.ambience.Util.WorldData;
import vazkii.ambience.World.Biomes.Area;

public class RemoveAreaCommand
extends CommandBase {
    private final List<String> aliases = Lists.newArrayList((Object[])new String[]{"ambience", "areadel"});

    public String func_71517_b() {
        return "areadel";
    }

    public String func_71518_a(ICommandSender sender) {
        return "areadel <x> <y> <z> or /areadel <area ID>";
    }

    public List<String> func_71514_a() {
        return this.aliases;
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        ((WorldServer)sender.func_130014_f_()).func_152344_a(() -> {
            WorldData data;
            BlockPos pos = null;
            Area currentArea = null;
            try {
                if (args.length == 1) {
                    currentArea = Area.getAreabyID(Integer.parseInt(args[0]));
                }
                if (args.length > 2) {
                    pos = new BlockPos(this.processCoordInput(args[0], sender.func_180425_c().func_177958_n(), args[0].split("~").length > 1 ? Integer.parseInt(args[0].split("~")[1]) : 0), this.processCoordInput(args[1], sender.func_180425_c().func_177956_o(), args[1].split("~").length > 1 ? Integer.parseInt(args[1].split("~")[1]) : 0), this.processCoordInput(args[2], sender.func_180425_c().func_177952_p(), args[2].split("~").length > 1 ? Integer.parseInt(args[2].split("~")[1]) : 0));
                }
            }
            catch (Exception e) {
                if (e instanceof ArrayIndexOutOfBoundsException) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Missing coordinate"));
                }
                if (e instanceof NumberFormatException) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Invalid coordinate"));
                }
                sender.func_145747_a((ITextComponent)new TextComponentString("Usage: " + TextFormatting.YELLOW + "/areadel <x> <y> <z> or /areadel <area ID>"));
            }
            if (args.length == 1) {
                if (currentArea != null) {
                    currentArea.setOperation(Area.Operation.DELETE);
                    data = new WorldData().GetArasforWorld(sender.func_130014_f_());
                    data.removeArea(currentArea);
                    data.saveData();
                    Ambience.getWorldData().listAreas = data.listAreas;
                    Ambience.sync = true;
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Region removed with success!"));
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Region not found for the ID '" + args[0] + "'"));
                }
            }
            if (args.length > 2 && pos != null) {
                currentArea = Area.getBlockStandingArea(pos);
                if (currentArea != null) {
                    currentArea.setOperation(Area.Operation.DELETE);
                    data = new WorldData().GetArasforWorld(sender.func_130014_f_());
                    data.removeArea(currentArea);
                    data.saveData();
                    Ambience.getWorldData().listAreas = data.listAreas;
                    Ambience.sync = true;
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Region removed with success!"));
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Region not found for the selected coordinate."));
                }
            }
        });
    }

    private int processCoordInput(String input, int axisValue, int sumValue) {
        if (input.equals("~")) {
            return Integer.parseInt("" + axisValue);
        }
        if (input.equals("-~")) {
            return Integer.parseInt("" + -axisValue);
        }
        if (input.equals("~" + sumValue)) {
            return Integer.parseInt("" + (sumValue + axisValue));
        }
        return Integer.parseInt(input);
    }
}

