/*
 * Decompiled with CFR 0.152.
 */
package vazkii.ambience.commands;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldServer;
import vazkii.ambience.Ambience;
import vazkii.ambience.Util.WorldData;
import vazkii.ambience.World.Biomes.Area;

public class CreateAreaCommand
extends CommandBase {
    private final List<String> aliases = Lists.newArrayList((Object[])new String[]{"ambience", "area"});

    public String func_71517_b() {
        return "area";
    }

    public String func_71518_a(ICommandSender sender) {
        return "area <name> <x1> <y1> <z1> <x2> <y2> <z2> <instant play> <play at night>";
    }

    public List<String> func_71514_a() {
        return this.aliases;
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        ((WorldServer)sender.func_130014_f_()).func_152344_a(() -> {
            Vec3d pos1 = null;
            Vec3d pos2 = null;
            String areaName = "";
            Boolean playInstant = false;
            Boolean playAtNight = false;
            Boolean commandValid = false;
            try {
                if (args.length == 0 || args[0].equals("help")) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "<--- Area Commands --->"));
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "/area -> creates a new region."));
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "/area list -> show the information for all the regions created."));
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "/area showInfo -> show the region informations for the current player standing region."));
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "/areadel -> delete a region"));
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "/areaedit -> edit a region"));
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "<--------------------->"));
                } else if (args[0].equals("showInfo")) {
                    Area area = Area.getBlockStandingArea(sender.func_180425_c());
                    if (area != null) {
                        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.WHITE + "<-------------------------------->"));
                        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "ID: " + area.getID()));
                        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Name: " + area.getName()));
                        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Pos1: " + area.getPos1()));
                        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Pos2: " + area.getPos2()));
                        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Dimension: " + area.getDimension()));
                        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Instant Play: " + area.isInstantPlay()));
                        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Play at night: " + area.isPlayatNight()));
                        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.WHITE + "<-------------------------------->"));
                    } else {
                        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Must be inside a Region to show the informations"));
                    }
                } else if (args[0].equals("list")) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.WHITE + "<-------------------------------->"));
                    for (Area area : Ambience.getWorldData().listAreas) {
                        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Name: " + area.getName() + " ID: " + area.getID() + " Pos1: " + area.getPos1() + " Pos2: " + area.getPos2()));
                    }
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.WHITE + "<-------------------------------->"));
                } else {
                    if (args[0].isEmpty() | args[0] == null) {
                        commandValid = false;
                        throw new Exception("Missing a Name for the Region.");
                    }
                    areaName = args[0];
                    commandValid = true;
                    pos1 = new Vec3d((double)this.processCoordInput(args[1], sender.func_180425_c().func_177958_n(), args[1].split("~").length > 1 ? Integer.parseInt(args[1].split("~")[1]) : 0), (double)this.processCoordInput(args[2], sender.func_180425_c().func_177956_o(), args[2].split("~").length > 1 ? Integer.parseInt(args[2].split("~")[1]) : 0), (double)this.processCoordInput(args[3], sender.func_180425_c().func_177952_p(), args[3].split("~").length > 1 ? Integer.parseInt(args[3].split("~")[1]) : 0));
                    if (pos1.equals((Object)(pos2 = new Vec3d((double)this.processCoordInput(args[4], sender.func_180425_c().func_177958_n(), args[4].split("~").length > 1 ? Integer.parseInt(args[4].split("~")[1]) : 0), (double)this.processCoordInput(args[5], sender.func_180425_c().func_177956_o(), args[5].split("~").length > 1 ? Integer.parseInt(args[5].split("~")[1]) : 0), (double)this.processCoordInput(args[6], sender.func_180425_c().func_177952_p(), args[6].split("~").length > 1 ? Integer.parseInt(args[6].split("~")[1]) : 0))))) {
                        throw new Exception("The coordinates can't be the same");
                    }
                    if (args.length > 7) {
                        if (!args[7].equals("true") & !args[7].equals("false")) {
                            commandValid = false;
                            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Invalid value '" + args[7] + "' for instant play, accepted values: true|false"));
                        } else {
                            commandValid = true;
                            playInstant = Boolean.parseBoolean(args[7]);
                        }
                    }
                    if (args.length > 8) {
                        if (!args[8].equals("true") & !args[8].equals("false")) {
                            commandValid = false;
                            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Invalid value '" + args[8] + "' for play at night, accepted values: true|false"));
                        } else {
                            commandValid = true;
                            playAtNight = Boolean.parseBoolean(args[8]);
                        }
                    }
                }
            }
            catch (Exception e) {
                commandValid = false;
                if (args.length < 1) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Missing the Region Name"));
                }
                if (e instanceof Exception & e.getMessage().length() > 2) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "" + e.getMessage()));
                }
                if (e instanceof ArrayIndexOutOfBoundsException) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Missing coordinates"));
                }
                if (e instanceof NumberFormatException) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Invalid coordinates"));
                }
                sender.func_145747_a((ITextComponent)new TextComponentString("Usage: " + TextFormatting.YELLOW + "/area <name> <x1> <y1> <z1> <x2> <y2> <z2> <instant play> <play at night>"));
            }
            if (commandValid.booleanValue()) {
                Area currentArea = new Area();
                currentArea.setName(areaName);
                currentArea.setOperation(Area.Operation.CREATE);
                currentArea.setPos1(pos1);
                currentArea.setPos2(pos2);
                currentArea.setPlayAtNight(playAtNight);
                currentArea.setInstantPlay(playInstant);
                WorldData data = new WorldData().GetArasforWorld(sender.func_130014_f_());
                data.addArea(currentArea);
                data.saveData();
                Ambience.getWorldData().listAreas = data.listAreas;
                Ambience.sync = true;
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Region created with success!"));
            }
        });
    }

    private int processCoordInput(String input, int axisValue, int sumValue) {
        if (input.equals("~")) {
            return Integer.parseInt("" + axisValue);
        }
        if (input.equals("-~")) {
            return Integer.parseInt("" + -axisValue);
        }
        if (input.equals("~" + sumValue)) {
            return Integer.parseInt("" + (sumValue + axisValue));
        }
        return Integer.parseInt(input);
    }
}

