/*
 * Decompiled with CFR 0.152.
 */
package vazkii.ambience.World.Biomes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import vazkii.ambience.Ambience;
import vazkii.ambience.Util.Border;

public class Area
implements Comparator<Area> {
    private Operation operation;
    private int Dimension;
    private int ID;
    private int redstoneStrength;
    private String name;
    private boolean instantPlay = false;
    private boolean playAtNight = false;
    private int cubicArea = 0;
    private Vec3d pos1;
    private Vec3d pos2;

    public boolean isPlayatNight() {
        return this.playAtNight;
    }

    public boolean isInstantPlay() {
        return this.instantPlay;
    }

    public void setPlayAtNight(boolean playAtNight) {
        this.playAtNight = playAtNight;
    }

    public void setInstantPlay(boolean instantPlay) {
        this.instantPlay = instantPlay;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public int getDimension() {
        return this.Dimension;
    }

    public void setDimension(int dimension) {
        this.Dimension = dimension;
    }

    public int getRedstoneStrength() {
        return this.redstoneStrength;
    }

    public void setRedstoneStrength(int Strength) {
        this.redstoneStrength = Strength;
    }

    public int getID() {
        return this.ID;
    }

    public void setID(int iD) {
        this.ID = iD;
    }

    public Area() {
    }

    public Area(String parName) {
        this.name = parName;
    }

    public String getName() {
        return this.name;
    }

    public Vec3d getPos1() {
        return this.pos1;
    }

    public void setPos1(Vec3d pos1) {
        this.pos1 = pos1;
    }

    public Vec3d getPos2() {
        return this.pos2;
    }

    public void setPos2(Vec3d pos2) {
        this.pos2 = pos2;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void resetSelection() {
        this.pos1 = null;
        this.pos2 = null;
    }

    public String simplifyOperation() {
        switch (this.getOperation()) {
            case CREATE: {
                return "c";
            }
            case EDIT: {
                return "e";
            }
            case DELETE: {
                return "d";
            }
        }
        return "c";
    }

    public NBTTagList getPosListTag() {
        NBTTagList tagList = new NBTTagList();
        NBTTagCompound posCompound = new NBTTagCompound();
        posCompound.func_74780_a("x1", this.pos1.field_72450_a);
        posCompound.func_74780_a("y1", this.pos1.field_72448_b);
        posCompound.func_74780_a("z1", this.pos1.field_72449_c);
        posCompound.func_74780_a("x2", this.pos2.field_72450_a);
        posCompound.func_74780_a("y2", this.pos2.field_72448_b);
        posCompound.func_74780_a("z2", this.pos2.field_72449_c);
        tagList.func_74742_a((NBTBase)posCompound);
        return tagList;
    }

    private int generateNewID() {
        int newid = 0;
        ArrayList<String> idsList = new ArrayList<String>();
        Iterator<Area> iterator = Ambience.getWorldData().listAreas.iterator();
        while (iterator.hasNext()) {
            idsList.add(Integer.toString(iterator.next().ID));
        }
        for (int i = 0; i <= idsList.size(); ++i) {
            if (idsList.contains(Integer.toString(i))) continue;
            newid = i;
            break;
        }
        return newid;
    }

    public static Area getPlayerStandingArea(EntityPlayer player) {
        Area area;
        ArrayList<Area> Areas = new ArrayList<Area>();
        if (Ambience.getWorldData().listAreas != null) {
            for (Area area2 : Ambience.getWorldData().listAreas) {
                if (area2.getDimension() != player.field_71093_bK) continue;
                Border border = new Border(area2.getPos1(), area2.getPos2());
                if (!(border.p1 != null & border.p2 != null) || !border.contains(player.func_174791_d())) continue;
                area2.getCubicArea();
                Areas.add(area2);
            }
        }
        if (Areas.size() > 0 && Ambience.selectedArea != null && (area = Ambience.selectedArea).getDimension() == player.field_71093_bK) {
            Border border = new Border(area.getPos1(), area.getPos2());
            if (border.p1 != null & border.p2 != null && border.contains(player.func_174791_d())) {
                String test = player.func_174791_d().toString();
                area.getCubicArea();
                Areas.add(area);
            }
        }
        Ambience.multiArea = Areas.size();
        if (Areas.size() > 0) {
            Area minArea = Collections.min(Areas, new Area());
            return minArea;
        }
        return null;
    }

    public static Area getBlockStandingArea(BlockPos pos) {
        ArrayList<Area> Areas = new ArrayList<Area>();
        if (Ambience.getWorldData().listAreas != null) {
            for (Area area : Ambience.getWorldData().listAreas) {
                Border border = new Border(area.getPos1(), area.getPos2());
                if (!(border.p1 != null & border.p2 != null) || !border.contains(new Vec3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()))) continue;
                Areas.add(area);
            }
        }
        if (Areas.size() > 0) {
            Area minArea = Collections.min(Areas, new Area());
            return minArea;
        }
        return null;
    }

    public static Area getAreabyID(int id) {
        for (Area area : Ambience.getWorldData().listAreas) {
            if (area.ID != id) continue;
            return area;
        }
        return null;
    }

    @Override
    public int compare(Area a, Area b) {
        if (a.cubicArea < b.cubicArea) {
            return -1;
        }
        if (a.cubicArea == b.cubicArea) {
            return 0;
        }
        return 1;
    }

    public void getCubicArea() {
        double lenght = Math.abs(this.pos1.field_72450_a - this.pos2.field_72450_a) + 1.0;
        double width = Math.abs(this.pos1.field_72449_c - this.pos2.field_72449_c) + 1.0;
        double height = Math.abs(this.pos1.field_72448_b - this.pos2.field_72448_b - 1.0);
        this.cubicArea = (int)(lenght * width * height);
    }

    public NBTTagCompound SerializeThis() {
        if (this.getOperation() == Operation.CREATE) {
            this.setID(this.generateNewID());
        }
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74782_a("Pos", (NBTBase)this.getPosListTag());
        tagCompound.func_74778_a("Name", this.getName());
        tagCompound.func_74768_a("D", this.getDimension());
        tagCompound.func_74768_a("ID", this.getID());
        tagCompound.func_74778_a("op", this.simplifyOperation());
        tagCompound.func_74757_a("playNight", this.isPlayatNight());
        tagCompound.func_74757_a("instP", this.isInstantPlay());
        tagCompound.func_74768_a("RedstoneStrength", this.getRedstoneStrength());
        return tagCompound;
    }

    public static Area DeSerialize(NBTTagCompound nbt) {
        Area area = new Area(nbt.func_74779_i("Name"));
        area.setDimension(nbt.func_74762_e("D"));
        area.setID(nbt.func_74762_e("ID"));
        area.setPlayAtNight(nbt.func_74767_n("playNight"));
        area.setInstantPlay(nbt.func_74767_n("instP"));
        area.setRedstoneStrength(nbt.func_74762_e("RedstoneStrength"));
        switch (nbt.func_74779_i("op")) {
            case "c": {
                area.setOperation(Operation.CREATE);
                break;
            }
            case "e": {
                area.setOperation(Operation.EDIT);
                break;
            }
            case "d": {
                area.setOperation(Operation.DELETE);
                break;
            }
            default: {
                area.setOperation(Operation.CREATE);
            }
        }
        NBTTagList tagListPos = nbt.func_150295_c("Pos", 10);
        for (NBTTagCompound posCompound : tagListPos) {
            Vec3d pos1 = new Vec3d(posCompound.func_74769_h("x1"), posCompound.func_74769_h("y1"), posCompound.func_74769_h("z1"));
            area.setPos1(pos1);
            Vec3d pos2 = new Vec3d(posCompound.func_74769_h("x2"), posCompound.func_74769_h("y2"), posCompound.func_74769_h("z2"));
            area.setPos2(pos2);
        }
        return area;
    }

    public static List<Area> DeSerializeList(NBTTagCompound nbt) {
        ArrayList<Area> localListAreas = new ArrayList<Area>();
        for (int i = 0; i < nbt.func_74762_e("lenght"); ++i) {
            NBTTagCompound areaCompound = (NBTTagCompound)nbt.func_74781_a("Area" + i);
            Area area = new Area(areaCompound.func_74779_i("Name"));
            area.setDimension(areaCompound.func_74762_e("D"));
            area.setID(areaCompound.func_74762_e("ID"));
            area.setPlayAtNight(areaCompound.func_74767_n("playNight"));
            area.setInstantPlay(areaCompound.func_74767_n("instP"));
            area.setRedstoneStrength(areaCompound.func_74762_e("RedstoneStrength"));
            localListAreas.add(area);
            NBTTagList tagListPos = areaCompound.func_150295_c("Pos", 10);
            for (NBTTagCompound posCompound : tagListPos) {
                Vec3d pos1 = new Vec3d(posCompound.func_74769_h("x1"), posCompound.func_74769_h("y1"), posCompound.func_74769_h("z1"));
                area.setPos1(pos1);
                Vec3d pos2 = new Vec3d(posCompound.func_74769_h("x2"), posCompound.func_74769_h("y2"), posCompound.func_74769_h("z2"));
                area.setPos2(pos2);
            }
        }
        return localListAreas;
    }

    public static enum Operation {
        CREATE,
        EDIT,
        DELETE;

    }
}

