/*
 * Decompiled with CFR 0.152.
 */
package vazkii.ambience.Util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import vazkii.ambience.World.Biomes.Area;

public class WorldData
extends WorldSavedData {
    static final String key = "ambience";
    public MapStorage storage;
    public List<Area> listAreas = new ArrayList<Area>();
    private NBTTagCompound data = new NBTTagCompound();

    public WorldData(String name) {
        super(name);
    }

    public WorldData() {
        super(key);
    }

    public List<Area> getAreas() {
        return this.listAreas;
    }

    public void addArea(Area parArea) {
        this.listAreas.add(parArea);
        this.func_76185_a();
    }

    public void removeArea(Area parArea) {
        for (Area area : this.listAreas) {
            if (area.getID() != parArea.getID()) continue;
            this.listAreas.remove(area);
            break;
        }
        this.func_76185_a();
    }

    public void editArea(Area parArea) {
        int index = 0;
        for (Area area : this.listAreas) {
            if (area.getID() == parArea.getID()) {
                this.listAreas.set(index, parArea);
                break;
            }
            ++index;
        }
        this.func_76185_a();
    }

    public void clearAreas() {
        this.listAreas.clear();
        this.func_76185_a();
    }

    @Nullable
    public Area getAreaByName(String parName) {
        if (this.listAreas.size() > 0) {
            for (Area area : this.listAreas) {
                if (!area.getName().equals(parName)) continue;
                return area;
            }
        }
        return null;
    }

    public WorldData GetArasforWorld(World world) {
        this.storage = world.func_175693_T();
        WorldData result = new WorldData();
        result = (WorldData)this.storage.func_75742_a(WorldData.class, key);
        if (result == null) {
            result = new WorldData(key);
            this.storage.func_75745_a(key, (WorldSavedData)result);
        }
        this.listAreas = result.listAreas;
        return result;
    }

    public void saveData() {
        NBTTagList tagList = new NBTTagList();
        Iterator<Area> iteratorArea = this.listAreas.iterator();
        while (iteratorArea.hasNext()) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            Area area = iteratorArea.next();
            tagCompound.func_74782_a("Pos", (NBTBase)area.getPosListTag());
            tagCompound.func_74778_a("Name", area.getName());
            tagCompound.func_74768_a("D", area.getDimension());
            tagCompound.func_74768_a("ID", area.getID());
            tagCompound.func_74757_a("playNight", area.isPlayatNight());
            tagCompound.func_74757_a("instP", area.isInstantPlay());
            tagCompound.func_74768_a("RedstoneStrength", area.getRedstoneStrength());
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        this.data.func_74782_a("Areas", (NBTBase)tagList);
        this.func_76185_a();
    }

    public static NBTTagCompound SerializeThis(List<Area> data) {
        NBTTagCompound nbt = new NBTTagCompound();
        int count = 0;
        Iterator<Area> iteratorArea = data.iterator();
        while (iteratorArea.hasNext()) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            Area area = iteratorArea.next();
            tagCompound.func_74782_a("Pos", (NBTBase)area.getPosListTag());
            tagCompound.func_74778_a("Name", area.getName());
            tagCompound.func_74768_a("D", area.getDimension());
            tagCompound.func_74768_a("ID", area.getID());
            tagCompound.func_74757_a("playNight", area.isPlayatNight());
            tagCompound.func_74757_a("instP", area.isInstantPlay());
            tagCompound.func_74768_a("RedstoneStrength", area.getRedstoneStrength());
            nbt.func_74782_a("Area" + count++, (NBTBase)tagCompound);
        }
        nbt.func_74768_a("lenght", count);
        return nbt;
    }

    public void func_76184_a(NBTTagCompound compound) {
        this.data = compound.func_74775_l(key);
        this.listAreas.clear();
        NBTTagList tagListAreas = this.data.func_150295_c("Areas", 10);
        for (NBTTagCompound areaCompound : tagListAreas) {
            Area area = new Area(areaCompound.func_74779_i("Name"));
            area.setDimension(areaCompound.func_74762_e("D"));
            area.setID(areaCompound.func_74762_e("ID"));
            area.setPlayAtNight(areaCompound.func_74767_n("playNight"));
            area.setInstantPlay(areaCompound.func_74767_n("instP"));
            area.setRedstoneStrength(areaCompound.func_74762_e("RedstoneStrength"));
            this.listAreas.add(area);
            NBTTagList tagListPos = areaCompound.func_150295_c("Pos", 10);
            for (NBTTagCompound posCompound : tagListPos) {
                Vec3d pos1 = new Vec3d(posCompound.func_74769_h("x1"), posCompound.func_74769_h("y1"), posCompound.func_74769_h("z1"));
                area.setPos1(pos1);
                Vec3d pos2 = new Vec3d(posCompound.func_74769_h("x2"), posCompound.func_74769_h("y2"), posCompound.func_74769_h("z2"));
                area.setPos2(pos2);
            }
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        compound.func_74782_a(key, (NBTBase)this.data);
        return compound;
    }
}

