/*
 * Decompiled with CFR 0.152.
 */
package vazkii.ambience.Util.Handlers;

import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import vaskii.ambience.Init.BlockInit;
import vaskii.ambience.Init.ItemInit;
import vazkii.ambience.Util.Handlers.SoundHandler;
import vazkii.ambience.Util.IHasModel;
import vazkii.ambience.commands.CreateAreaCommand;
import vazkii.ambience.commands.RemoveAreaCommand;
import vazkii.ambience.commands.UpdateAreaCommand;

@Mod.EventBusSubscriber
public class RegistryHandler {
    @SubscribeEvent
    public static void onSoundRegister(RegistryEvent.Register<SoundEvent> event) {
        SoundHandler.registerSounds();
    }

    @SubscribeEvent
    public static void onItemRegister(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ItemInit.ITEMS.toArray(new Item[0]));
    }

    @SubscribeEvent
    public static void onBlockRegister(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])BlockInit.BLOCKS.toArray(new Block[0]));
    }

    @SubscribeEvent
    public static void onModelRegister(ModelRegistryEvent event) {
        for (Item item : ItemInit.ITEMS) {
            if (!(item instanceof IHasModel)) continue;
            ((IHasModel)item).registerModels();
        }
        for (Block block : BlockInit.BLOCKS) {
            if (!(block instanceof IHasModel)) continue;
            ((IHasModel)block).registerModels();
        }
    }

    public static void serverRegistries(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CreateAreaCommand());
        event.registerServerCommand((ICommand)new RemoveAreaCommand());
        event.registerServerCommand((ICommand)new UpdateAreaCommand());
    }
}

