/*
 * Decompiled with CFR 0.152.
 */
package vazkii.ambience.Util.Handlers;

import java.io.File;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockJukebox;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.toasts.GuiToast;
import net.minecraft.client.gui.toasts.SystemToast;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.ParticleDrip;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.particle.ParticleSplash;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.AudioFileIO;
import org.jaudiotagger.audio.AudioHeader;
import org.lwjgl.opengl.Display;
import vaskii.ambience.Init.ItemInit;
import vaskii.ambience.network4.MyMessage4;
import vaskii.ambience.network4.NetworkHandler4;
import vaskii.ambience.network4.OcarinaNetworkHandler;
import vaskii.ambience.objects.items.Horn;
import vaskii.ambience.objects.items.Ocarina;
import vaskii.ambience.render.CinematicRender;
import vaskii.ambience.render.HornRender;
import vaskii.ambience.render.SelectionBoxRenderer;
import vazkii.ambience.Ambience;
import vazkii.ambience.AmbienceConfig;
import vazkii.ambience.NilMusicTicker;
import vazkii.ambience.PlayerThread;
import vazkii.ambience.SongLoader;
import vazkii.ambience.SongPicker;
import vazkii.ambience.Util.Utils;
import vazkii.ambience.Util.particles.DripLavaParticleFactory;
import vazkii.ambience.Util.particles.DripWaterParticleFactory;

public class EventHandlers {
    public static String currentSong;
    public static String nextSong;
    private static final int WAIT_DURATION = 25;
    public static int FADE_DURATION;
    public static final int SILENCE_DURATION = 5;
    public static int waitTick;
    public static int fadeOutTicks;
    public static int fadeInTicks;
    public static boolean fadeIn;
    public static int silenceTicks;
    public int attackFadeTime = 300;
    public static int attackingTimer;
    static Entity currentplayer;
    public static KeyBinding[] keyBindings;
    public static float oldVolume;
    public static CinematicRender cinematic;
    public Ambience ambience;
    static int oldCameraMode;
    private static float zoomCount;
    public static float zoomAmount;
    public static double zoomSpeed;
    public static double oldFOV;
    public static boolean cameraChanged;
    int count = 0;
    boolean pressedkey = false;
    boolean played_match = false;
    boolean settingDay = false;
    boolean settingNight = false;
    static boolean playingAdvancement;
    int adcancementTimer = 0;
    static PlayerThread thread2;
    static String AdvancementSong;
    static int songLenght;
    boolean playing = true;
    boolean focused = false;
    private float masterAudioCount = 0.0f;
    public static boolean show;

    @SubscribeEvent
    public void onLootLoad(LootTableLoadEvent event) {
        if (event.getName().equals((Object)new ResourceLocation("minecraft:chests/simple_dungeon"))) {
            event.getTable().addPool(event.getLootTableManager().func_186521_a(new ResourceLocation("ambience:chests/simple_dungeon")).getPool("simpleDungeon"));
        } else if (event.getName().equals((Object)new ResourceLocation("minecraft:chests/desert_pyramid"))) {
            event.getTable().addPool(event.getLootTableManager().func_186521_a(new ResourceLocation("ambience:chests/desert_pyramid")).getPool("desertPyramid"));
        } else if (event.getName().equals((Object)new ResourceLocation("minecraft:chests/abandoned_mineshaft"))) {
            event.getTable().addPool(event.getLootTableManager().func_186521_a(new ResourceLocation("ambience:chests/abandoned_mineshaft")).getPool("abandonedMineshaft"));
        } else if (event.getName().equals((Object)new ResourceLocation("minecraft:chests/end_city_treasure"))) {
            event.getTable().addPool(event.getLootTableManager().func_186521_a(new ResourceLocation("ambience:chests/end_city_treasure")).getPool("endCity"));
        } else if (event.getName().equals((Object)new ResourceLocation("minecraft:chests/jungle_temple"))) {
            event.getTable().addPool(event.getLootTableManager().func_186521_a(new ResourceLocation("ambience:chests/jungle_temple")).getPool("jungleTemple"));
        } else if (event.getName().equals((Object)new ResourceLocation("minecraft:chests/village_blacksmith"))) {
            event.getTable().addPool(event.getLootTableManager().func_186521_a(new ResourceLocation("ambience:chests/village_blacksmith")).getPool("villageBlocksmith"));
        }
    }

    public EventHandlers(Ambience amb) {
        this.ambience = amb;
        attackingTimer = this.attackFadeTime;
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        oldVolume = settings.func_186711_a(SoundCategory.MASTER);
        currentplayer = Minecraft.func_71410_x().field_71439_g;
        keyBindings = new KeyBinding[12];
        EventHandlers.keyBindings[0] = new KeyBinding("Options.Reload", 25, "Ambience");
        EventHandlers.keyBindings[1] = new KeyBinding("Force Play", 24, "Ambience");
        EventHandlers.keyBindings[2] = new KeyBinding("Options.Shortcut1", 0, "Ambience");
        EventHandlers.keyBindings[3] = new KeyBinding("Options.Shortcut2", 0, "Ambience");
        EventHandlers.keyBindings[4] = new KeyBinding("Options.Shortcut3", 0, "Ambience");
        EventHandlers.keyBindings[5] = new KeyBinding("Options.Shortcut4", 0, "Ambience");
        EventHandlers.keyBindings[6] = new KeyBinding("Options.Shortcut5", 0, "Ambience");
        EventHandlers.keyBindings[7] = new KeyBinding("Options.Ocarina1", 200, "Ambience");
        EventHandlers.keyBindings[8] = new KeyBinding("Options.Ocarina2", 208, "Ambience");
        EventHandlers.keyBindings[9] = new KeyBinding("Options.Ocarina3", 205, "Ambience");
        EventHandlers.keyBindings[10] = new KeyBinding("Options.Ocarina4", 203, "Ambience");
        EventHandlers.keyBindings[11] = new KeyBinding("Options.Ocarina5", 157, "Ambience");
        for (int i = 0; i < keyBindings.length; ++i) {
            ClientRegistry.registerKeyBinding((KeyBinding)keyBindings[i]);
        }
    }

    public static void onAdvancement() {
        if (SongPicker.eventMap.containsKey("advancement") & !playingAdvancement) {
            thread2 = new PlayerThread();
            Random rand = new Random();
            String[] songChoices = SongPicker.eventMap.get("advancement");
            if (songChoices != null & !playingAdvancement && songChoices.length > 0) {
                playingAdvancement = true;
                AdvancementSong = songChoices[rand.nextInt(songChoices.length)];
                EventHandlers.getSongLenght();
                thread2.play(AdvancementSong);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (currentplayer == null) {
            currentplayer = Minecraft.func_71410_x().field_71439_g;
        }
        if (playingAdvancement) {
            ++this.adcancementTimer;
            int scale_time = 20;
            scale_time = Minecraft.func_71410_x().func_147104_D() == null ? 80 : 20;
            if (this.adcancementTimer > songLenght * scale_time) {
                this.adcancementTimer = 0;
                playingAdvancement = false;
                thread2.forceKill();
            }
        }
        Horn horn = (Horn)ItemInit.itemHorn;
        if (horn.playerMe == event.player && horn.played & horn.damageDone && !(event.player.func_184614_ca().func_77973_b() instanceof Horn)) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74757_a("shouting", false);
            NetworkHandler4.sendToServer(new MyMessage4(nbt));
            horn.itemstack = null;
            horn.played = false;
            horn.damageDone = false;
        }
    }

    private static void getSongLenght() {
        File f = new File(Ambience.ambienceDir + "\\music\\", AdvancementSong + ".mp3");
        if (f.isFile()) {
            try {
                AudioFile af = AudioFileIO.read(f);
                AudioHeader ah = af.getAudioHeader();
                songLenght = ah.getTrackLength();
            }
            catch (Exception exception) {}
        } else {
            songLenght = 0;
        }
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent e) {
        if (e.isCanceled()) {
            return;
        }
        if (e.getFace() != null) {
            Block juckebox;
            ItemStack item = e.getEntityPlayer().func_184586_b(e.getHand());
            if (item.func_77973_b() instanceof Ocarina) {
                e.setCanceled(true);
            }
            if (e.getEntityPlayer().func_70613_aW() && (juckebox = e.getEntityPlayer().field_70170_p.func_180495_p(e.getPos()).func_177230_c()) instanceof BlockJukebox && Ambience.playingJuckebox) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74757_a("playingJuckebox", false);
                NetworkHandler4.sendToServer(new MyMessage4(nbt));
                SongPicker.lastPlayerPos = e.getEntityPlayer().func_180425_c();
            }
        }
    }

    @SubscribeEvent
    public void onOverlayRender(RenderGameOverlayEvent.Post event) {
        Ocarina Ocarina2 = (Ocarina)ItemInit.itemOcarina;
        Ocarina2.renderFX(event, zoomCount, zoomAmount, zoomSpeed, 20.0f);
        cinematic.renderFX(event, zoomCount, zoomAmount, 0.7f, 20.0f);
    }

    private void setCameraMode(int mode) {
        Minecraft.func_71410_x().field_71474_y.field_74320_O = mode;
    }

    @SubscribeEvent
    public void keyEvent(InputEvent.KeyInputEvent event) {
        if (Minecraft.func_71410_x().field_71415_G) {
            NilMusicTicker ticker;
            Minecraft mc;
            if (keyBindings[0].func_151468_f()) {
                SongPicker.reset();
                SongLoader.loadFrom(Ambience.ambienceDir);
                mc = Minecraft.func_71410_x();
                ticker = new NilMusicTicker(mc);
                ObfuscationReflectionHelper.setPrivateValue(Minecraft.class, (Object)mc, (Object)((Object)ticker), (String[])Ambience.OBF_MC_MUSIC_TICKER);
                SystemToast.func_193657_a((GuiToast)mc.func_193033_an(), (SystemToast.Type)SystemToast.Type.TUTORIAL_HINT, (ITextComponent)new TextComponentString(I18n.func_135052_a((String)"Ambience.ReloadTitle", (Object[])new Object[0])), (ITextComponent)new TextComponentString(I18n.func_135052_a((String)"Ambience.Reload", (Object[])new Object[0])));
            }
            if (keyBindings[1].func_151468_f()) {
                Ambience.thread.forceKill();
                Ambience.thread.run();
                SongLoader.loadFrom(Ambience.ambienceDir);
                if (SongLoader.enabled) {
                    Ambience.thread = new PlayerThread();
                }
                mc = Minecraft.func_71410_x();
                ticker = new NilMusicTicker(mc);
                ObfuscationReflectionHelper.setPrivateValue(Minecraft.class, (Object)mc, (Object)((Object)ticker), (String[])Ambience.OBF_MC_MUSIC_TICKER);
                SystemToast.func_193657_a((GuiToast)mc.func_193033_an(), (SystemToast.Type)SystemToast.Type.TUTORIAL_HINT, (ITextComponent)new TextComponentString(I18n.func_135052_a((String)"Ambience.ReloadTitle", (Object[])new Object[0])), (ITextComponent)new TextComponentString(I18n.func_135052_a((String)"Ambience.Force", (Object[])new Object[0])));
            }
            if (keyBindings[2].func_151468_f()) {
                EventHandlers.ToggleForcePlay(0);
            }
            if (keyBindings[3].func_151468_f()) {
                EventHandlers.ToggleForcePlay(1);
            }
            if (keyBindings[4].func_151468_f()) {
                EventHandlers.ToggleForcePlay(2);
            }
            if (keyBindings[5].func_151468_f()) {
                EventHandlers.ToggleForcePlay(3);
            }
            if (keyBindings[6].func_151468_f()) {
                EventHandlers.ToggleForcePlay(4);
            }
            if (keyBindings[7].func_151468_f()) {
                this.addPressedKey(1);
            } else {
                this.removePressedKey(1);
            }
            if (keyBindings[8].func_151468_f()) {
                this.addPressedKey(2);
            } else {
                this.removePressedKey(2);
            }
            if (keyBindings[9].func_151468_f()) {
                this.addPressedKey(3);
            } else {
                this.removePressedKey(3);
            }
            if (keyBindings[10].func_151468_f()) {
                this.addPressedKey(4);
            } else {
                this.removePressedKey(4);
            }
            if (keyBindings[11].func_151468_f()) {
                this.addPressedKey(5);
            } else {
                this.removePressedKey(5);
            }
        }
    }

    private void addPressedKey(int key) {
        Ocarina Ocarina2 = (Ocarina)ItemInit.itemOcarina;
        Ocarina2.key_id = key;
        if (!Ocarina2.actualPressedKeys.contains(Ocarina2.key_id) | Ocarina2.actualPressedKeys.size() == 0) {
            Ocarina2.actualPressedKeys.add(Ocarina2.key_id);
            Ocarina2.addPressedKey(key);
        }
        this.syncKeysServer(key);
    }

    private void removePressedKey(int key) {
        Ocarina Ocarina2 = (Ocarina)ItemInit.itemOcarina;
        if (Ocarina2.actualPressedKeys.size() > 0 && Ocarina2.actualPressedKeys.contains(key)) {
            Ocarina2.actualPressedKeys.remove((Object)key);
        }
    }

    private void syncKeysServer(int key) {
        Ocarina Ocarina2 = (Ocarina)ItemInit.itemOcarina;
        String keys = "";
        for (Integer actualKey : Ocarina2.actualPressedKeys) {
            keys = keys + actualKey + ",";
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("keyPressed", key);
        nbt.func_74778_a("actualPressedKeys", keys);
        nbt.func_74757_a("playing", Ocarina2.playing);
        nbt.func_74757_a("runningCommand", Ocarina2.runningCommand);
        OcarinaNetworkHandler.sendToServer(new MyMessage4(nbt));
    }

    private static void ToggleForcePlay(int id) {
        Minecraft mc = Minecraft.func_71410_x();
        Ambience.forcePlay = Ambience.forcePlay != false ? Boolean.valueOf(false) : Boolean.valueOf(true);
        SongPicker.forcePlayID = id;
        if (Minecraft.func_71410_x().field_71474_y.field_151444_V.func_151470_d()) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74757_a("forcedPlay", Ambience.forcePlay.booleanValue());
            nbt.func_74768_a("forcedPlayID", SongPicker.forcePlayID);
            NetworkHandler4.sendToServer(new MyMessage4(nbt));
        }
    }

    @SubscribeEvent
    public void onFOVModifierEvent(EntityViewRenderEvent.FOVModifier event) {
        if (((Ocarina)ItemInit.itemOcarina).playing) {
            ItemStack item;
            Minecraft mc = Minecraft.func_71410_x();
            ItemStack itemStack = item = mc.field_71439_g.func_184586_b(EnumHand.MAIN_HAND) == null ? mc.field_71439_g.func_184586_b(EnumHand.OFF_HAND) : mc.field_71439_g.func_184586_b(EnumHand.MAIN_HAND);
            if (item != null && item.func_77973_b() instanceof Ocarina) {
                Minecraft.func_71410_x().field_71474_y.field_74326_T = true;
                if (zoomCount > zoomAmount && (zoomCount = (float)((double)zoomCount - zoomSpeed)) < zoomAmount) {
                    zoomCount = zoomAmount;
                }
                event.setFOV(zoomCount);
                return;
            }
            this.setCameraMode(oldCameraMode);
        }
        if (zoomCount != 70.0f) {
            Minecraft.func_71410_x().field_71474_y.field_74326_T = false;
            if (zoomCount < 70.0f && (zoomCount = (float)((double)zoomCount + zoomSpeed)) > event.getFOV()) {
                zoomCount = event.getFOV();
            }
            event.setFOV(zoomCount);
            if ((double)zoomCount > oldFOV - 1.0) {
                Ocarina Ocarina2 = (Ocarina)ItemInit.itemOcarina;
                this.setCameraMode(oldCameraMode);
                cameraChanged = false;
                Ocarina2.pressedKeys.clear();
                Ocarina2.old_key_id = -1;
                Ocarina2.runningCommand = false;
                Ocarina2.songName = "";
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74757_a("resetVariables", true);
                OcarinaNetworkHandler.sendToServer(new MyMessage4(nbt));
            }
        }
    }

    @SubscribeEvent
    public void onEntitySetAttackTargetEvent(LivingAttackEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            Ambience.attacked = true;
            attackingTimer = this.attackFadeTime;
            EventHandlers.playInstant();
        }
    }

    @SubscribeEvent
    public void onPlayerAttackEvent(AttackEntityEvent event) {
        String mobName = event.getTarget().func_70005_c_().toLowerCase();
        if (event.getTarget() instanceof EntityMob) {
            Ambience.attacked = true;
            attackingTimer = this.attackFadeTime;
            EventHandlers.playInstant();
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onEntityDeath(LivingDeathEvent event) {
        DamageSource source = event.getSource();
        if (source.func_76346_g() instanceof EntityPlayer & event.getEntity() == currentplayer) {
            Ambience.attacked = false;
        }
        if (event.getEntity() instanceof EntityPlayer & event.getEntity() == currentplayer) {
            Ambience.attacked = false;
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onWorldLoad(WorldEvent.Load ev) {
        Minecraft mc = Minecraft.func_71410_x();
        SongPicker.cinematicMap.clear();
        if (mc.field_71452_i != null) {
            try {
                ParticleManager instance = mc.field_71452_i;
                Map facts = (Map)ObfuscationReflectionHelper.getPrivateValue(ParticleManager.class, (Object)instance, (String)"field_178932_g");
                IParticleFactory pf = (IParticleFactory)facts.get(EnumParticleTypes.WATER_SPLASH.func_179348_c());
                if (AmbienceConfig.waterDripping_enabled.booleanValue() && pf instanceof ParticleSplash.Factory) {
                    instance.func_178929_a(EnumParticleTypes.WATER_SPLASH.func_179348_c(), (IParticleFactory)new DripWaterParticleFactory());
                }
                if (AmbienceConfig.lavaDripping_enabled.booleanValue() && (pf = (IParticleFactory)facts.get(EnumParticleTypes.DRIP_LAVA.func_179348_c())) instanceof ParticleDrip.LavaFactory) {
                    instance.func_178929_a(EnumParticleTypes.DRIP_LAVA.func_179348_c(), (IParticleFactory)new DripLavaParticleFactory());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void playInstant() {
        fadeOutTicks = FADE_DURATION;
        silenceTicks = 5;
        waitTick = 0;
        Ambience.instantPlaying = true;
        Ambience.thread.setGain(PlayerThread.fadeGains[0]);
        fadeIn = false;
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (Ambience.thread == null) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            if (Display.isCreated()) {
                if (this.focused && !Display.isActive()) {
                    this.focused = false;
                } else if (!this.focused && Display.isActive()) {
                    this.focused = true;
                }
            }
            String songs = SongPicker.getSongsString();
            String song = null;
            if (songs != null) {
                if (nextSong == null || !songs.contains(nextSong)) {
                    while ((song = SongPicker.getRandomSong()).equals(currentSong) && songs.contains(",")) {
                    }
                } else {
                    song = nextSong;
                }
            }
            GameSettings settings = Minecraft.func_71410_x().field_71474_y;
            if (!this.focused) {
                if (this.masterAudioCount >= 0.1f) {
                    this.masterAudioCount -= 0.05f;
                }
                if (AmbienceConfig.lostFocusEnabled.booleanValue()) {
                    settings.func_186712_a(SoundCategory.MASTER, this.masterAudioCount);
                }
            } else if (AmbienceConfig.lostFocusEnabled.booleanValue() && this.masterAudioCount < Utils.clamp(oldVolume, 0.1f, 1.0f)) {
                this.masterAudioCount += 0.05f;
                settings.func_186712_a(SoundCategory.MASTER, this.masterAudioCount);
            }
            if (fadeIn) {
                Ambience.thread.setGain(PlayerThread.fadeGains[fadeInTicks]);
            }
            if (PlayerThread.gain < 0.0f & fadeInTicks > 0) {
                --fadeInTicks;
                fadeIn = true;
            } else {
                fadeIn = false;
                fadeInTicks = FADE_DURATION - 1;
            }
            if (songs != null && (!songs.equals(PlayerThread.currentSongChoices) || song == null && PlayerThread.currentSong != null || !Ambience.thread.playing)) {
                if (nextSong != null && nextSong.equals(song)) {
                    --waitTick;
                }
                if (!song.equals(currentSong)) {
                    if (currentSong != null && PlayerThread.currentSong != null && !PlayerThread.currentSong.equals(song) && songs.equals(PlayerThread.currentSongChoices)) {
                        currentSong = PlayerThread.currentSong;
                    } else {
                        nextSong = song;
                    }
                } else if (nextSong != null && !songs.contains(nextSong)) {
                    nextSong = null;
                }
                if (waitTick <= 0) {
                    if (PlayerThread.currentSong == null) {
                        currentSong = nextSong;
                        nextSong = null;
                        PlayerThread.currentSongChoices = songs;
                        EventHandlers.changeSongTo(song);
                        fadeOutTicks = 0;
                        waitTick = 25;
                    } else if (fadeOutTicks < FADE_DURATION) {
                        Ambience.thread.setGain(PlayerThread.fadeGains[fadeOutTicks]);
                        ++fadeOutTicks;
                        silenceTicks = 0;
                    } else if (silenceTicks < 5) {
                        ++silenceTicks;
                    } else {
                        nextSong = null;
                        PlayerThread.currentSongChoices = songs;
                        EventHandlers.changeSongTo(song);
                        fadeOutTicks = 0;
                        waitTick = 25;
                    }
                }
            } else {
                nextSong = null;
                silenceTicks = 0;
                fadeOutTicks = 0;
                waitTick = 25;
            }
            if (Ambience.thread != null) {
                Ambience.thread.setRealGain();
            }
        }
        if (((Ocarina)ItemInit.itemOcarina).playing && !cameraChanged) {
            oldCameraMode = Minecraft.func_71410_x().field_71474_y.field_74320_O;
            oldFOV = Minecraft.func_71410_x().field_71474_y.field_74334_X;
            this.setCameraMode(2);
            cameraChanged = true;
        }
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Text event) {
        if (!Minecraft.func_71410_x().field_71474_y.field_74330_P) {
            return;
        }
        event.getRight().add(null);
        if (Ambience.dimension >= -1 & Ambience.dimension <= 1 | PlayerThread.currentSong != "null" & nextSong != "null") {
            String name;
            if (PlayerThread.currentSong != null) {
                name = "Now Playing: " + SongPicker.getSongName(PlayerThread.currentSong);
                event.getRight().add(name);
            }
            if (nextSong != null) {
                name = "Next Song: " + SongPicker.getSongName(nextSong);
                event.getRight().add(name);
            }
        }
    }

    @SubscribeEvent
    public void onBackgroundMusic(PlaySoundEvent event) {
        if (SongLoader.enabled) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            if (world != null) {
                Ambience.dimension = world.field_73011_w.getDimension();
            }
            if (event.getSound().func_184365_d() == SoundCategory.MUSIC && SongLoader.enabled & (Ambience.dimension >= -1 & Ambience.dimension <= 1) | Ambience.overideBackMusicDimension) {
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
                event.setResultSound(null);
            }
            if (event.getSound().func_184365_d() == SoundCategory.RECORDS) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74757_a("playingJuckebox", true);
                NetworkHandler4.sendToServer(new MyMessage4(nbt));
            }
        }
    }

    public static void changeSongTo(String song) {
        if (song == "null") {
            Ambience.thread.playing = false;
            Ambience.thread.setGain(0.0f);
        }
        currentSong = song;
        Ambience.thread.play(song);
        Ambience.thread.setGain(PlayerThread.fadeGains[fadeInTicks]);
        if (!Ambience.attacked.booleanValue()) {
            fadeInTicks = FADE_DURATION - 1;
            fadeIn = true;
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onWorldRenderLast(RenderWorldLastEvent event) {
        EntityPlayerSP currentplayer = Minecraft.func_71410_x().field_71439_g;
        if (Ambience.previewArea != null && Ambience.previewArea.getPos1() != null & Ambience.previewArea.getPos2() != null) {
            SelectionBoxRenderer.drawBoundingBox(currentplayer.func_174791_d(), Ambience.previewArea.getPos1(), Ambience.previewArea.getPos2(), true, 2.0f, event.getPartialTicks());
        }
        if (currentplayer.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof Horn) {
            HornRender.drawBoundingBox(currentplayer.func_174791_d(), event.getPartialTicks(), event, currentplayer.field_70170_p, (EntityPlayer)currentplayer);
        }
    }

    @SubscribeEvent
    public void firstRender(RenderGameOverlayEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        int py = (int)Math.abs(zoomCount - 70.0f);
        if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR & py > 10) {
            event.setCanceled(true);
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR & Math.abs(CinematicRender.fx_zoomCount - 70.0f) > 10.0f) {
            event.setCanceled(true);
        }
        if (!mc.field_71415_G || mc.field_71439_g == null) {
            return;
        }
        if (!show & Ambience.showUpdateNotification) {
            show = true;
            for (ModContainer container : Loader.instance().getActiveModList()) {
                ForgeVersion.CheckResult res;
                if (container.getModId().startsWith("mcp") || container.getModId().equalsIgnoreCase("mcp") || container.getModId().equalsIgnoreCase("FML") || container.getModId().equalsIgnoreCase("Forge") || ((res = ForgeVersion.getResult((ModContainer)container)) == null || res.status == ForgeVersion.Status.PENDING || res.status != ForgeVersion.Status.BETA_OUTDATED) && res.status != ForgeVersion.Status.OUTDATED) continue;
                String comp = "\u00a7eNew version (\u00a77" + res.target + "\u00a7e) for\u00a7a " + container.getName() + " \u00a7eis available for download ";
                mc.field_71439_g.func_145747_a((ITextComponent)new TextComponentString(comp));
            }
        }
    }

    static {
        FADE_DURATION = AmbienceConfig.fadeDuration;
        waitTick = 25;
        fadeOutTicks = FADE_DURATION;
        fadeInTicks = FADE_DURATION - 1;
        fadeIn = false;
        silenceTicks = 0;
        cinematic = new CinematicRender();
        oldCameraMode = 0;
        zoomCount = 70.0f;
        zoomAmount = 30.0f;
        zoomSpeed = 0.5;
        oldFOV = 0.0;
        cameraChanged = false;
        playingAdvancement = false;
        AdvancementSong = "";
        show = false;
    }
}

