/*
 * Decompiled with CFR 0.152.
 */
package vazkii.ambience;

import java.io.InputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.SoundCategory;
import vazkii.ambience.SongLoader;
import vazkii.ambience.SongPicker;
import vazkii.ambience.Util.Handlers.EventHandlers;
import vazkii.ambience.thirdparty.javazoom.jl.player.AudioDevice;
import vazkii.ambience.thirdparty.javazoom.jl.player.JavaSoundAudioDevice;
import vazkii.ambience.thirdparty.javazoom.jl.player.advanced.AdvancedPlayer;

public class PlayerThread
extends Thread {
    public static final float MIN_GAIN = -50.0f;
    public static final float MAX_GAIN = 0.0f;
    public static float[] fadeGains = new float[EventHandlers.FADE_DURATION];
    public static volatile float gain;
    public static volatile float realGain;
    public static volatile String currentSong;
    public static volatile String currentSongChoices;
    AdvancedPlayer player;
    volatile boolean queued = false;
    volatile boolean kill = false;
    public boolean playing = false;

    public PlayerThread() {
        this.setDaemon(true);
        this.setName("Ambience Player Thread");
        this.start();
    }

    @Override
    public void run() {
        try {
            while (!this.kill) {
                if (this.queued && currentSong != null) {
                    InputStream stream;
                    if (this.player != null) {
                        this.resetPlayer();
                    }
                    if ((stream = SongLoader.getStream()) == null) continue;
                    this.player = new AdvancedPlayer(stream);
                    this.queued = false;
                }
                boolean played = false;
                if (this.player != null && this.player.getAudioDevice() != null && realGain > -50.0f) {
                    this.setGain(fadeGains[0]);
                    this.player.play();
                    this.playing = true;
                    played = true;
                }
                if (!played || this.queued) continue;
                this.next();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void next() {
        if (!currentSongChoices.contains(",")) {
            this.play(currentSong);
        } else if (SongPicker.getSongsString().equals(currentSongChoices)) {
            String newSong;
            while ((newSong = SongPicker.getRandomSong()).equals(currentSong)) {
            }
            this.play(newSong);
        } else {
            this.play(null);
        }
    }

    public void resetPlayer() {
        this.playing = false;
        if (this.player != null) {
            this.player.close();
        }
        currentSong = null;
        this.player = null;
    }

    public void play(String song) {
        this.resetPlayer();
        currentSong = song;
        this.queued = true;
    }

    public float getGain() {
        if (this.player == null) {
            return gain;
        }
        AudioDevice device = this.player.getAudioDevice();
        if (device != null && device instanceof JavaSoundAudioDevice) {
            return ((JavaSoundAudioDevice)device).getGain();
        }
        return gain;
    }

    public void addGain(float gain) {
        this.setGain(this.getGain() + gain);
    }

    public void setGain(float gain) {
        PlayerThread.gain = Math.min(0.0f, Math.max(-50.0f, gain));
        if (this.player == null) {
            return;
        }
        this.setRealGain();
    }

    public void setRealGain() {
        AudioDevice device;
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        float musicGain = settings.func_186711_a(SoundCategory.MUSIC) * settings.func_186711_a(SoundCategory.MASTER);
        float realGain = -50.0f + (gain - -50.0f) * musicGain;
        PlayerThread.realGain = realGain;
        if (this.player != null && (device = this.player.getAudioDevice()) != null && device instanceof JavaSoundAudioDevice) {
            try {
                ((JavaSoundAudioDevice)device).setGain(realGain);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (musicGain == 0.0f) {
            this.play(null);
        }
    }

    public float getRelativeVolume() {
        return this.getRelativeVolume(this.getGain());
    }

    public float getRelativeVolume(float gain) {
        float width = 50.0f;
        float rel = Math.abs(gain - -50.0f);
        return rel / Math.abs(width);
    }

    public int getFramesPlayed() {
        return this.player == null ? 0 : this.player.getFrames();
    }

    public void forceKill() {
        try {
            this.resetPlayer();
            this.interrupt();
            this.finalize();
            this.kill = true;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    static {
        float totaldiff = -50.0f;
        float diff = totaldiff / (float)fadeGains.length;
        for (int i = 0; i < fadeGains.length; ++i) {
            PlayerThread.fadeGains[i] = 0.0f + diff * (float)i;
        }
        gain = 0.0f;
        realGain = 0.0f;
        currentSong = null;
        currentSongChoices = null;
    }
}

