/*
 * Decompiled with CFR 0.152.
 */
package vaskii.ambience.objects.items;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector4f;
import vaskii.ambience.network4.MyMessage4;
import vaskii.ambience.network4.OcarinaNetworkHandler;
import vaskii.ambience.objects.items.ItemBase;
import vazkii.ambience.Util.Utils;

public class Ocarina
extends ItemBase {
    public static boolean setDayTime = false;
    public static Map<String, String[]> songsMap = new HashMap<String, String[]>();
    public int stoopedPlayedFadeOut = 0;
    public boolean playing = false;
    public boolean runningCommand = false;
    public int key_id = -1;
    public int old_key_id = -1;
    public List<String> pressedKeys = new ArrayList<String>();
    public List<Integer> actualPressedKeys = new ArrayList<Integer>();
    public EntityPlayer player = null;
    public boolean hasMatch = false;
    public BlockPos pos = new BlockPos(Vec3d.field_186680_a);
    public String horseName = "";
    public String songName = "";
    static int countCorrect = 0;
    public int delayMatch = 0;
    public static final ResourceLocation Ocarina_OVERLAY_FX = new ResourceLocation("ambience", "textures/gui/ocarina_overlays_fx.png");
    public static final ResourceLocation Ocarina_OVERLAYS = new ResourceLocation("ambience", "textures/gui/ocarina_overlays.png");
    public static float fx_rotateCount = 0.0f;
    public static float fx_zoomCount = 70.0f;
    private float startDelayCount = 0.0f;

    public Ocarina(String Name2) {
        super(Name2);
        this.func_77656_e(21);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public void func_77624_a(ItemStack itemstack, World world, List<String> list, ITooltipFlag flag) {
        super.func_77624_a(itemstack, world, list, flag);
        list.add(I18n.func_135052_a((String)"Ocarina.Desc", (Object[])new Object[0]));
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (this.playing & !this.runningCommand && this.key_id != -1 & this.actualPressedKeys.size() == 1) {
            Ocarina.playNote(this.key_id, (EntityPlayer)entityIn);
            if (worldIn.field_72995_K) {
                this.checkMusicNotes((EntityPlayer)entityIn);
            }
        }
        if (worldIn.field_72995_K) {
            NBTTagCompound nbt;
            if (this.hasMatch) {
                ++this.delayMatch;
            }
            int scale_time = 1;
            scale_time = Minecraft.func_71410_x().func_147104_D() == null ? 1 : 1;
            if (this.delayMatch == 15 * scale_time) {
                this.stoopedPlayedFadeOut = this.getDelayStopTime();
                worldIn.func_184133_a((EntityPlayer)entityIn, entityIn.func_180425_c(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("ambience:match_sound")), SoundCategory.RECORDS, 1.0f, 1.0f);
                nbt = new NBTTagCompound();
                nbt.func_74778_a("playMusic", "ambience:match_sound");
                nbt.func_74782_a("pos", (NBTBase)Utils.BlockPosToNBT(entityIn.func_180425_c()));
                OcarinaNetworkHandler.sendToServer(new MyMessage4(nbt));
            }
            if (this.delayMatch == 35 * scale_time) {
                worldIn.func_184133_a((EntityPlayer)entityIn, entityIn.func_180425_c(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("ambience:" + this.songName)), SoundCategory.RECORDS, 1.0f, 1.0f);
                nbt = new NBTTagCompound();
                nbt.func_74778_a("playMusic", "ambience:" + this.songName);
                nbt.func_74782_a("pos", (NBTBase)Utils.BlockPosToNBT(entityIn.func_180425_c()));
                OcarinaNetworkHandler.sendToServer(new MyMessage4(nbt));
            }
        }
        if (this.stoopedPlayedFadeOut >= -1) {
            --this.stoopedPlayedFadeOut;
        }
        if (this.stoopedPlayedFadeOut == 0) {
            this.playing = false;
            this.hasMatch = false;
            this.runningCommand = false;
            this.songName = "";
            this.delayMatch = 0;
        }
    }

    public Object getActualNotes(int key) {
        for (Integer item : this.actualPressedKeys) {
            if (item != key) continue;
            return item;
        }
        return null;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        boolean flag = true;
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        ActionResult ret = ForgeEventFactory.onArrowNock((ItemStack)itemstack, (World)worldIn, (EntityPlayer)playerIn, (EnumHand)handIn, (boolean)flag);
        if (ret != null) {
            return ret;
        }
        playerIn.func_184598_c(handIn);
        this.playing = true;
        this.player = playerIn;
        return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
    }

    public boolean checkMusicNotes(EntityPlayer playerIn) {
        countCorrect = 0;
        if (this.pressedKeys.size() >= 5) {
            this.songName = "";
            int correctLenght = 0;
            for (Map.Entry<String, String[]> entry : songsMap.entrySet()) {
                correctLenght = entry.getValue().length;
                List<Object> subList = new ArrayList();
                subList = this.pressedKeys.subList((int)Utils.clamp(this.pressedKeys.size() - entry.getValue().length, 0.0f, 16.0f), this.pressedKeys.size());
                countCorrect = 0;
                for (int i = 0; i < subList.size(); ++i) {
                    if (((String)subList.get(i)).equals(entry.getValue()[i])) {
                        this.songName = entry.getKey();
                        ++countCorrect;
                        continue;
                    }
                    --countCorrect;
                    break;
                }
                if (countCorrect < correctLenght) continue;
                break;
            }
            if (songsMap.size() > 0 & countCorrect >= correctLenght & !this.runningCommand) {
                this.old_key_id = -1;
                this.key_id = -1;
                this.hasMatch = true;
                NBTTagCompound nbt = new NBTTagCompound();
                nbt = new NBTTagCompound();
                switch (this.songName) {
                    case "sunssong": {
                        if (setDayTime) {
                            setDayTime = false;
                            nbt = new NBTTagCompound();
                            nbt.func_74757_a("setDayTime", setDayTime);
                            nbt.func_74778_a("songName", this.songName);
                            nbt.func_74782_a("pos", (NBTBase)Utils.BlockPosToNBT(this.player.func_180425_c()));
                            OcarinaNetworkHandler.sendToServer(new MyMessage4(nbt));
                            break;
                        }
                        setDayTime = true;
                        nbt = new NBTTagCompound();
                        nbt.func_74757_a("setDayTime", setDayTime);
                        nbt.func_74778_a("songName", this.songName);
                        nbt.func_74782_a("pos", (NBTBase)Utils.BlockPosToNBT(this.player.func_180425_c()));
                        OcarinaNetworkHandler.sendToServer(new MyMessage4(nbt));
                        break;
                    }
                    case "songofstorms": {
                        nbt.func_74757_a("setWeather", this.player.field_70170_p.func_72896_J());
                        nbt.func_74778_a("songName", this.songName);
                        nbt.func_74782_a("pos", (NBTBase)Utils.BlockPosToNBT(this.player.func_180425_c()));
                        OcarinaNetworkHandler.sendToServer(new MyMessage4(nbt));
                        break;
                    }
                    case "bolerooffire": {
                        nbt = new NBTTagCompound();
                        nbt.func_74757_a("setFireResistance", true);
                        nbt.func_74778_a("songName", this.songName);
                        nbt.func_74782_a("pos", (NBTBase)Utils.BlockPosToNBT(this.player.func_180425_c()));
                        OcarinaNetworkHandler.sendToServer(new MyMessage4(nbt));
                        break;
                    }
                    case "horsesong": {
                        nbt = new NBTTagCompound();
                        nbt.func_74757_a("callHorse", true);
                        nbt.func_74778_a("songName", this.songName);
                        nbt.func_74782_a("pos", (NBTBase)Utils.BlockPosToNBT(this.player.func_180425_c()));
                        OcarinaNetworkHandler.sendToServer(new MyMessage4(nbt));
                        break;
                    }
                    case "preludeoflight": {
                        nbt = new NBTTagCompound();
                        nbt.func_74757_a("setLightVision", true);
                        nbt.func_74778_a("songName", this.songName);
                        nbt.func_74782_a("pos", (NBTBase)Utils.BlockPosToNBT(this.player.func_180425_c()));
                        OcarinaNetworkHandler.sendToServer(new MyMessage4(nbt));
                        break;
                    }
                    case "serenadeofwater": {
                        nbt = new NBTTagCompound();
                        nbt.func_74757_a("setWaterBreathe", true);
                        nbt.func_74778_a("songName", this.songName);
                        nbt.func_74782_a("pos", (NBTBase)Utils.BlockPosToNBT(this.player.func_180425_c()));
                        OcarinaNetworkHandler.sendToServer(new MyMessage4(nbt));
                        break;
                    }
                    case "minuetofforest": {
                        nbt = new NBTTagCompound();
                        nbt.func_74757_a("heal", true);
                        nbt.func_74778_a("songName", this.songName);
                        nbt.func_74782_a("pos", (NBTBase)Utils.BlockPosToNBT(this.player.func_180425_c()));
                        OcarinaNetworkHandler.sendToServer(new MyMessage4(nbt));
                    }
                }
                this.runningCommand = true;
                return true;
            }
            this.hasMatch = false;
            this.songName = "";
            return false;
        }
        return false;
    }

    public static void playNote(int note, EntityPlayer player) {
        player.field_70170_p.func_184133_a(player, player.func_180425_c(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("ambience:ocarina" + note)), SoundCategory.RECORDS, 0.5f, 1.0f);
    }

    public void addPressedKey(int key) {
        this.key_id = key;
        if (this.key_id != -1) {
            this.pressedKeys.add("" + this.key_id);
        }
        this.old_key_id = this.key_id;
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (this.runningCommand) {
            if (worldIn.field_72995_K) {
                this.stoopedPlayedFadeOut = this.getDelayStopTime();
            }
        } else {
            this.playing = false;
        }
    }

    public int getDelayStopTime() {
        switch (this.songName) {
            case "sunssong": {
                this.stoopedPlayedFadeOut = 60;
                break;
            }
            case "songofstorms": {
                this.stoopedPlayedFadeOut = 85;
                break;
            }
            case "bolerooffire": {
                this.stoopedPlayedFadeOut = 300;
                break;
            }
            case "horsesong": {
                this.stoopedPlayedFadeOut = 110;
                break;
            }
            case "preludeoflight": {
                this.stoopedPlayedFadeOut = 300;
                break;
            }
            case "serenadeofwater": {
                this.stoopedPlayedFadeOut = 280;
                break;
            }
            case "minuetofforest": {
                this.stoopedPlayedFadeOut = 280;
                break;
            }
            default: {
                this.stoopedPlayedFadeOut = 100;
            }
        }
        if (Minecraft.func_71410_x().func_147104_D() == null) {
            return this.stoopedPlayedFadeOut * 2;
        }
        return this.stoopedPlayedFadeOut;
    }

    public void renderFX(RenderGameOverlayEvent.Post event, float zoomCount, float zoomAmount, double zoomSpeed, float startDelayTime) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            ScaledResolution res = event.getResolution();
            if (mc.field_71439_g != null) {
                ItemStack item;
                ItemStack itemStack = item = mc.field_71439_g.func_184586_b(EnumHand.MAIN_HAND) == null ? mc.field_71439_g.func_184586_b(EnumHand.OFF_HAND) : mc.field_71439_g.func_184586_b(EnumHand.MAIN_HAND);
                if (item.func_77973_b() instanceof Ocarina) {
                    int width = 2048;
                    int x = res.func_78326_a() / 2;
                    int y = 1 + res.func_78325_e();
                    Vector4f color = new Vector4f(1.0f, 1.0f, 0.0f, 1.0f);
                    if (this.runningCommand) {
                        this.startDelayCount += 1.0f;
                        if (this.startDelayCount > startDelayTime && fx_zoomCount > zoomAmount && (fx_zoomCount = (float)((double)fx_zoomCount - zoomSpeed)) < zoomAmount) {
                            fx_zoomCount = zoomAmount;
                        }
                    } else {
                        if (fx_zoomCount < 70.0f && (fx_zoomCount = (float)((double)fx_zoomCount + zoomSpeed)) > 70.0f) {
                            fx_zoomCount = 70.0f;
                        }
                        this.startDelayCount = 0.0f;
                    }
                    if (fx_zoomCount != 70.0f) {
                        fx_rotateCount += 1.0f;
                        switch (this.songName) {
                            case "sunssong": {
                                color = new Vector4f(1.0f, 1.0f, 0.0f, 0.8f);
                                break;
                            }
                            case "songofstorms": {
                                color = new Vector4f(0.7f, 0.6f, 1.0f, 0.8f);
                                break;
                            }
                            case "bolerooffire": {
                                color = new Vector4f(1.0f, 0.3f, 0.0f, 0.8f);
                                break;
                            }
                            case "horsesong": {
                                color = new Vector4f(1.0f, 0.6f, 0.35f, 0.8f);
                                break;
                            }
                            case "preludeoflight": {
                                color = new Vector4f(0.89f, 0.86f, 0.35f, 0.8f);
                                break;
                            }
                            case "serenadeofwater": {
                                color = new Vector4f(0.6f, 0.78f, 0.98f, 0.8f);
                                break;
                            }
                            case "minuetofforest": {
                                color = new Vector4f(0.21f, 0.9f, 0.31f, 0.8f);
                                break;
                            }
                            default: {
                                color = new Vector4f(1.0f, 1.0f, 1.0f, 0.8f);
                            }
                        }
                        float opacity = (int)(17.0f - fx_zoomCount / 8.0f);
                        opacity = opacity * 1.15f / 15.0f - 0.01f;
                        double angle = Math.PI * 2 * (double)fx_rotateCount / 80.0;
                        float x2 = (float)Math.cos(angle);
                        float scaleFade = (40.0f + (fx_zoomCount - 70.0f)) / 40.0f;
                        GL11.glEnable((int)3042);
                        GL11.glPushMatrix();
                        GL11.glTranslatef((float)x, (float)(res.func_78328_b() / 2), (float)0.0f);
                        GL11.glRotated((double)(-fx_rotateCount / 2.0f), (double)0.0, (double)0.0, (double)10.0);
                        GL11.glScalef((float)(1.0f + x2 / 7.0f + scaleFade), (float)(1.0f + x2 / 7.0f + scaleFade), (float)1.0f);
                        GlStateManager.func_179131_c((float)color.getX(), (float)color.getY(), (float)color.getZ(), (float)Utils.clamp(opacity, 0.0f, 0.98f));
                        mc.func_110434_K().func_110577_a(Ocarina_OVERLAY_FX);
                        GuiScreen.func_146110_a((int)(-res.func_78326_a()), (int)((int)((float)(-res.func_78328_b()) * 1.5f)), (float)(res.func_78326_a() * 2), (float)(res.func_78328_b() * 3), (int)(res.func_78326_a() * 2), (int)(res.func_78328_b() * 3), (float)(res.func_78326_a() * 2), (float)(res.func_78328_b() * 3));
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        GL11.glPopMatrix();
                        x2 = (float)Math.cos(angle) * 1.5f;
                        GL11.glPushMatrix();
                        GL11.glTranslatef((float)x, (float)(res.func_78328_b() / 2), (float)0.0f);
                        GL11.glRotated((double)fx_rotateCount, (double)0.0, (double)0.0, (double)10.0);
                        GL11.glScalef((float)(1.0f + x2 / 9.0f + scaleFade), (float)(1.0f + x2 / 9.0f + scaleFade), (float)1.0f);
                        GlStateManager.func_179131_c((float)color.getX(), (float)color.getY(), (float)color.getZ(), (float)Utils.clamp(opacity, 0.0f, 0.99f));
                        mc.func_110434_K().func_110577_a(Ocarina_OVERLAY_FX);
                        GuiScreen.func_146110_a((int)(-res.func_78326_a()), (int)((int)((float)(-res.func_78328_b()) * 1.5f)), (float)(res.func_78326_a() * 2), (float)(res.func_78328_b() * 3), (int)(res.func_78326_a() * 2), (int)(res.func_78328_b() * 3), (float)(res.func_78326_a() * 2), (float)(res.func_78328_b() * 3));
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        GL11.glPopMatrix();
                        GL11.glDisable((int)3042);
                        GL11.glPushMatrix();
                        color = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
                        GlStateManager.func_179131_c((float)color.getX(), (float)color.getY(), (float)color.getZ(), (float)1.0f);
                        String s = I18n.func_135052_a((String)"Ocarina.Played", (Object[])new Object[0]);
                        float scale = 1.25f * (float)res.func_78325_e() / 2.5f;
                        GL11.glScalef((float)scale, (float)scale, (float)scale);
                        opacity = (int)(262.0f - (6.2f * zoomCount - 179.0f));
                        int textColor = Utils.colorToInt(opacity, 255, 255, 255);
                        String songNameText = "";
                        switch (this.songName) {
                            case "sunssong": {
                                songNameText = I18n.func_135052_a((String)"Ocarina.sunssong", (Object[])new Object[0]);
                                textColor = Utils.colorToInt(opacity, 255, 255, 0);
                                break;
                            }
                            case "songofstorms": {
                                songNameText = I18n.func_135052_a((String)"Ocarina.songofstorms", (Object[])new Object[0]);
                                textColor = Utils.colorToInt(opacity, 180, 155, 255);
                                break;
                            }
                            case "bolerooffire": {
                                songNameText = I18n.func_135052_a((String)"Ocarina.bolerooffire", (Object[])new Object[0]);
                                textColor = Utils.colorToInt(opacity, 255, 0, 0);
                                break;
                            }
                            case "horsesong": {
                                songNameText = this.horseName != "" ? this.horseName + "'s Song" : I18n.func_135052_a((String)"Ocarina.horsesong", (Object[])new Object[0]);
                                textColor = Utils.colorToInt(opacity, 255, 180, 40);
                                break;
                            }
                            case "preludeoflight": {
                                songNameText = I18n.func_135052_a((String)"Ocarina.preludeoflight", (Object[])new Object[0]);
                                textColor = Utils.colorToInt(opacity, 245, 238, 180);
                                break;
                            }
                            case "serenadeofwater": {
                                songNameText = I18n.func_135052_a((String)"Ocarina.serenadeofwater", (Object[])new Object[0]);
                                textColor = Utils.colorToInt(opacity, 200, 220, 250);
                                break;
                            }
                            case "minuetofforest": {
                                songNameText = I18n.func_135052_a((String)"Ocarina.minuetofforest", (Object[])new Object[0]);
                                textColor = Utils.colorToInt(opacity, 55, 230, 80);
                                break;
                            }
                            default: {
                                textColor = Utils.colorToInt(opacity, 255, 0, 0);
                            }
                        }
                        int px = (int)((float)x / scale) - 0;
                        scale = 1.25f * (float)res.func_78325_e() / 2.5f;
                        y = res.func_78328_b() / 2;
                        int py2 = res.func_78328_b() - 55 * res.func_78325_e();
                        int playedTextLeng = mc.field_71466_p.func_78256_a(s);
                        int sontTextLeng = mc.field_71466_p.func_78256_a(songNameText);
                        int totalTextLeng = playedTextLeng + sontTextLeng;
                        mc.field_71466_p.func_175063_a(s, (float)(px - totalTextLeng / 2 + res.func_78326_a() / 2 / totalTextLeng), (float)py2, Utils.colorToInt(opacity, 255, 255, 255));
                        mc.field_71466_p.func_175063_a(songNameText, (float)(px - totalTextLeng / 2 + res.func_78326_a() / 2 / totalTextLeng + playedTextLeng + 4), (float)py2, textColor);
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        GL11.glPopMatrix();
                    } else {
                        fx_rotateCount = 0.0f;
                    }
                    if (this.playing | fx_zoomCount != 70.0f) {
                        y = 1 + res.func_78325_e();
                        int py = (int)Math.abs(zoomCount - 70.0f);
                        GL11.glPushMatrix();
                        color = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
                        GlStateManager.func_179131_c((float)color.getX(), (float)color.getY(), (float)color.getZ(), (float)1.0f);
                        mc.func_110434_K().func_110577_a(Ocarina_OVERLAYS);
                        GuiScreen.func_146110_a((int)0, (int)0, (float)0.0f, (float)0.0f, (int)width, (int)(y + (int)((double)py * 1.1) - 10), (float)256.0f, (float)256.0f);
                        y = res.func_78328_b() + 5 / (1 + res.func_78325_e());
                        mc.func_110434_K().func_110577_a(Ocarina_OVERLAYS);
                        GuiScreen.func_146110_a((int)0, (int)(y - (int)((double)py * 1.1) + 10), (float)0.0f, (float)0.0f, (int)width, (int)100, (float)256.0f, (float)256.0f);
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        GL11.glPopMatrix();
                    }
                }
            }
        }
    }

    public static enum Operation {
        NIGHTCOMMAND,
        EDIT,
        DELETE,
        SELECT,
        OPENEDIT;

    }
}

