/*
 * Decompiled with CFR 0.152.
 */
package vaskii.ambience.objects.blocks;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vaskii.ambience.Init.BlockInit;
import vaskii.ambience.network4.MyMessage4;
import vaskii.ambience.network4.NetworkHandler4;
import vaskii.ambience.objects.blocks.BlockBase;
import vaskii.ambience.objects.blocks.SpeakerTileEntity;
import vazkii.ambience.Ambience;
import vazkii.ambience.Util.Handlers.SoundHandler;
import vazkii.ambience.Util.WorldData;
import vazkii.ambience.World.Biomes.Area;

public class SongSwitcher
extends BlockBase {
    public static final PropertyDirection FACING = BlockDirectional.field_176387_N;
    public static final PropertyInteger DIRECTION = PropertyInteger.func_177719_a((String)"direction", (int)0, (int)3);

    public SongSwitcher(String name, Material material, boolean isLit) {
        super(name, material);
        this.func_149672_a(SoundType.field_185848_a);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149711_c(2.0f);
        this.func_149752_b(10.0f);
        this.func_149715_a(0.0f);
        this.func_149713_g(0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        if (isLit) {
            this.func_149647_a(null);
        }
        if (!FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            I18n.func_135052_a((String)"SongSwitcher.Desc", (Object[])new Object[0]);
        }
    }

    public void func_190948_a(ItemStack itemstack, World world, List<String> list, ITooltipFlag flag) {
        super.func_190948_a(itemstack, world, list, flag);
        list.add(I18n.func_135052_a((String)"SongSwitcher.Desc", (Object[])new Object[0]));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)BlockDirectional.field_176387_N)) {
            default: {
                return new AxisAlignedBB(1.0, 1.0, 0.0, 0.0, 0.0, 0.24);
            }
            case NORTH: {
                return new AxisAlignedBB(1.0, 1.0, 1.0, 0.0, 0.0, 0.76);
            }
            case WEST: {
                return new AxisAlignedBB(1.0, 1.0, 1.0, 0.76, 0.0, 0.0);
            }
            case EAST: {
                return new AxisAlignedBB(0.0, 1.0, 1.0, 0.24, 0.0, 0.0);
            }
            case UP: {
                return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.24, 1.0);
            }
            case DOWN: 
        }
        return new AxisAlignedBB(1.0, 1.0, 1.0, 0.0, 0.76, 0.0);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, DIRECTION});
    }

    public IBlockState func_176203_a(int meta) {
        switch (meta) {
            case 7: {
                return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)1)).func_177226_a((IProperty)DIRECTION, (Comparable)Integer.valueOf(0));
            }
            case 8: {
                return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)1)).func_177226_a((IProperty)DIRECTION, (Comparable)Integer.valueOf(1));
            }
            case 9: {
                return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)1)).func_177226_a((IProperty)DIRECTION, (Comparable)Integer.valueOf(2));
            }
            case 10: {
                return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)1)).func_177226_a((IProperty)DIRECTION, (Comparable)Integer.valueOf(3));
            }
            case 11: {
                return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)0)).func_177226_a((IProperty)DIRECTION, (Comparable)Integer.valueOf(0));
            }
            case 12: {
                return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)0)).func_177226_a((IProperty)DIRECTION, (Comparable)Integer.valueOf(1));
            }
            case 13: {
                return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)0)).func_177226_a((IProperty)DIRECTION, (Comparable)Integer.valueOf(2));
            }
            case 14: {
                return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)0)).func_177226_a((IProperty)DIRECTION, (Comparable)Integer.valueOf(3));
            }
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        if (state.func_177228_b().values().toArray()[1].toString().contains("up")) {
            switch ((Integer)state.func_177228_b().values().toArray()[0]) {
                case 0: {
                    return 7;
                }
                case 1: {
                    return 8;
                }
                case 2: {
                    return 9;
                }
                case 3: {
                    return 10;
                }
            }
        }
        if (state.func_177228_b().values().toArray()[1].toString().contains("down")) {
            switch ((Integer)state.func_177228_b().values().toArray()[0]) {
                case 0: {
                    return 11;
                }
                case 1: {
                    return 12;
                }
                case 2: {
                    return 13;
                }
                case 3: {
                    return 14;
                }
            }
        }
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        int dir = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        IBlockState iblockstate = super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer);
        iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a((IProperty)DIRECTION, (Comparable)Integer.valueOf(dir));
        return iblockstate;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos fromPos) {
        super.func_189540_a(state, world, pos, neighborBlock, fromPos);
        Area currentArea = Area.getBlockStandingArea(pos);
        if (FMLCommonHandler.instance().getEffectiveSide().isServer() && currentArea != null) {
            currentArea.setRedstoneStrength(this.getRedstonePowerFromNeighbors(fromPos, world));
            currentArea.setOperation(Area.Operation.EDIT);
            WorldData data = new WorldData().GetArasforWorld(world);
            data.editArea(currentArea);
            data.saveData();
            Ambience.sync = true;
            if (this.getRedstonePowerFromNeighbors(fromPos, world) != 0) {
                this.setState(true, world, pos, "red", "");
            } else {
                this.setState(false, world, pos, "red", "");
            }
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        Area currentArea = Area.getBlockStandingArea(pos);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient() && currentArea != null) {
            int power = 0;
            power = this.getRedstonePowerFromNeighbors(new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p()), worldIn);
            if (power == 0) {
                power = this.getRedstonePowerFromNeighbors(new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p()), worldIn);
            }
            if (power == 0) {
                power = this.getRedstonePowerFromNeighbors(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1), worldIn);
            }
            if (power == 0) {
                power = this.getRedstonePowerFromNeighbors(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1), worldIn);
            }
            currentArea.setRedstoneStrength(power);
            currentArea.setOperation(Area.Operation.EDIT);
            NetworkHandler4.sendToServer(new MyMessage4(currentArea.SerializeThis()));
            if (power != 0) {
                this.setState(true, worldIn, pos, "red", "");
            } else {
                this.setState(false, worldIn, pos, "red", "");
            }
        }
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public int getRedstonePowerFromNeighbors(BlockPos pos, World worldIn) {
        int i = 0;
        for (EnumFacing direction : FACING.func_177700_c()) {
            if (direction.name() == "") continue;
            int j = worldIn.func_175651_c(pos, direction);
            if (j >= 15) {
                return 15;
            }
            if (j <= i) continue;
            i = j;
        }
        return i;
    }

    public void setState(boolean active, World worldIn, BlockPos pos, String color, String selectedSound) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        if (active) {
            worldIn.func_180501_a(pos, BlockInit.SongSwitcher_lit.func_176223_P().func_177226_a((IProperty)FACING, iblockstate.func_177229_b((IProperty)FACING)).func_177226_a((IProperty)DIRECTION, iblockstate.func_177229_b((IProperty)DIRECTION)), 2);
        } else {
            worldIn.func_180501_a(pos, BlockInit.SongSwitcher.func_176223_P().func_177226_a((IProperty)FACING, iblockstate.func_177229_b((IProperty)FACING)).func_177226_a((IProperty)DIRECTION, iblockstate.func_177229_b((IProperty)DIRECTION)), 2);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entity, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (FMLCommonHandler.instance().getSide().isServer() | !world.field_72995_K) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74768_a("delay", ((SpeakerTileEntity)world.func_175625_s((BlockPos)pos)).delay);
            tagCompound.func_74778_a("selectedSound", ((SpeakerTileEntity)world.func_175625_s((BlockPos)pos)).selectedSound);
            tagCompound.func_74782_a("pos", (NBTBase)this.getPosListTag(pos));
            tagCompound.func_74757_a("loop", ((SpeakerTileEntity)world.func_175625_s((BlockPos)pos)).loop);
            tagCompound.func_74776_a("distance", ((SpeakerTileEntity)world.func_175625_s((BlockPos)pos)).distance);
            tagCompound.func_74778_a("openGui", "open");
            tagCompound.func_74768_a("index", this.getListSelectedIndex(((SpeakerTileEntity)world.func_175625_s((BlockPos)pos)).selectedSound));
            if (entity.func_184614_ca().func_82833_r().contains("Soundnizer")) {
                NetworkHandler4.sendToClient(new MyMessage4(tagCompound), (EntityPlayerMP)entity);
            }
        }
        return true;
    }

    private int getListSelectedIndex(String selectedSound) {
        int SelectedItemIndex = 0;
        if (selectedSound != null) {
            for (String sound : SoundHandler.SOUNDS) {
                if (sound.contains(selectedSound)) break;
                ++SelectedItemIndex;
            }
        }
        return SelectedItemIndex;
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        if (FMLCommonHandler.instance().getSide().isServer()) {
            EntityPlayer player = worldIn.func_184137_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 10.0, false);
            Area currentArea = Area.getBlockStandingArea(pos);
            currentArea.setRedstoneStrength(0);
            currentArea.setOperation(Area.Operation.EDIT);
            NetworkHandler4.sendToServer(new MyMessage4(currentArea.SerializeThis()));
        }
        super.func_180652_a(worldIn, pos, explosionIn);
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        if (FMLCommonHandler.instance().getSide().isClient() | worldIn.field_72995_K) {
            EntityPlayer player = worldIn.func_184137_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 10.0, false);
            Area currentArea = Area.getBlockStandingArea(pos);
            if (currentArea != null) {
                currentArea.setRedstoneStrength(0);
                currentArea.setOperation(Area.Operation.EDIT);
                NetworkHandler4.sendToServer(new MyMessage4(currentArea.SerializeThis()));
            }
        }
        super.func_176206_d(worldIn, pos, state);
    }

    public NBTTagList getPosListTag(BlockPos pos) {
        NBTTagList tagList = new NBTTagList();
        NBTTagCompound posCompound = new NBTTagCompound();
        posCompound.func_74768_a("x", pos.func_177958_n());
        posCompound.func_74768_a("y", pos.func_177956_o());
        posCompound.func_74768_a("z", pos.func_177952_p());
        tagList.func_74742_a((NBTBase)posCompound);
        return tagList;
    }
}

