/*
 * Decompiled with CFR 0.152.
 */
package vazkii.ambience.network;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import vazkii.ambience.Ambience;
import vazkii.ambience.Screens.EditAreaScreen;
import vazkii.ambience.Screens.SpeakerContainer;
import vazkii.ambience.SongPicker;
import vazkii.ambience.Util.Handlers.EventHandlers;
import vazkii.ambience.Util.WorldData;
import vazkii.ambience.World.Biomes.Area;
import vazkii.ambience.blocks.AlarmTileEntity;
import vazkii.ambience.blocks.SpeakerTileEntity;
import vazkii.ambience.items.Soundnizer;
import vazkii.ambience.network.AmbiencePackageHandler;

public class MyMessage {
    private CompoundNBT data;

    public MyMessage() {
    }

    public MyMessage(PacketBuffer buf) {
        this.data = buf.func_150793_b();
    }

    public MyMessage(CompoundNBT Data) {
        this.data = Data;
    }

    public void encode(PacketBuffer buf) {
        buf.func_150786_a(this.data);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        context.get().enqueueWork(() -> {
            if (ctx.getDirection() == NetworkDirection.PLAY_TO_SERVER) {
                BlockPos pos;
                CompoundNBT EventSound = this.data;
                ServerWorld world = (ServerWorld)ctx.getSender().field_70170_p;
                if (EventSound.func_74764_b("playingJuckebox")) {
                    CompoundNBT nbt = new CompoundNBT();
                    nbt.func_74757_a("playingJuckebox", EventSound.func_74767_n("playingJuckebox"));
                    AmbiencePackageHandler.sendToAll(new MyMessage(nbt));
                }
                if (EventSound.func_74764_b("forcedPlayID")) {
                    for (String players : this.getOppedList()) {
                        if (!players.contains(ctx.getSender().func_145748_c_().getString())) continue;
                        CompoundNBT nbt = new CompoundNBT();
                        nbt.func_74757_a("forcedPlay", EventSound.func_74767_n("forcedPlay"));
                        nbt.func_74768_a("forcedPlayID", EventSound.func_74762_e("forcedPlayID"));
                        AmbiencePackageHandler.sendToAll(new MyMessage(nbt));
                    }
                }
                Soundnizer.clickedSpeakerOrAlarm = EventSound.func_74767_n("ClickedSpeakerOrAlarm");
                if (EventSound.func_74779_i("SoundEvent") != null & !EventSound.func_74779_i("SoundEvent").isEmpty() && !SpeakerContainer.isAlarm) {
                    pos = new BlockPos(EventSound.func_74762_e("x"), EventSound.func_74762_e("y"), EventSound.func_74762_e("z"));
                    ((SpeakerTileEntity)world.func_175625_s((BlockPos)pos)).selectedSound = EventSound.func_74779_i("SoundEvent");
                    ((SpeakerTileEntity)world.func_175625_s((BlockPos)pos)).delay = EventSound.func_74762_e("delay");
                    ((SpeakerTileEntity)world.func_175625_s((BlockPos)pos)).loop = EventSound.func_74767_n("loop");
                    ((SpeakerTileEntity)world.func_175625_s((BlockPos)pos)).distance = EventSound.func_74762_e("distance");
                    ((SpeakerTileEntity)world.func_175625_s((BlockPos)pos)).countPlay = 0;
                    ((SpeakerTileEntity)world.func_175625_s((BlockPos)pos)).sync = true;
                    ((NetworkEvent.Context)context.get()).setPacketHandled(true);
                }
                if (EventSound.func_74779_i("SoundEvent") != null & !EventSound.func_74779_i("SoundEvent").isEmpty() && SpeakerContainer.isAlarm) {
                    pos = SpeakerContainer.pos;
                    ((AlarmTileEntity)world.func_175625_s((BlockPos)pos)).selectedSound = EventSound.func_74779_i("SoundEvent");
                    ((AlarmTileEntity)world.func_175625_s((BlockPos)pos)).delay = EventSound.func_74762_e("delay");
                    ((AlarmTileEntity)world.func_175625_s((BlockPos)pos)).loop = EventSound.func_74767_n("loop");
                    ((AlarmTileEntity)world.func_175625_s((BlockPos)pos)).distance = EventSound.func_74762_e("distance");
                    ((AlarmTileEntity)world.func_175625_s((BlockPos)pos)).countPlay = 0;
                    ((AlarmTileEntity)world.func_175625_s((BlockPos)pos)).sync = true;
                    ((NetworkEvent.Context)context.get()).setPacketHandled(true);
                }
                if (EventSound.func_74779_i("Name") != null & EventSound.func_74779_i("Name") != "") {
                    Area area = Area.DeSerialize(this.data);
                    world = (ServerWorld)ctx.getSender().field_70170_p;
                    WorldData data = new WorldData().GetArasforWorld(world);
                    CompoundNBT updatedAreas = null;
                    switch (area.getOperation()) {
                        case CREATE: {
                            data.addArea(area);
                            updatedAreas = WorldData.SerializeThis(Ambience.getWorldData().listAreas);
                            AmbiencePackageHandler.sendToAll(new MyMessage(updatedAreas));
                            this.ClearSelection(ctx);
                            break;
                        }
                        case DELETE: {
                            data.removeArea(area);
                            updatedAreas = WorldData.SerializeThis(Ambience.getWorldData().listAreas);
                            AmbiencePackageHandler.sendToAll(new MyMessage(updatedAreas));
                            this.ClearSelection(ctx);
                            break;
                        }
                        case EDIT: {
                            data.editArea(area);
                            updatedAreas = WorldData.SerializeThis(Ambience.getWorldData().listAreas);
                            AmbiencePackageHandler.sendToAll(new MyMessage(updatedAreas));
                            break;
                        }
                        case SELECT: {
                            Ambience.selectedArea = area;
                            Ambience.previewArea = area;
                            Soundnizer.BlockName = area.getSelectedBlock();
                            AmbiencePackageHandler.sendToAll(new MyMessage(Ambience.selectedArea.SerializeThis()));
                            break;
                        }
                        default: {
                            data.addArea(area);
                        }
                    }
                    data.saveData();
                    Ambience.getWorldData().listAreas = data.listAreas;
                    Ambience.sync = true;
                }
            } else {
                CompoundNBT EventSound = this.data;
                if (EventSound.func_74764_b("playAdvancement")) {
                    EventHandlers.onAdvancement();
                }
                if (EventSound.func_74764_b("StructureName")) {
                    SongPicker.StructureName = EventSound.func_74779_i("StructureName");
                }
                if (EventSound.func_74764_b("playingJuckebox")) {
                    Ambience.playingJuckebox = EventSound.func_74767_n("playingJuckebox");
                }
                if (EventSound.func_74764_b("forcedPlayID")) {
                    SongPicker.forcePlayID = EventSound.func_74762_e("forcedPlayID");
                    Ambience.forcePlay = EventSound.func_74767_n("forcedPlay");
                }
                if (this.data.func_74779_i("op") == "" && EventSound.func_74779_i("selectedSound") != null) {
                    SpeakerContainer.selectedSound = EventSound.func_74779_i("selectedSound");
                    SpeakerContainer.delay = EventSound.func_74762_e("delay");
                    SpeakerContainer.loop = EventSound.func_74767_n("loop");
                    SpeakerContainer.distance = EventSound.func_74760_g("distance");
                    SpeakerContainer.dimension = EventSound.func_74779_i("dimension");
                    SpeakerContainer.pos = new BlockPos(EventSound.func_74775_l("pos").func_74762_e("x"), EventSound.func_74775_l("pos").func_74762_e("y"), EventSound.func_74775_l("pos").func_74762_e("z"));
                    SpeakerContainer.isAlarm = EventSound.func_74767_n("isAlarm");
                    ((NetworkEvent.Context)context.get()).setPacketHandled(true);
                    if (EventSound.func_74779_i("stop").contains("stop")) {
                        Minecraft.func_71410_x().func_147118_V().func_195478_a(new ResourceLocation(EventSound.func_74779_i("sound")), SoundCategory.BLOCKS);
                    }
                }
                if (EventSound.func_74779_i("Name") != null) {
                    Area area = Area.DeSerialize(this.data);
                    if (EventSound.func_74762_e("lenght") != 0) {
                        Ambience.getWorldData().listAreas = Area.DeSerializeList(this.data);
                        if (Ambience.selectedArea != null) {
                            Ambience.selectedArea.resetSelection();
                        }
                    } else {
                        switch (area.getOperation()) {
                            case OPENEDIT: {
                                EditAreaScreen.currentArea = area;
                                if (Ambience.previewArea.getName() != "Area1") break;
                                Ambience.previewArea = new Area("Area1");
                                break;
                            }
                            case EDIT: {
                                area.setOperation(Area.Operation.EDIT);
                                AmbiencePackageHandler.sendToServer(new MyMessage(area.SerializeThis()));
                                break;
                            }
                            case SELECT: {
                                Ambience.selectedArea = area;
                                Ambience.previewArea = area;
                            }
                        }
                    }
                }
            }
        });
        context.get().setPacketHandled(true);
    }

    private void ClearSelection(NetworkEvent.Context ctx) {
        Ambience.selectedArea = new Area("Area1");
        Ambience.previewArea = new Area("Area1");
        Ambience.selectedArea.setOperation(Area.Operation.SELECT);
        AmbiencePackageHandler.sendToClient(new MyMessage(Ambience.selectedArea.SerializeThis()), ctx.getSender());
    }

    private List<String> getOppedList() {
        ArrayList<String> ops = new ArrayList<String>();
        try {
            FileInputStream stream = new FileInputStream(PlayerList.field_152615_c);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)stream, "UTF-8"));
            JsonParser parser = new JsonParser();
            JsonElement obj = parser.parse((Reader)reader);
            if (obj != null) {
                String[] arrOfStr = obj.toString().split("\"name\":\"");
                ArrayList result = new ArrayList();
                for (int i = 1; i < arrOfStr.length; ++i) {
                    String[] arrOfStr2 = arrOfStr[i].split(",");
                    ops.add(arrOfStr2[0].replace("\"", ""));
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return ops;
    }
}

