/*
 * Decompiled with CFR 0.152.
 */
package vazkii.ambience.items;

import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.ambience.items.ItemBase;

public class Horn
extends ItemBase {
    public static int fadeOutTimer;
    public static boolean shouting;
    public static PlayerEntity player;

    public Horn(int Maxdamage) {
        super(Maxdamage);
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 2000;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        boolean flag = true;
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        ActionResult ret = ForgeEventFactory.onArrowNock((ItemStack)itemstack, (World)worldIn, (PlayerEntity)playerIn, (Hand)handIn, (boolean)flag);
        if (ret != null) {
            return ret;
        }
        itemstack.func_222118_a(1, (LivingEntity)playerIn, damage -> damage.func_213334_d(playerIn.func_184600_cs()));
        if (!playerIn.field_71075_bZ.field_75098_d && !flag) {
            return ActionResult.func_226251_d_((Object)itemstack);
        }
        playerIn.func_184598_c(handIn);
        shouting = true;
        fadeOutTimer = 380;
        player = playerIn;
        return ActionResult.func_226249_b_((Object)itemstack);
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        fadeOutTimer = 0;
        shouting = false;
    }

    public static void repelEntities(World worldIn, PlayerEntity playerIn, double force) {
        List entities = worldIn.func_217357_a(Entity.class, new AxisAlignedBB(playerIn.func_226277_ct_() - 20.0, playerIn.func_226278_cu_() - 10.0, playerIn.func_226281_cx_() - 20.0, playerIn.func_226277_ct_() + 20.0, playerIn.func_226278_cu_() + 10.0, playerIn.func_226281_cx_() + 20.0));
        BlockPos pos = player.func_233580_cy_();
        if (shouting) {
            shouting = false;
            int rand = Horn.getRandom(1, 3);
            worldIn.func_184133_a(playerIn, playerIn.func_233580_cy_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("ambience:horn" + rand)), SoundCategory.AMBIENT, 10.0f, 1.0f);
        }
        if (worldIn.field_72995_K) {
            return;
        }
        int radius = 8;
        for (Entity entity : entities) {
            double distance = Math.sqrt(entity.func_70092_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()));
            if (!(distance < (double)radius) || distance == 0.0) continue;
            if (distance < 1.0) {
                distance = 1.0;
            }
            double knockbackMultiplier = force + force / distance;
            double reductionCoefficient = 0.04;
            Vector3d angleOfAttack = entity.func_213303_ch().func_72441_c(-((double)pos.func_177958_n() + 0.5), -((double)pos.func_177956_o() - 0.8), -((double)pos.func_177952_p() + 0.5));
            double xForce = angleOfAttack.field_72450_a * knockbackMultiplier * reductionCoefficient;
            double yForce = angleOfAttack.field_72448_b * knockbackMultiplier * reductionCoefficient;
            double zForce = angleOfAttack.field_72449_c * knockbackMultiplier * reductionCoefficient;
            entity.func_213317_d(entity.func_213322_ci().func_72441_c(xForce, yForce, zForce));
            if (entity instanceof PlayerEntity) {
                playerIn.func_195064_c(new EffectInstance(Effects.field_76424_c, 1200, 0));
                playerIn.func_195064_c(new EffectInstance(Effects.field_76429_m, 1200, 3));
            }
            if (!(entity instanceof MonsterEntity)) continue;
            ((MonsterEntity)entity).func_195064_c(new EffectInstance(Effects.field_76437_t, 100, 1));
            ((MonsterEntity)entity).field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)entity, PlayerEntity.class, 16.0f, 3.5, 2.2));
        }
    }

    public static int getRandom(int min, int max) {
        int x = (int)(Math.random() * (double)(max - min + 1) + (double)min);
        return x;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"Horn.Desc", (Object[])new Object[0])));
    }

    static {
        shouting = false;
    }
}

