/*
 * Decompiled with CFR 0.152.
 */
package vazkii.ambience.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import vazkii.ambience.Ambience;
import vazkii.ambience.Util.WorldData;
import vazkii.ambience.World.Biomes.Area;
import vazkii.ambience.network.AmbiencePackageHandler;
import vazkii.ambience.network.MyMessage;

public class UpdateAreaCommand {
    private static final SuggestionProvider<CommandSource> SUGGEST_AREA = (source, builder) -> {
        ArrayList<String> AreasNames = new ArrayList<String>();
        for (Area entry : Ambience.getWorldData().listAreas) {
            if (entry.getName().contains(".")) continue;
            AreasNames.add(entry.getName());
        }
        return ISuggestionProvider.func_197005_b(AreasNames, (SuggestionsBuilder)builder);
    };

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder root = Commands.func_197057_a((String)"areaedit");
        root.then(Commands.func_197056_a((String)"areaID", (ArgumentType)IntegerArgumentType.integer()).then(Commands.func_197056_a((String)"areaName", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_AREA).then(Commands.func_197056_a((String)"position1", (ArgumentType)BlockPosArgument.func_197276_a()).then(Commands.func_197056_a((String)"position2", (ArgumentType)BlockPosArgument.func_197276_a()).then(Commands.func_197056_a((String)"playInstant", (ArgumentType)BoolArgumentType.bool()).then(Commands.func_197056_a((String)"playAtNight", (ArgumentType)BoolArgumentType.bool()).executes(source -> UpdateAreaCommand.editAreaByID((CommandSource)source.getSource(), (PlayerEntity)((CommandSource)source.getSource()).func_197035_h(), IntegerArgumentType.getInteger((CommandContext)source, (String)"areaID"), StringArgumentType.getString((CommandContext)source, (String)"areaName"), BlockPosArgument.func_197274_b((CommandContext)source, (String)"position1"), BlockPosArgument.func_197274_b((CommandContext)source, (String)"position2"), BoolArgumentType.getBool((CommandContext)source, (String)"playInstant"), BoolArgumentType.getBool((CommandContext)source, (String)"playAtNight")))))))));
        root.then(Commands.func_197056_a((String)"oldPosition", (ArgumentType)BlockPosArgument.func_197276_a()).then(Commands.func_197056_a((String)"areaName", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_AREA).then(Commands.func_197056_a((String)"position1", (ArgumentType)BlockPosArgument.func_197276_a()).then(Commands.func_197056_a((String)"position2", (ArgumentType)BlockPosArgument.func_197276_a()).then(Commands.func_197056_a((String)"playInstant", (ArgumentType)BoolArgumentType.bool()).then(Commands.func_197056_a((String)"playAtNight", (ArgumentType)BoolArgumentType.bool()).executes(source -> UpdateAreaCommand.editAreaByPosition((CommandSource)source.getSource(), (PlayerEntity)((CommandSource)source.getSource()).func_197035_h(), BlockPosArgument.func_197274_b((CommandContext)source, (String)"oldPosition"), StringArgumentType.getString((CommandContext)source, (String)"areaName"), BlockPosArgument.func_197274_b((CommandContext)source, (String)"position1"), BlockPosArgument.func_197274_b((CommandContext)source, (String)"position2"), BoolArgumentType.getBool((CommandContext)source, (String)"playInstant"), BoolArgumentType.getBool((CommandContext)source, (String)"playAtNight")))))))));
        dispatcher.register(root);
    }

    public static int editAreaByID(CommandSource source, PlayerEntity player, int areaID, String areaName, BlockPos pos1, BlockPos pos2, Boolean playInstant, Boolean playAtNight) {
        Area currentArea = null;
        currentArea = Area.getAreabyID(areaID);
        if (currentArea != null) {
            currentArea.setOperation(Area.Operation.EDIT);
            currentArea.setName(areaName);
            currentArea.setPlayAtNight(playAtNight);
            currentArea.setInstantPlay(playInstant);
            currentArea.setPos1(new Vector3d((double)pos1.func_177958_n(), (double)pos1.func_177956_o(), (double)pos1.func_177952_p()));
            currentArea.setPos2(new Vector3d((double)pos2.func_177958_n(), (double)pos2.func_177956_o(), (double)pos2.func_177952_p()));
            Ambience.sync = true;
            CompoundNBT updatedAreas = null;
            WorldData data = new WorldData().GetArasforWorld((ServerWorld)player.field_70170_p);
            data.editArea(currentArea);
            updatedAreas = WorldData.SerializeThis(Ambience.getWorldData().listAreas);
            AmbiencePackageHandler.sendToAll(new MyMessage(updatedAreas));
            data.saveData();
            Ambience.getWorldData().listAreas = data.listAreas;
            source.func_197030_a((ITextComponent)new TranslationTextComponent(TextFormatting.GREEN + "Region updated with success!"), true);
            return 1;
        }
        source.func_197030_a((ITextComponent)new TranslationTextComponent(TextFormatting.RED + "Region not found for the ID '" + areaID + "'"), true);
        return 0;
    }

    public static int editAreaByPosition(CommandSource source, PlayerEntity player, BlockPos pos, String areaName, BlockPos pos1, BlockPos pos2, Boolean playInstant, Boolean playAtNight) {
        Area currentArea = null;
        currentArea = Area.getBlockStandingArea(pos);
        if (currentArea != null) {
            currentArea.setOperation(Area.Operation.EDIT);
            currentArea.setName(areaName);
            currentArea.setPlayAtNight(playAtNight);
            currentArea.setInstantPlay(playInstant);
            currentArea.setPos1(new Vector3d((double)pos1.func_177958_n(), (double)pos1.func_177956_o(), (double)pos1.func_177952_p()));
            currentArea.setPos2(new Vector3d((double)pos2.func_177958_n(), (double)pos2.func_177956_o(), (double)pos2.func_177952_p()));
            Ambience.sync = true;
            CompoundNBT updatedAreas = null;
            WorldData data = new WorldData().GetArasforWorld((ServerWorld)player.field_70170_p);
            data.editArea(currentArea);
            updatedAreas = WorldData.SerializeThis(Ambience.getWorldData().listAreas);
            AmbiencePackageHandler.sendToAll(new MyMessage(updatedAreas));
            data.saveData();
            Ambience.getWorldData().listAreas = data.listAreas;
            source.func_197030_a((ITextComponent)new TranslationTextComponent(TextFormatting.GREEN + "Region updated with success!"), true);
            return 1;
        }
        source.func_197030_a((ITextComponent)new TranslationTextComponent(TextFormatting.RED + "Region not found."), true);
        return 0;
    }
}

