/*
 * Decompiled with CFR 0.152.
 */
package vazkii.ambience.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import vazkii.ambience.Ambience;
import vazkii.ambience.Util.WorldData;
import vazkii.ambience.World.Biomes.Area;
import vazkii.ambience.network.AmbiencePackageHandler;
import vazkii.ambience.network.MyMessage;

public class DeleteAreaCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder root = Commands.func_197057_a((String)"areadel");
        root.then(Commands.func_197056_a((String)"areaID", (ArgumentType)IntegerArgumentType.integer()).executes(source -> DeleteAreaCommand.deleteAreabyID((CommandSource)source.getSource(), (PlayerEntity)((CommandSource)source.getSource()).func_197035_h(), IntegerArgumentType.getInteger((CommandContext)source, (String)"areaID"))));
        root.then(Commands.func_197056_a((String)"position", (ArgumentType)BlockPosArgument.func_197276_a()).executes(source -> DeleteAreaCommand.deleteAreabyPosition((CommandSource)source.getSource(), (PlayerEntity)((CommandSource)source.getSource()).func_197035_h(), BlockPosArgument.func_197274_b((CommandContext)source, (String)"position"))));
        dispatcher.register(root);
    }

    public static int deleteAreabyID(CommandSource source, PlayerEntity player, int areaID) {
        Area currentArea = null;
        currentArea = Area.getAreabyID(areaID);
        if (currentArea != null) {
            currentArea.setOperation(Area.Operation.DELETE);
            Ambience.sync = true;
            CompoundNBT updatedAreas = null;
            WorldData data = new WorldData().GetArasforWorld((ServerWorld)player.field_70170_p);
            data.removeArea(currentArea);
            updatedAreas = WorldData.SerializeThis(Ambience.getWorldData().listAreas);
            AmbiencePackageHandler.sendToAll(new MyMessage(updatedAreas));
            data.saveData();
            Ambience.getWorldData().listAreas = data.listAreas;
            source.func_197030_a((ITextComponent)new TranslationTextComponent(TextFormatting.GREEN + "Region removed with success!"), true);
            return 1;
        }
        source.func_197030_a((ITextComponent)new TranslationTextComponent(TextFormatting.RED + "Region not found for the ID '" + areaID + "'"), true);
        return 0;
    }

    public static int deleteAreabyPosition(CommandSource source, PlayerEntity player, BlockPos pos) {
        Area currentArea = null;
        currentArea = Area.getBlockStandingArea(pos);
        if (currentArea != null) {
            currentArea.setOperation(Area.Operation.DELETE);
            Ambience.sync = true;
            CompoundNBT updatedAreas = null;
            WorldData data = new WorldData().GetArasforWorld((ServerWorld)player.field_70170_p);
            data.removeArea(currentArea);
            updatedAreas = WorldData.SerializeThis(Ambience.getWorldData().listAreas);
            AmbiencePackageHandler.sendToAll(new MyMessage(updatedAreas));
            data.saveData();
            Ambience.getWorldData().listAreas = data.listAreas;
            source.func_197030_a((ITextComponent)new TranslationTextComponent(TextFormatting.GREEN + "Region removed with success!"), true);
            return 1;
        }
        source.func_197030_a((ITextComponent)new TranslationTextComponent(TextFormatting.RED + "Region not found for the selected coordinate."), true);
        return 0;
    }
}

